/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.level.feature.config.UndergroundRuinsFeatureConfiguration;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class UndergroundRuinsFeature
extends Feature<UndergroundRuinsFeatureConfiguration> {
    public UndergroundRuinsFeature(Codec<UndergroundRuinsFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<UndergroundRuinsFeatureConfiguration> context) {
        BlockPos blockpos;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos chunkCenter = context.m_159777_().m_175288_(level.m_141937_() + 3);
        ArrayList<BlockPos> genPos = new ArrayList<BlockPos>();
        int surface = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, chunkCenter.m_123341_(), chunkCenter.m_123343_()) - 5;
        int j = 0;
        while (chunkCenter.m_123342_() < surface) {
            BlockPos next = chunkCenter.m_7494_();
            BlockState currentState = level.m_8055_(chunkCenter);
            BlockState nextState = level.m_8055_(next);
            if (!this.canReplace(currentState, j) && this.canReplace(nextState, j + 1)) {
                genPos.add(chunkCenter);
            }
            ++j;
            chunkCenter = next;
        }
        if (genPos.isEmpty()) {
            return false;
        }
        BlockPos blockPos = blockpos = genPos.size() <= 1 ? (BlockPos)genPos.get(0) : (BlockPos)genPos.get(randomsource.m_188503_(genPos.size() - 1));
        if (!this.canGenerateAt(level, blockpos)) {
            return false;
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)randomsource);
        UndergroundRuinsFeatureConfiguration config = (UndergroundRuinsFeatureConfiguration)context.m_159778_();
        int i = randomsource.m_188503_(config.structures.size());
        StructureTemplateManager structuretemplatemanager = level.m_6018_().m_7654_().m_236738_();
        StructureTemplate structuretemplate = structuretemplatemanager.m_230359_(config.structures.get(i));
        ChunkPos chunkpos = new ChunkPos(blockpos);
        BoundingBox boundingbox = new BoundingBox(chunkpos.m_45604_() - 16, level.m_141937_(), chunkpos.m_45605_() - 16, chunkpos.m_45608_() + 16, level.m_151558_(), chunkpos.m_45609_() + 16);
        StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(rotation).m_74381_(boundingbox).m_230324_(randomsource);
        structureplacesettings = this.modifyPlacementSettings(structureplacesettings);
        Vec3i vec3i = structuretemplate.m_163808_(rotation);
        BlockPos blockpos1 = blockpos.m_7918_(-vec3i.m_123341_() / 2, 0, -vec3i.m_123343_() / 2);
        int replaceDown = 0;
        while (this.skipsOver(level.m_8055_(blockpos1), replaceDown) && blockpos1.m_123342_() < level.m_141937_()) {
            blockpos1 = blockpos1.m_7495_();
            ++replaceDown;
        }
        BlockPos blockpos2 = structuretemplate.m_74583_(blockpos1 = blockpos1.m_6625_(config.sinkBy), Mirror.NONE, rotation);
        if (structuretemplate.m_230328_((ServerLevelAccessor)level, blockpos2, blockpos2, structureplacesettings, randomsource, 18)) {
            for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : StructureTemplate.m_74517_((ServerLevelAccessor)level, (BlockPos)blockpos2, (BlockPos)blockpos2, (StructurePlaceSettings)structureplacesettings, UndergroundRuinsFeature.getDataMarkers(structuretemplate, blockpos2, rotation, false))) {
                String marker = structuretemplate$structureblockinfo.f_74677_().m_128461_("metadata");
                if (marker.equals("loot_chest")) {
                    level.m_7731_(structuretemplate$structureblockinfo.f_74675_(), Blocks.f_50627_.m_49966_(), 3);
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)randomsource, (BlockPos)structuretemplate$structureblockinfo.f_74675_().m_7495_(), (ResourceLocation)((UndergroundRuinsFeatureConfiguration)context.m_159778_()).chestLoot);
                    continue;
                }
                this.processMarker(marker, level, structuretemplate$structureblockinfo.f_74675_(), randomsource);
            }
            this.processBoundingBox(level, structuretemplate.m_74633_(structureplacesettings, blockpos2), randomsource);
        }
        return true;
    }

    public void processBoundingBox(WorldGenLevel level, BoundingBox boundingBox, RandomSource randomsource) {
    }

    public StructurePlaceSettings modifyPlacementSettings(StructurePlaceSettings structureplacesettings) {
        return structureplacesettings;
    }

    public void processMarker(String marker, WorldGenLevel level, BlockPos pos, RandomSource randomsource) {
    }

    protected boolean canGenerateAt(WorldGenLevel level, BlockPos blockpos) {
        return true;
    }

    protected boolean canReplace(BlockState state, int already) {
        return !(!state.m_60795_() && !state.m_247087_() || state.m_60819_().getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get() && already >= 3);
    }

    protected boolean skipsOver(BlockState state, int already) {
        return this.canReplace(state, already);
    }

    private static List<StructureTemplate.StructureBlockInfo> getDataMarkers(StructureTemplate structuretemplate, BlockPos p_227326_, Rotation p_227327_, boolean p_227328_) {
        ObjectArrayList list = structuretemplate.m_230335_(p_227326_, new StructurePlaceSettings().m_74379_(p_227327_), Blocks.f_50677_, p_227328_);
        ArrayList list1 = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : list) {
            StructureMode structuremode;
            if (structuretemplate$structureblockinfo.f_74677_() == null || (structuremode = StructureMode.valueOf((String)structuretemplate$structureblockinfo.f_74677_().m_128461_("mode"))) != StructureMode.DATA) continue;
            list1.add(structuretemplate$structureblockinfo);
        }
        return list1;
    }
}

