/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.feature.config.GalenaHexagonFeatureConfiguration;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class GalenaHexagonFeature
extends Feature<GalenaHexagonFeatureConfiguration> {
    public GalenaHexagonFeature(Codec<GalenaHexagonFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GalenaHexagonFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        ArrayList<BlockPos> genPos = new ArrayList<BlockPos>();
        BlockPos chunkCenter = new BlockPos(context.m_159777_().m_123341_(), level.m_141937_() + 3, context.m_159777_().m_123343_());
        int surface = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, chunkCenter.m_123341_(), chunkCenter.m_123343_());
        while (chunkCenter.m_123342_() < surface) {
            BlockPos next = chunkCenter.m_7494_();
            BlockState currentState = level.m_8055_(chunkCenter);
            BlockState nextState = level.m_8055_(next);
            if (((GalenaHexagonFeatureConfiguration)context.m_159778_()).ceiling) {
                if (nextState.m_60713_((Block)ACBlockRegistry.GALENA.get()) && GalenaHexagonFeature.canReplace(currentState)) {
                    genPos.add(chunkCenter);
                }
            } else if (currentState.m_60713_((Block)ACBlockRegistry.GALENA.get()) && GalenaHexagonFeature.canReplace(nextState)) {
                genPos.add(chunkCenter);
            }
            chunkCenter = next;
        }
        for (BlockPos floor : genPos) {
            GalenaHexagonFeature.drawHexagon(level, floor, randomSource, ((GalenaHexagonFeatureConfiguration)context.m_159778_()).hexBlock, 3 + randomSource.m_188503_(6), 1 + randomSource.m_188503_(3), !((GalenaHexagonFeatureConfiguration)context.m_159778_()).ceiling);
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    private static void drawHexagon(WorldGenLevel level, BlockPos center, RandomSource random, BlockStateProvider blockState, int height, int radius, boolean goingUp) {
        int startY = -4 - random.m_188503_(4);
        int endY = height + 1;
        for (int y = startY; y < endY; ++y) {
            int setY = y * (goingUp ? 1 : -1);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos fill = center.m_7918_(x, setY, z);
                    if (!(fill.m_203202_((double)center.m_123341_(), (double)fill.m_123342_(), (double)center.m_123343_()) <= (double)(radius * radius)) || !GalenaHexagonFeature.canReplace(level.m_8055_(fill))) continue;
                    level.m_7731_(fill, blockState.m_213972_(random, fill), 3);
                }
            }
        }
    }
}

