/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.FlightPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.ai.VesperAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VesperFlyAndHangGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VesperTargetUnderneathEntities;
import com.github.alexmodguy.alexscaves.server.entity.living.ForsakenEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GloomothEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class VesperEntity
extends Monster
implements IAnimatedEntity,
UnderzealotSacrifice {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(VesperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HANGING = SynchedEntityData.m_135353_(VesperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    private float flyProgress;
    private float prevFlyProgress;
    private float sleepProgress;
    private float prevSleepProgress;
    private float capturedProgress;
    private float prevCapturedProgress;
    private float groundProgress = 5.0f;
    private float prevGroundProgress = 5.0f;
    private boolean validHangingPos = false;
    private int checkHangingTime;
    private BlockPos prevHangPos;
    public int timeHanging = 0;
    public int timeFlying = 0;
    private float flightPitch = 0.0f;
    private float prevFlightPitch = 0.0f;
    private float flightRoll = 0.0f;
    private float prevFlightRoll = 0.0f;
    private Animation currentAnimation;
    private int animationTick;
    public int groundedFor = 0;
    private boolean isLandNavigator;
    private boolean isBeingSacrificed = false;
    private int sacrificeTime = 0;
    private int lastTargetId = -1;

    public VesperEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 52.0);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new MoveController();
            this.f_21344_ = new FlightPathNavigatorNoSpin((Mob)this, this.m_9236_(), 1.0f);
            this.isLandNavigator = false;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new VesperAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 15, false){

            public boolean m_8036_() {
                return !VesperEntity.this.isFlying() && !VesperEntity.this.isHanging() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !VesperEntity.this.isFlying() && !VesperEntity.this.isHanging() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new VesperFlyAndHangGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new VesperTargetUnderneathEntities<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new VesperTargetUnderneathEntities<GloomothEntity>(this, GloomothEntity.class));
    }

    public void m_8119_() {
        boolean captured;
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.prevSleepProgress = this.sleepProgress;
        this.prevGroundProgress = this.groundProgress;
        this.prevCapturedProgress = this.capturedProgress;
        this.prevFlightPitch = this.flightPitch;
        this.prevFlightRoll = this.flightRoll;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if (this.isHanging() && this.sleepProgress < 5.0f) {
            this.sleepProgress += 1.0f;
        }
        if (!this.isHanging() && this.sleepProgress > 0.0f) {
            this.sleepProgress -= 1.0f;
        }
        if ((captured = this.m_20159_()) && this.capturedProgress < 5.0f) {
            this.capturedProgress += 1.0f;
        }
        if (!captured && this.capturedProgress > 0.0f) {
            this.capturedProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            LivingEntity target;
            if (captured) {
                this.setFlying(false);
                this.setHanging(false);
            }
            if (this.isHanging()) {
                BlockPos above = this.posAbove();
                if (this.checkHangingTime-- < 0 || this.f_19796_.m_188501_() < 0.1f || this.prevHangPos != above) {
                    this.validHangingPos = this.canHangFrom(above, this.m_9236_().m_8055_(above));
                    this.checkHangingTime = 5 + this.f_19796_.m_188503_(5);
                    this.prevHangPos = above;
                }
                if (this.validHangingPos) {
                    this.m_20256_(this.m_20184_().m_82542_((double)0.1f, (double)0.3f, (double)0.1f).m_82520_(0.0, 0.08, 0.0));
                } else {
                    this.setHanging(false);
                    this.setFlying(true);
                }
                ++this.timeHanging;
            } else {
                this.timeHanging = 0;
                this.validHangingPos = false;
                this.prevHangPos = null;
            }
            if (this.isFlying()) {
                if (this.timeFlying % 10 == 0) {
                    this.m_216990_((SoundEvent)ACSoundRegistry.VESPER_FLAP.get());
                }
                ++this.timeFlying;
                this.m_20242_(true);
                if (this.isLandNavigator) {
                    this.switchNavigator(false);
                }
                if (this.groundedFor > 0) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
                if (!this.isLandNavigator) {
                    this.switchNavigator(true);
                }
            }
            if ((target = this.m_5448_()) == null || !target.m_6084_()) {
                this.lastTargetId = -1;
            } else if (target.m_19879_() != this.lastTargetId) {
                this.lastTargetId = target.m_19879_();
                this.m_5496_((SoundEvent)ACSoundRegistry.VESPER_SCREAM.get(), 3.0f, 1.0f);
            }
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.tickRotation((float)this.m_20184_().f_82480_ * 2.0f * -57.295776f);
        if (this.isBeingSacrificed && this.m_20159_() && !this.m_9236_().f_46443_) {
            --this.sacrificeTime;
            if (this.sacrificeTime < 10) {
                this.m_9236_().m_7605_((Entity)this, (byte)61);
            }
            if (this.sacrificeTime < 0) {
                Entity entity;
                if (this.m_20159_() && (entity = this.m_20202_()) instanceof UnderzealotEntity) {
                    UnderzealotEntity underzealot = (UnderzealotEntity)entity;
                    underzealot.postSacrifice(this);
                    underzealot.triggerIdleDigging();
                }
                this.m_8127_();
                ForsakenEntity forsakenEntity = (ForsakenEntity)this.m_21406_((EntityType)ACEntityRegistry.FORSAKEN.get(), true);
                if (forsakenEntity != null) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.FORSAKEN_SPAWN.get(), 8.0f, 1.0f);
                    forsakenEntity.setAnimation(ForsakenEntity.ANIMATION_SUMMON);
                    ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)forsakenEntity);
                    forsakenEntity.m_8127_();
                }
            }
        }
    }

    public void m_7822_(byte b) {
        if (b == 61) {
            for (int i = 0; i < 1 + this.f_19796_.m_188503_(4); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_EXPLOSION.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(b);
        }
    }

    private void tickRotation(float yMov) {
        this.flightPitch = yMov;
        float threshold = 1.0f;
        boolean flag = false;
        if (this.isFlying() && this.f_19859_ - this.m_146908_() > threshold) {
            this.flightRoll += 10.0f;
            flag = true;
        }
        if (this.isFlying() && this.f_19859_ - this.m_146908_() < -threshold) {
            this.flightRoll -= 10.0f;
            flag = true;
        }
        if (!flag) {
            if (this.flightRoll > 0.0f) {
                this.flightRoll = Math.max(this.flightRoll - 5.0f, 0.0f);
            }
            if (this.flightRoll < 0.0f) {
                this.flightRoll = Math.min(this.flightRoll + 5.0f, 0.0f);
            }
        }
        this.flightRoll = Mth.m_14036_((float)this.flightRoll, (float)-60.0f, (float)60.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(HANGING, (Object)false);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean isHanging() {
        return (Boolean)this.f_19804_.m_135370_(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.f_19804_.m_135381_(HANGING, (Object)hanging);
    }

    public float getFlightPitch(float partialTick) {
        return this.prevFlightPitch + (this.flightPitch - this.prevFlightPitch) * partialTick;
    }

    public float getFlightRoll(float partialTick) {
        return this.prevFlightRoll + (this.flightRoll - this.prevFlightRoll) * partialTick;
    }

    public float getCapturedProgress(float partialTick) {
        return (this.prevCapturedProgress + (this.capturedProgress - this.prevCapturedProgress) * partialTick) * 0.2f;
    }

    public float getSleepProgress(float partialTick) {
        return (this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTick) * 0.2f;
    }

    public float getFlyProgress(float partialTick) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTick) * 0.2f;
    }

    public float getGroundProgress(float partialTick) {
        return (this.prevGroundProgress + (this.groundProgress - this.prevGroundProgress) * partialTick) * 0.2f;
    }

    public boolean canHangFrom(BlockPos pos, BlockState state) {
        return state.m_60783_((BlockGetter)this.m_9236_(), pos, Direction.DOWN) && this.m_9236_().m_46859_(pos.m_7495_()) && this.m_9236_().m_46859_(pos.m_6625_(2));
    }

    public BlockPos posAbove() {
        return BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20191_().f_82292_ + (double)0.1f), (double)this.m_20189_());
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82377_(3.0, 3.0, 3.0);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 4.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos above = this.m_20183_();
        int upBy = 100;
        for (int k = 0; world.m_46859_(above) && above.m_123342_() < this.m_9236_().m_151558_() && k < upBy; ++k) {
            above = above.m_7494_();
        }
        if (world.m_46859_(above)) {
            this.setFlying(true);
        } else {
            this.setHanging(true);
        }
        this.m_6034_((float)above.m_123341_() + 0.5f, (double)above.m_123342_() - this.m_20191_().m_82376_(), (float)above.m_123343_() + 0.5f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static boolean checkVesperSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (VesperEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource)) {
            BlockPos.MutableBlockPos above = new BlockPos.MutableBlockPos();
            above.m_122190_((Vec3i)blockPos);
            int k = 0;
            while (levelAccessor.m_46859_((BlockPos)above) && above.m_123342_() < levelAccessor.m_151558_()) {
                above.m_122184_(0, 1, 0);
                if (++k <= 5) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void triggerSacrificeIn(int time) {
        this.isBeingSacrificed = true;
        this.sacrificeTime = time;
    }

    @Override
    public boolean isValidSacrifice(int distanceFromGround) {
        return distanceFromGround < (this.isHanging() ? 3 : 9);
    }

    public int m_8100_() {
        return this.isHanging() ? 80 : 140;
    }

    protected SoundEvent m_7515_() {
        return this.isHanging() ? (SoundEvent)ACSoundRegistry.VESPER_QUIET_IDLE.get() : (SoundEvent)ACSoundRegistry.VESPER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.VESPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.VESPER_DEATH.get();
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)VesperEntity.this);
            this.parentEntity = VesperEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.parentEntity.m_146922_(Mth.m_14148_((float)this.parentEntity.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }
}

