/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotorFlightGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotorHologramGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotorScanGoal;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class NotorEntity
extends PathfinderMob {
    private float groundProgress;
    private float prevGroundProgress;
    private float beamProgress;
    private float prevBeamProgress;
    private float hologramProgress;
    private float prevHologramProgress;
    private float propellerRot;
    private float prevPropellerRot;
    public int stopScanningFor;
    private static final EntityDataAccessor<Boolean> SHOWING_HOLOGRAM = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> HOLOGRAM_POS = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> SCANNING_ID = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> HOLOGRAM_ENTITY_UUID = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> HOLOGRAM_ENTITY_ID = SynchedEntityData.m_135353_(NotorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> SCAN_TARGET = mob -> mob.m_6084_() && !mob.m_6095_().m_204039_(ACTagRegistry.NOTOR_IGNORES) && !mob.m_20145_();
    private int flyingSoundTimer;

    public NotorEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.stopScanningFor = 80 + this.f_19796_.m_188503_(220);
        this.f_21342_ = new FlightMoveHelper(this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos blockPos) {
                return this.f_26495_.m_8055_(blockPos).m_60795_();
            }
        };
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NotorHologramGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new NotorScanGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new NotorFlightGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22276_, 6.0);
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HOLOGRAM_POS, Optional.empty());
        this.f_19804_.m_135372_(SHOWING_HOLOGRAM, (Object)false);
        this.f_19804_.m_135372_(SCANNING_ID, (Object)-1);
        this.f_19804_.m_135372_(HOLOGRAM_ENTITY_UUID, Optional.empty());
        this.f_19804_.m_135372_(HOLOGRAM_ENTITY_ID, (Object)-1);
    }

    public static boolean checkNotorSpawnRules(EntityType<NotorEntity> notor, LevelAccessor level, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        int j;
        if (blockPos.m_123342_() >= level.m_5736_()) {
            return false;
        }
        int i = level.m_46803_(blockPos);
        return i > randomSource.m_188503_(j = 4) ? false : NotorEntity.m_217057_(notor, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public void m_8119_() {
        boolean hasBeam;
        super.m_8119_();
        Entity hologram = this.getHologramEntity();
        this.prevGroundProgress = this.groundProgress;
        this.prevBeamProgress = this.beamProgress;
        this.prevHologramProgress = this.hologramProgress;
        this.prevPropellerRot = this.propellerRot;
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        boolean hasHologram = hologram != null && this.showingHologram();
        boolean bl = hasBeam = this.getScanningMob() != null || hasHologram;
        if (hasBeam && this.beamProgress < 5.0f) {
            if (this.beamProgress == 0.0f) {
                this.m_216990_((SoundEvent)ACSoundRegistry.HOLOGRAM_STOP.get());
            }
            this.beamProgress += 1.0f;
        }
        if (hasBeam && this.m_6084_()) {
            AlexsCaves.PROXY.playWorldSound((Object)this, (byte)2);
        }
        if (!hasBeam && this.beamProgress > 0.0f) {
            if (this.beamProgress == 5.0f) {
                this.m_216990_((SoundEvent)ACSoundRegistry.HOLOGRAM_STOP.get());
            }
            if (this.hologramProgress > 0.0f) {
                this.hologramProgress -= 1.0f;
            } else {
                this.beamProgress -= 1.0f;
            }
        }
        if (hasHologram && this.beamProgress >= 5.0f && this.hologramProgress < 5.0f) {
            this.hologramProgress += 1.0f;
        }
        if (!hasHologram && this.hologramProgress > 0.0f) {
            this.hologramProgress -= 1.0f;
        }
        double speed = this.m_20184_().m_165924_();
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_((double)0.9f, (double)0.9f, (double)0.9f));
            this.propellerRot = (float)((double)this.propellerRot + Math.max(speed * 10.0, 3.0) * 20.0);
            if (this.flyingSoundTimer++ >= 10) {
                if (!this.m_9236_().f_46443_ && !this.m_20067_()) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.NOTOR_FLYING.get(), 0.4f, 1.0f);
                }
                this.flyingSoundTimer = 0;
            }
        } else if (Mth.m_14177_((float)this.propellerRot) != 0.0f) {
            this.flyingSoundTimer = 0;
            this.propellerRot = Mth.m_14148_((float)this.propellerRot, (float)0.0f, (float)15.0f);
        }
        if (!this.m_9236_().f_46443_) {
            if (hologram != null) {
                this.f_19804_.m_135381_(HOLOGRAM_ENTITY_ID, (Object)hologram.m_19879_());
            } else {
                this.f_19804_.m_135381_(HOLOGRAM_ENTITY_ID, (Object)-1);
            }
            if (this.stopScanningFor > 0) {
                --this.stopScanningFor;
            }
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getGroundProgress(float partialTick) {
        return (this.prevGroundProgress + (this.groundProgress - this.prevGroundProgress) * partialTick) * 0.2f;
    }

    public float getBeamProgress(float partialTick) {
        return (this.prevBeamProgress + (this.beamProgress - this.prevBeamProgress) * partialTick) * 0.2f;
    }

    public float getPropellerAngle(float partialTick) {
        return this.prevPropellerRot + (this.propellerRot - this.prevPropellerRot) * partialTick;
    }

    public void setScanningId(int i) {
        this.f_19804_.m_135381_(SCANNING_ID, (Object)i);
    }

    public Entity getScanningMob() {
        int id = this.getScanningId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    @Nullable
    public UUID getHologramUUID() {
        return ((Optional)this.f_19804_.m_135370_(HOLOGRAM_ENTITY_UUID)).orElse(null);
    }

    public void setHologramUUID(@Nullable UUID hologram) {
        this.f_19804_.m_135381_(HOLOGRAM_ENTITY_UUID, Optional.ofNullable(hologram));
    }

    public Entity getHologramEntity() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getHologramUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(HOLOGRAM_ENTITY_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public int getScanningId() {
        return (Integer)this.f_19804_.m_135370_(SCANNING_ID);
    }

    public void setHologramPos(@Nullable BlockPos pos) {
        this.m_20088_().m_135381_(HOLOGRAM_POS, Optional.ofNullable(pos));
    }

    public boolean showingHologram() {
        return (Boolean)this.f_19804_.m_135370_(SHOWING_HOLOGRAM);
    }

    public void setShowingHologram(boolean showingHologram) {
        this.f_19804_.m_135381_(SHOWING_HOLOGRAM, (Object)showingHologram);
    }

    @Nullable
    public BlockPos getHologramPos() {
        return ((Optional)this.m_20088_().m_135370_(HOLOGRAM_POS)).orElse(null);
    }

    public Vec3 getBeamEndPosition(float partialTicks) {
        Entity scanning = this.getScanningMob();
        if (scanning != null) {
            float f = (float)Math.abs(Math.sin(((float)this.f_19797_ + partialTicks) * 0.1f));
            return scanning.m_20318_(partialTicks).m_82520_(0.0, (double)(scanning.m_20206_() * f), 0.0);
        }
        BlockPos pos = ((Optional)this.m_20088_().m_135370_(HOLOGRAM_POS)).orElse(null);
        if (pos == null) {
            return this.m_20318_(partialTicks).m_82520_(0.0, -3.0, 0.0);
        }
        return Vec3.m_82512_((Vec3i)pos);
    }

    public float getHologramProgress(float partialTicks) {
        return (this.prevHologramProgress + (this.hologramProgress - this.prevHologramProgress) * partialTicks) * 0.2f;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("ShowingHologram", this.showingHologram());
        if (this.getHologramUUID() != null) {
            compound.m_128362_("HologramUUID", this.getHologramUUID());
        }
        compound.m_128405_("StopScanningTime", this.stopScanningFor);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setShowingHologram(compound.m_128471_("ShowingHologram"));
        if (compound.m_128403_("HologramUUID")) {
            this.setHologramUUID(compound.m_128342_("HologramUUID"));
        }
        this.stopScanningFor = compound.m_128451_("StopScanningTime");
    }

    public boolean m_6785_(double dist) {
        return !this.m_8077_();
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.NOTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.NOTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.NOTOR_DEATH.get();
    }

    class FlightMoveHelper
    extends MoveControl {
        private final NotorEntity parentEntity;

        public FlightMoveHelper(NotorEntity bird) {
            super((Mob)bird);
            this.parentEntity = bird;
        }

        public void m_8126_() {
            boolean gravity = true;
            if (this.parentEntity.getScanningId() != -1 || this.parentEntity.getHologramEntity() != null) {
                gravity = false;
                float angle = (float)Math.PI / 180 * (this.parentEntity.f_20883_ + 90.0f);
                float radius = (float)Math.sin((float)this.parentEntity.f_19797_ * 0.2f) * 2.0f;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * Mth.m_14089_((float)angle);
                Vec3 strafPlus = new Vec3(extraX, 0.0, extraZ);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(strafPlus.m_82490_(0.01)));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d5 = vector3d.m_82553_();
                if (d5 < this.parentEntity.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82490_(0.5));
                } else {
                    gravity = false;
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.05 / d5)));
                    Vec3 vector3d1 = this.parentEntity.m_20184_();
                    float f = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 180.0f / (float)Math.PI;
                    this.parentEntity.m_146922_(Mth.m_14148_((float)this.parentEntity.m_146908_(), (float)f, (float)20.0f));
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
            this.parentEntity.m_20242_(!gravity);
        }
    }
}

