/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.HeartOfIronBlock;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetronJoint;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class MagnetronEntity
extends Monster {
    private static final EntityDataAccessor<CompoundTag> BLOCKSTATES = SynchedEntityData.m_135353_(MagnetronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<CompoundTag> BLOCK_POSES = SynchedEntityData.m_135353_(MagnetronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> FORMED = SynchedEntityData.m_135353_(MagnetronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_POSE = SynchedEntityData.m_135353_(MagnetronEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final float FORM_TIME = 40.0f;
    private static final int BLOCK_COUNT = MagnetronJoint.values().length * 2;
    public float clientRoll;
    private float prevWheelRot;
    private float wheelRot;
    private float prevWheelYaw;
    private float wheelYaw;
    private float prevRollLeanProgress;
    private float rollLeanProgress;
    private float prevFormProgress;
    private float formProgress;
    private boolean gravityFlag;
    private AttackPose prevAttackPose = AttackPose.NONE;
    private float prevAttackPoseProgress = 0.0f;
    private float attackPoseProgress = 0.0f;
    public final MagnetronPartEntity[] allParts = new MagnetronPartEntity[BLOCK_COUNT];
    public Vec3[] lightningAnimOffsets = new Vec3[6];
    private int syncCooldown = 0;
    private boolean isLandNavigator;
    private boolean hasFormedAttributes = false;
    private boolean droppedHeart = false;
    private int movingSoundTimer;

    public MagnetronEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.buildParts();
        this.formProgress = 40.0f;
        this.prevFormProgress = 40.0f;
        this.switchMoveController(false);
        Arrays.fill(this.lightningAnimOffsets, Vec3.f_82478_);
        this.f_21364_ = 13;
    }

    private void switchMoveController(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new MoveController();
            this.f_21344_ = this.createFormedNavigation(this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    private PathNavigation createFormedNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)pos.m_175288_((int)MagnetronEntity.this.m_20186_()));
                return ACMath.getGroundBelowPosition((BlockGetter)this.f_26495_, vec3).m_82554_(vec3) < 6.0;
            }
        };
        return flyingpathnavigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLOCKSTATES, (Object)new CompoundTag());
        this.f_19804_.m_135372_(BLOCK_POSES, (Object)new CompoundTag());
        this.f_19804_.m_135372_(FORMED, (Object)false);
        this.f_19804_.m_135372_(ATTACK_POSE, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Husk.class, true, false));
    }

    public void removeParts() {
        if (this.allParts != null) {
            for (MagnetronPartEntity part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void buildParts() {
        int i = 0;
        for (MagnetronJoint joint : MagnetronJoint.values()) {
            this.allParts[i] = new MagnetronPartEntity(this, joint, false);
            this.allParts[i + 1] = new MagnetronPartEntity(this, joint, true);
            i += 2;
        }
    }

    public boolean isFunctionallyMultipart() {
        return this.isFormed() && !this.m_213877_();
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public void m_8119_() {
        AttackPose attackPose;
        LivingEntity target;
        super.m_8119_();
        this.prevWheelRot = this.wheelRot;
        this.prevWheelYaw = this.wheelYaw;
        this.prevRollLeanProgress = this.rollLeanProgress;
        this.prevFormProgress = this.formProgress;
        this.prevAttackPoseProgress = this.attackPoseProgress;
        boolean wheelSpinning = false;
        double speed = this.m_20184_().m_165924_();
        if (speed > 0.01) {
            if (this.isFormed()) {
                float f = (float)Math.cos(this.f_267362_.m_267756_() * 0.4f - 1.5f);
                if (this.f_267362_.m_267731_() > 0.2f && Math.abs(f) < 0.2f && this.movingSoundTimer == 0) {
                    this.movingSoundTimer = 5;
                    this.m_216990_((SoundEvent)ACSoundRegistry.MAGNETRON_STEP.get());
                }
                if (this.movingSoundTimer > 0) {
                    --this.movingSoundTimer;
                }
            } else {
                wheelSpinning = true;
                this.wheelRot = (float)((double)this.wheelRot + Math.max(speed * 10.0, 1.0) * 15.0);
                if (this.movingSoundTimer++ > 20) {
                    this.m_216990_((SoundEvent)ACSoundRegistry.MAGNETRON_ROLL.get());
                    this.movingSoundTimer = 0;
                }
            }
        }
        if (!wheelSpinning && Mth.m_14177_((float)this.wheelRot) != 0.0f) {
            this.wheelRot = Mth.m_14148_((float)this.wheelRot, (float)0.0f, (float)15.0f);
        }
        if (!this.m_9236_().f_46443_ && !this.isFormed() && (target = this.m_5448_()) instanceof Player && target.m_6084_() && this.m_20270_((Entity)target) < 8.0f) {
            this.startForming();
        }
        if (wheelSpinning || this.isFormed()) {
            this.wheelYaw = Mth.m_14148_((float)this.wheelYaw, (float)this.f_20883_, (float)15.0f);
        }
        if (this.prevAttackPose != (attackPose = this.getAttackPose())) {
            if (this.attackPoseProgress < 10.0f) {
                this.attackPoseProgress += 1.0f;
            } else if (this.attackPoseProgress >= 10.0f) {
                if (attackPose == AttackPose.SLAM) {
                    this.spawnGroundEffects();
                }
                this.prevAttackPose = attackPose;
            }
        } else {
            this.attackPoseProgress = 10.0f;
        }
        if (this.isFormed() && this.formProgress < 40.0f) {
            if (this.formProgress == 0.0f) {
                this.m_216990_((SoundEvent)ACSoundRegistry.MAGNETRON_ASSEMBLE.get());
            }
            this.formProgress += 1.0f;
        }
        if (!this.isFormed() && this.formProgress > 0.0f) {
            this.formProgress = 0.0f;
        }
        if (wheelSpinning && this.rollLeanProgress < 5.0f) {
            this.rollLeanProgress += 1.0f;
        }
        if (!wheelSpinning && this.rollLeanProgress > 0.0f) {
            this.rollLeanProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isFormed() && this.isLandNavigator) {
                this.switchMoveController(false);
            }
            if (!this.isFormed() && !this.isLandNavigator) {
                this.switchMoveController(true);
            }
        }
        this.tickMultipart();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < this.lightningAnimOffsets.length; ++i) {
                this.lightningAnimOffsets[i] = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.3f);
            }
        }
        this.syncCooldown = this.syncCooldown > 0 ? --this.syncCooldown : 200;
        if (!this.m_6084_() && this.shouldDropBlocks()) {
            if (this.isFormed()) {
                for (MagnetronPartEntity part : this.allParts) {
                    if (part.getBlockState() == null || !this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) continue;
                    BlockPos placeAt = part.m_20183_();
                    while (!this.m_9236_().m_8055_(placeAt).m_60795_() && placeAt.m_123342_() < this.m_9236_().m_151558_()) {
                        placeAt = placeAt.m_7494_();
                    }
                    FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)placeAt, (BlockState)part.getBlockState());
                    part.setBlockState(null);
                }
            }
            if (!this.droppedHeart) {
                this.droppedHeart = true;
                FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (BlockState)((BlockState)((Block)ACBlockRegistry.HEART_OF_IRON.get()).m_49966_().m_61124_((Property)HeartOfIronBlock.f_55923_, (Comparable)this.m_6350_().m_122434_())));
            }
            this.removeParts();
        }
        if (this.isFormed() && !this.hasFormedAttributes) {
            this.hasFormedAttributes = true;
            this.m_6210_();
            this.m_21051_(Attributes.f_22276_).m_22100_(80.0);
            this.m_21051_(Attributes.f_22278_).m_22100_(1.0);
            this.m_5634_(80.0f);
        }
        if (!this.isFormed() && !this.m_6162_() && this.hasFormedAttributes) {
            this.hasFormedAttributes = false;
            this.m_6210_();
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
            this.m_21051_(Attributes.f_22278_).m_22100_(0.0);
            this.m_5634_(30.0f);
        }
    }

    private boolean shouldDropBlocks() {
        DamageSource lastDamageSource = this.m_21225_();
        if (lastDamageSource != null) {
            return lastDamageSource.m_7639_() != null || lastDamageSource.m_7640_() != null || this.f_20888_ != null;
        }
        return false;
    }

    private List<BlockPos> findBlocksForTransformation() {
        ArrayList<BlockPos> all = new ArrayList<BlockPos>();
        List<BlockPos> weapons = this.findBlocksMatching(state -> state.m_204336_(ACTagRegistry.MAGNETRON_WEAPONS), pos -> false, 2, 1.0f);
        List<BlockPos> magnetic = this.findBlocksMatching(state -> state.m_204336_(ACTagRegistry.MAGNETIC_BLOCKS), weapons::contains, BLOCK_COUNT - 2, 1.0f);
        all.addAll(weapons);
        all.addAll(magnetic);
        if (weapons.size() + magnetic.size() < BLOCK_COUNT) {
            List<BlockPos> everything = this.findBlocksMatching(state -> !state.m_60795_() && !state.m_204336_(ACTagRegistry.UNMOVEABLE), all::contains, BLOCK_COUNT - weapons.size() - magnetic.size(), 0.3f);
            all.addAll(everything);
        }
        return all;
    }

    public void m_7378_(CompoundTag compound) {
        this.setFormed(compound.m_128471_("Formed"));
        if (compound.m_128425_("Blockstates", 10)) {
            this.f_19804_.m_135381_(BLOCKSTATES, (Object)compound.m_128469_("Blockstates"));
        }
        if (compound.m_128425_("BlockPoses", 10)) {
            this.f_19804_.m_135381_(BLOCK_POSES, (Object)compound.m_128469_("BlockPoses"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("Formed", this.isFormed());
        compound.m_128365_("Blockstates", (Tag)this.f_19804_.m_135370_(BLOCKSTATES));
        compound.m_128365_("BlockPoses", (Tag)this.f_19804_.m_135370_(BLOCK_POSES));
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        Player player;
        Entity entity;
        boolean prev = super.m_6469_(damageSource, f);
        if (prev && (entity = damageSource.m_7639_()) instanceof Player && !(player = (Player)entity).m_7500_() && !this.isFormed()) {
            this.startForming();
        }
        return prev;
    }

    private List<BlockPos> findBlocksMatching(Predicate<BlockState> blockMatch, Predicate<BlockPos> ignoreMatch, int maxCount, float rngDiscard) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int searchY = 4; searchY > -4; --searchY) {
            for (int searchWidth = 0; searchWidth < 15; ++searchWidth) {
                int searchX = 0;
                while (searchX <= searchWidth) {
                    int searchZ;
                    int n = searchZ = searchX < searchWidth && searchX > -searchWidth ? searchWidth : 0;
                    while (searchZ <= searchWidth) {
                        mutableBlockPos.m_122154_((Vec3i)this.m_20183_(), searchX, searchY - 1, searchZ);
                        if (blockMatch.test(this.m_9236_().m_8055_((BlockPos)mutableBlockPos)) && !list.contains(mutableBlockPos.m_7949_()) && !ignoreMatch.test(mutableBlockPos.m_7949_()) && this.f_19796_.m_188501_() < rngDiscard) {
                            list.add(mutableBlockPos.m_7949_());
                            if (list.size() > maxCount) {
                                return list;
                            }
                        }
                        searchZ = searchZ > 0 ? -searchZ : 1 - searchZ;
                    }
                    searchX = searchX > 0 ? -searchX : 1 - searchX;
                }
            }
        }
        return list;
    }

    private void tickMultipart() {
        Vec3[] avector3d = new Vec3[this.allParts.length];
        double minimumYPart = Double.MAX_VALUE;
        int lowestPartIndex = 0;
        for (int j = 0; j < this.allParts.length; ++j) {
            double y = this.allParts[j].m_20186_();
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), y, this.allParts[j].m_20189_());
            if (y < minimumYPart) {
                minimumYPart = y;
                lowestPartIndex = j;
            }
            if (this.isFunctionallyMultipart()) {
                this.allParts[j].positionMultipart(this);
                continue;
            }
            this.allParts[j].m_20359_((Entity)this);
        }
        if (this.isFunctionallyMultipart()) {
            double idealDistance = this.m_20182_().f_82480_ - this.allParts[lowestPartIndex].getLowPoint();
            Vec3 bottom = new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
            Vec3 ground = ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), bottom);
            Vec3 aboveGround = ground.m_82520_(0.0, idealDistance, 0.0);
            Vec3 diff = aboveGround.m_82546_(bottom);
            this.gravityFlag = true;
            if (this.m_6084_() && bottom.m_82554_(ground) < 7.0 && ground.f_82480_ > (double)this.m_9236_().m_141937_()) {
                if (diff.m_82553_() > 1.0) {
                    diff = diff.m_82541_();
                }
                Vec3 delta = new Vec3(this.m_20184_().f_82479_ * 0.98, this.m_20184_().f_82480_ * (double)0.7f + diff.f_82480_ * 0.25, this.m_20184_().f_82481_ * 0.98);
                if (this.getAttackPose() != AttackPose.NONE) {
                    delta = new Vec3(0.0, delta.f_82480_, 0.0);
                }
                this.m_20256_(delta);
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
            }
        }
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    public boolean isFormed() {
        return (Boolean)this.f_19804_.m_135370_(FORMED);
    }

    public void setFormed(boolean formed) {
        this.f_19804_.m_135381_(FORMED, (Object)formed);
    }

    private List<BlockState> getAllBlockStates() {
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        CompoundTag data = (CompoundTag)this.f_19804_.m_135370_(BLOCKSTATES);
        if (data.m_128441_("BlockData")) {
            ListTag listTag = data.m_128437_("BlockData", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag innerTag = listTag.m_128728_(i);
                list.add(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)innerTag));
            }
        }
        return list;
    }

    private void setAllBlockStates(List<BlockState> list) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (BlockState state : list) {
            listTag.add((Object)NbtUtils.m_129202_((BlockState)state));
        }
        tag.m_128365_("BlockData", (Tag)listTag);
        this.f_19804_.m_135381_(BLOCKSTATES, (Object)tag);
    }

    private List<BlockPos> getAllBlockPos() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        CompoundTag data = (CompoundTag)this.f_19804_.m_135370_(BLOCK_POSES);
        if (data.m_128441_("BlockPos")) {
            ListTag listTag = data.m_128437_("BlockPos", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag innerTag = listTag.m_128728_(i);
                list.add(NbtUtils.m_129239_((CompoundTag)innerTag));
            }
        }
        return list;
    }

    private void setAllBlockPos(List<BlockPos> list) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (BlockPos pos : list) {
            listTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        tag.m_128365_("BlockPos", (Tag)listTag);
        this.f_19804_.m_135381_(BLOCK_POSES, (Object)tag);
    }

    public float getRollPosition(float partialTicks) {
        return this.prevWheelRot + (this.wheelRot - this.prevWheelRot) * partialTicks;
    }

    public float getWheelYaw(float partialTicks) {
        return this.prevWheelYaw + (this.wheelYaw - this.prevWheelYaw) * partialTicks;
    }

    public float getRollLeanProgress(float partialTicks) {
        return (this.prevRollLeanProgress + (this.rollLeanProgress - this.prevRollLeanProgress) * partialTicks) / 5.0f;
    }

    public AttackPose getAttackPose() {
        return AttackPose.get((Integer)this.f_19804_.m_135370_(ATTACK_POSE));
    }

    public void setAttackPose(AttackPose animation) {
        this.f_19804_.m_135381_(ATTACK_POSE, (Object)animation.ordinal());
    }

    public AttackPose getPrevAttackPose() {
        return this.prevAttackPose;
    }

    public float getAttackPoseProgress(float partialTick) {
        return (this.prevAttackPoseProgress + (this.attackPoseProgress - this.prevAttackPoseProgress) * partialTick) / 10.0f;
    }

    public AABB m_6921_() {
        return this.isFormed() ? this.m_20191_().m_82377_(3.5, 5.0, 3.5) : this.m_20191_();
    }

    private void startForming() {
        if (!this.m_9236_().f_46443_) {
            List<BlockPos> poses = this.findBlocksForTransformation();
            if (poses.size() >= BLOCK_COUNT) {
                MagnetronPartEntity rightHand = this.allParts[0];
                MagnetronPartEntity leftHand = this.allParts[0];
                ArrayList<MagnetronPartEntity> needsABlock = new ArrayList<MagnetronPartEntity>();
                for (MagnetronPartEntity entity : this.allParts) {
                    if (entity.getJoint() == MagnetronJoint.HAND) {
                        if (entity.left) {
                            leftHand = entity;
                            continue;
                        }
                        rightHand = entity;
                        continue;
                    }
                    needsABlock.add(entity);
                }
                rightHand.setStartsAt(poses.get(0));
                leftHand.setStartsAt(poses.get(1));
                for (int i = 2; i < BLOCK_COUNT; ++i) {
                    ((MagnetronPartEntity)((Object)needsABlock.get(i - 2))).setStartsAt(poses.get(i));
                }
            }
            this.setFormed(true);
            this.setAllBlockPos(poses);
            ArrayList<BlockState> saved = new ArrayList<BlockState>();
            for (MagnetronPartEntity entity : this.allParts) {
                if (entity.getBlockState() != null || entity.getStartPosition() == null) continue;
                BlockState state = this.m_9236_().m_8055_(entity.getStartPosition());
                saved.add(state);
                if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) || this.m_9236_().f_46443_) continue;
                this.m_9236_().m_46961_(entity.getStartPosition(), false);
            }
            this.setAllBlockStates(saved);
        }
    }

    public boolean m_20068_() {
        return this.isFormed() && this.gravityFlag && this.m_6084_() || super.m_20068_();
    }

    public float getFormProgress(float partialTicks) {
        return (this.prevFormProgress + (this.formProgress - this.prevFormProgress) * partialTicks) / 40.0f;
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (BLOCKSTATES.equals(entityDataAccessor)) {
            this.syncBlockStatesWithMultipart();
        }
        if (BLOCK_POSES.equals(entityDataAccessor)) {
            this.syncBlockPosesWithMultipart();
        }
        if (ATTACK_POSE.equals(entityDataAccessor)) {
            this.prevAttackPoseProgress = 0.0f;
            this.attackPoseProgress = 0.0f;
        }
    }

    private void syncBlockPosesWithMultipart() {
        List<BlockPos> poses = this.getAllBlockPos();
        if (poses.size() >= BLOCK_COUNT) {
            MagnetronPartEntity rightHand = this.allParts[0];
            MagnetronPartEntity leftHand = this.allParts[0];
            ArrayList<MagnetronPartEntity> needsABlock = new ArrayList<MagnetronPartEntity>();
            for (MagnetronPartEntity entity : this.allParts) {
                if (entity.getJoint() == MagnetronJoint.HAND) {
                    if (entity.left) {
                        leftHand = entity;
                        continue;
                    }
                    rightHand = entity;
                    continue;
                }
                needsABlock.add(entity);
            }
            rightHand.setStartsAt(poses.get(0));
            leftHand.setStartsAt(poses.get(1));
            for (int i = 2; i < BLOCK_COUNT; ++i) {
                ((MagnetronPartEntity)((Object)needsABlock.get(i - 2))).setStartsAt(poses.get(i));
            }
        }
    }

    private void syncBlockStatesWithMultipart() {
        List<BlockState> listStates = this.getAllBlockStates();
        if (listStates.size() >= this.allParts.length) {
            for (int i = 0; i < this.allParts.length; ++i) {
                this.allParts[i].setBlockState(listStates.get(i));
            }
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.55f * dimensions.f_20378_;
    }

    public void spawnGroundEffects() {
        float radius = 2.0f;
        for (int i = 0; i < 4; ++i) {
            for (int i1 = 0; i1 < 20 + this.f_19796_.m_188503_(12); ++i1) {
                double motionX = this.m_217043_().m_188583_() * 0.07;
                double motionY = this.m_217043_().m_188583_() * 0.07;
                double motionZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                Vec3 center = this.m_20182_().m_82549_(new Vec3(0.0, 0.0, 2.0).m_82524_((float)Math.toRadians(-this.f_20883_)));
                BlockPos ground = BlockPos.m_274446_((Position)ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), new Vec3((double)Mth.m_14107_((double)(center.f_82479_ + extraX)), (double)(Mth.m_14107_((double)(center.f_82480_ + extraY)) - 1), (double)Mth.m_14107_((double)(center.f_82481_ + extraZ)))));
                BlockState state = this.m_9236_().m_8055_(ground);
                if (!state.m_280296_() || !this.m_9236_().f_46443_) continue;
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), true, center.f_82479_ + extraX, (double)ground.m_123342_() + extraY, center.f_82481_ + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.MAGNETRON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.MAGNETRON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.MAGNETRON_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public static enum AttackPose {
        NONE,
        RIGHT_PUNCH,
        LEFT_PUNCH,
        SLAM;


        public static AttackPose get(int i) {
            if (i <= 0) {
                return NONE;
            }
            return AttackPose.values()[Math.min(AttackPose.values().length - 1, i)];
        }

        public boolean isRotatedJoint(MagnetronJoint joint, boolean left) {
            if (joint == MagnetronJoint.HAND) {
                if (this == LEFT_PUNCH) {
                    return left;
                }
                if (this == RIGHT_PUNCH) {
                    return !left;
                }
                return this == SLAM;
            }
            return false;
        }
    }

    class MoveController
    extends MoveControl {
        private final Mob parentEntity;

        public MoveController() {
            super((Mob)MagnetronEntity.this);
            this.parentEntity = MagnetronEntity.this;
        }

        public void m_8126_() {
            int maxTurn = 15;
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_20242_(true);
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                double d1 = this.f_24976_ - this.f_24974_.m_20186_();
                double d2 = this.f_24977_ - this.f_24974_.m_20189_();
                double d3 = d0 * d0 + d2 * d2;
                if (d3 < (double)0.01f) {
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                if (d3 > (double)this.f_24974_.m_20205_()) {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, maxTurn));
                }
                float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) * 3.0f;
                this.f_24974_.m_7910_(f1);
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                    float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f2, maxTurn));
                }
            } else {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }

    private class MeleeGoal
    extends Goal {
        private int punchCooldown = 0;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = MagnetronEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8056_() {
            this.punchCooldown = 0;
        }

        public void m_8041_() {
            if (MagnetronEntity.this.getAttackPose() != AttackPose.NONE) {
                MagnetronEntity.this.setAttackPose(AttackPose.NONE);
            }
        }

        public void m_8037_() {
            LivingEntity target = MagnetronEntity.this.m_5448_();
            if (this.punchCooldown > 0) {
                --this.punchCooldown;
            }
            if (target != null) {
                float progress;
                double xzDist = MagnetronEntity.this.m_20275_(target.m_20185_(), MagnetronEntity.this.m_20186_(), target.m_20189_());
                double yDist = Math.abs(MagnetronEntity.this.m_20186_() - target.m_20186_());
                float trueDist = (float)Math.max(yDist * 0.75, Math.sqrt((float)xzDist));
                if (xzDist < 10.0 && !MagnetronEntity.this.isFormed()) {
                    MagnetronEntity.this.startForming();
                }
                if (MagnetronEntity.this.isFormed() && (progress = MagnetronEntity.this.getFormProgress(1.0f)) >= 1.0f) {
                    MagnetronEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                    if (MagnetronEntity.this.getAttackPose() == AttackPose.NONE && MagnetronEntity.this.getAttackPoseProgress(1.0f) >= 1.0f) {
                        if (trueDist < 5.0f && this.punchCooldown <= 0) {
                            AttackPose set = this.getPoseForHand();
                            MagnetronEntity.this.m_216990_((SoundEvent)ACSoundRegistry.MAGNETRON_ATTACK.get());
                            MagnetronEntity.this.setAttackPose(set);
                            this.punchCooldown = set == AttackPose.SLAM ? 15 : 10;
                        }
                    } else if (trueDist < 7.5f && MagnetronEntity.this.getAttackPoseProgress(1.0f) >= 0.9f) {
                        this.dealDamage(target, MagnetronEntity.this.getAttackPose());
                    }
                }
                MagnetronEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                Vec3 lookDist = target.m_146892_().m_82546_(MagnetronEntity.this.m_146892_());
                float targetXRot = (float)(-(Mth.m_14136_((double)lookDist.f_82480_, (double)lookDist.m_165924_()) * 57.2957763671875));
                float targetYRot = (float)(-Mth.m_14136_((double)lookDist.f_82479_, (double)lookDist.f_82481_) * 57.2957763671875);
                MagnetronEntity.this.m_146926_(targetXRot);
                MagnetronEntity.this.m_146922_(targetYRot);
            }
            if (MagnetronEntity.this.getAttackPose() != AttackPose.NONE && this.punchCooldown == 0) {
                MagnetronEntity.this.setAttackPose(AttackPose.NONE);
            }
        }

        private int getHandDamageValueAdd(boolean left) {
            BlockState state = this.getStateForHand(left);
            if (state.m_204336_(BlockTags.f_13033_)) {
                return 6;
            }
            if (state.m_60713_(Blocks.f_50679_)) {
                return 4;
            }
            if (state.m_204336_(ACTagRegistry.MAGNETRON_WEAPONS)) {
                return 2;
            }
            return 0;
        }

        private void dealDamage(LivingEntity target, AttackPose attackPose) {
            int leftDmg = this.getHandDamageValueAdd(true);
            int rightDmg = this.getHandDamageValueAdd(true);
            if (attackPose == AttackPose.SLAM) {
                AABB bashBox = new AABB(-5.0, -1.0, -5.0, 5.0, 2.0, 5.0);
                Vec3 ground = ACMath.getGroundBelowPosition((BlockGetter)MagnetronEntity.this.m_9236_(), MagnetronEntity.this.m_20182_());
                bashBox = bashBox.m_82383_(ground.m_82549_(new Vec3(0.0, 0.0, 2.0).m_82524_((float)Math.toRadians(-MagnetronEntity.this.f_20883_))));
                for (Entity entity : MagnetronEntity.this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
                    if (MagnetronEntity.this.m_7307_(entity) || entity instanceof MagnetronEntity) continue;
                    entity.m_6469_(MagnetronEntity.this.m_269291_().m_269333_((LivingEntity)MagnetronEntity.this), (float)(2 + leftDmg + rightDmg));
                    this.launch(entity, true);
                }
            } else if (attackPose == AttackPose.LEFT_PUNCH) {
                BlockState state = this.getStateForHand(true);
                boolean magnet = state.m_60713_((Block)ACBlockRegistry.AZURE_MAGNET.get()) || state.m_60713_((Block)ACBlockRegistry.SCARLET_MAGNET.get());
                target.m_6469_(MagnetronEntity.this.m_269291_().m_269333_((LivingEntity)MagnetronEntity.this), (float)(2 + leftDmg));
                this.launch((Entity)target, magnet);
            } else if (attackPose == AttackPose.RIGHT_PUNCH) {
                BlockState state = this.getStateForHand(false);
                boolean magnet = state.m_60713_((Block)ACBlockRegistry.AZURE_MAGNET.get()) || state.m_60713_((Block)ACBlockRegistry.SCARLET_MAGNET.get());
                target.m_6469_(MagnetronEntity.this.m_269291_().m_269333_((LivingEntity)MagnetronEntity.this), (float)(2 + rightDmg));
                this.launch((Entity)target, magnet);
            }
        }

        private void launch(Entity e, boolean huge) {
            if (e.m_20096_()) {
                double d0 = e.m_20185_() - MagnetronEntity.this.m_20185_();
                double d1 = e.m_20189_() - MagnetronEntity.this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                float f = huge ? 1.0f : 0.5f;
                e.m_5997_(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
            }
        }

        private BlockState getStateForHand(boolean left) {
            if (MagnetronEntity.this.allParts != null) {
                for (MagnetronPartEntity part : MagnetronEntity.this.allParts) {
                    if (part.getJoint() != MagnetronJoint.HAND || part.left != left || part.getBlockState() == null) continue;
                    return part.getBlockState();
                }
            }
            return Blocks.f_50075_.m_49966_();
        }

        private AttackPose getPoseForHand() {
            float overrideSlamChance;
            RandomSource rand = MagnetronEntity.this.m_217043_();
            int leftDmg = this.getHandDamageValueAdd(true);
            int rightDmg = this.getHandDamageValueAdd(true);
            boolean dual = rightDmg != 0 && leftDmg != 0;
            float f = overrideSlamChance = dual ? 0.4f : 0.6f;
            if (rand.m_188501_() < overrideSlamChance) {
                if (dual || rightDmg == 0 && leftDmg == 0) {
                    return rand.m_188499_() ? AttackPose.LEFT_PUNCH : AttackPose.RIGHT_PUNCH;
                }
                if (rightDmg != 0) {
                    return AttackPose.RIGHT_PUNCH;
                }
                if (leftDmg != 0) {
                    return AttackPose.LEFT_PUNCH;
                }
            }
            return AttackPose.SLAM;
        }
    }
}

