/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GammaroachEntity
extends PathfinderMob
implements IAnimatedEntity {
    private static final Predicate<LivingEntity> IRRADIATED_TARGET = mob -> mob.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get()) && !(mob instanceof RaycatEntity);
    private Animation currentAnimation;
    private int animationTick;
    public static final Animation ANIMATION_SPRAY = Animation.create((int)40);
    public static final Animation ANIMATION_RAM = Animation.create((int)25);
    private static final EntityDataAccessor<Integer> SPRAY_COOLDOWN = SynchedEntityData.m_135353_(GammaroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FED = SynchedEntityData.m_135353_(GammaroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GammaroachEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 20, false, true, IRRADIATED_TARGET));
        this.f_21346_.m_25352_(3, (Goal)new MobTarget3DGoal((Mob)this, Cow.class, true));
    }

    public static boolean isValidLightLevel(ServerLevelAccessor levelAccessor, BlockPos blockPos, RandomSource randomSource) {
        if (levelAccessor.m_45517_(LightLayer.SKY, blockPos) > randomSource.m_188503_(32)) {
            return false;
        }
        int lvt_3_1_ = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(blockPos, 10) : levelAccessor.m_46803_(blockPos);
        return lvt_3_1_ <= randomSource.m_188503_(8);
    }

    public static boolean canMonsterSpawnInLight(EntityType<GammaroachEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return GammaroachEntity.isValidLightLevel(levelAccessor, blockPos, randomSource) && GammaroachEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    public static <T extends Mob> boolean checkGammaroachSpawnRules(EntityType<GammaroachEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return GammaroachEntity.canMonsterSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPRAY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(FED, (Object)false);
    }

    public int getSprayCooldown() {
        return (Integer)this.f_19804_.m_135370_(SPRAY_COOLDOWN);
    }

    public void setSprayCooldown(int time) {
        this.f_19804_.m_135381_(SPRAY_COOLDOWN, (Object)time);
    }

    public boolean isFed() {
        return (Boolean)this.f_19804_.m_135370_(FED);
    }

    public void setFed(boolean fed) {
        this.f_19804_.m_135381_(FED, (Object)fed);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.IRRADIATED.get();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_8023_();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_() || this.isFed();
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return 0.5f - (float)Math.max(worldIn.m_45517_(LightLayer.BLOCK, pos), worldIn.m_45517_(LightLayer.SKY, pos));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getSprayCooldown() > 0) {
            this.setSprayCooldown(this.getSprayCooldown() - 1);
        }
        if (this.getAnimation() == ANIMATION_SPRAY) {
            if (this.getAnimationTick() == 10) {
                AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)0.2f, this.m_20189_());
                areaeffectcloud.m_19724_((ParticleOptions)ACParticleRegistry.GAMMAROACH.get());
                areaeffectcloud.m_19714_(7853582);
                areaeffectcloud.m_19716_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 2000));
                areaeffectcloud.m_19712_(2.3f);
                areaeffectcloud.m_19734_(200);
                areaeffectcloud.m_19740_(10);
                areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
                this.m_9236_().m_7967_((Entity)areaeffectcloud);
            } else if (this.getAnimationTick() >= 10 && this.getAnimationTick() <= 30) {
                Vec3 randomOffset = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82541_().m_82490_(1.0).m_82549_(this.m_146892_());
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.GAMMAROACH.get(), this.m_20208_(2.0), this.m_20188_(), this.m_20262_(2.0), randomOffset.f_82479_, randomOffset.f_82480_ + 0.23, randomOffset.f_82481_);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPRAY, ANIMATION_RAM};
    }

    public void triggerSpraying() {
        if (this.getSprayCooldown() <= 0 && this.getAnimation() == NO_ANIMATION) {
            this.m_216990_((SoundEvent)ACSoundRegistry.GAMMAROACH_SPRAY.get());
            this.setAnimation(ANIMATION_SPRAY);
            this.setSprayCooldown(10000 + this.f_19796_.m_188503_(24000));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        LivingEntity living;
        boolean prev = super.m_6469_(damageSource, damageAmount);
        Entity hurter = damageSource.m_7639_();
        if (prev && hurter instanceof LivingEntity && !(living = (LivingEntity)hurter).m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get())) {
            this.triggerSpraying();
        }
        return prev;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.getAnimation() == ANIMATION_RAM || this.getAnimation() == ANIMATION_SPRAY) {
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSprayCooldown(compound.m_128451_("SprayCooldown"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SprayCooldown", this.getSprayCooldown());
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(flying ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 8.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getStepHeight() {
        return 1.1f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack;
        InteractionResult prev = super.m_6071_(player, hand);
        if (prev != InteractionResult.SUCCESS && (itemStack = player.m_21120_(hand)).m_150930_((Item)ACItemRegistry.SPELUNKIE.get()) && (!this.m_9236_().f_46443_ && this.m_5448_() == player || !this.isFed())) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.setFed(true);
            this.m_6703_(null);
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)49);
            return InteractionResult.SUCCESS;
        }
        return prev;
    }

    public void m_7822_(byte b) {
        if (b == 49) {
            ItemStack itemstack = new ItemStack((ItemLike)ACItemRegistry.SPELUNKIE.get());
            for (int i = 0; i < 8; ++i) {
                Vec3 headPos = new Vec3(0.0, 0.1, 0.5).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + headPos.f_82479_, this.m_20227_(0.5) + headPos.f_82480_, this.m_20189_() + headPos.f_82481_, (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.15f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.1f));
            }
        } else {
            super.m_7822_(b);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.GAMMAROACH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GAMMAROACH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GAMMAROACH_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (!this.m_6162_()) {
            this.m_5496_((SoundEvent)ACSoundRegistry.GAMMAROACH_STEP.get(), 1.0f, 1.0f);
        }
    }

    private class MeleeGoal
    extends Goal {
        private int checkForMobsTime = 0;
        private LivingEntity pickupMonster = null;

        public boolean m_8036_() {
            LivingEntity target = GammaroachEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            if (this.pickupMonster != null) {
                if (this.pickupMonster.m_20365_((Entity)GammaroachEntity.this)) {
                    this.pickupMonster.m_8127_();
                }
                this.pickupMonster = null;
                this.checkForMobsTime = 20;
            }
        }

        public void m_8037_() {
            --this.checkForMobsTime;
            LivingEntity target = GammaroachEntity.this.m_5448_();
            if (target != null && target.m_6084_()) {
                if (this.checkForMobsTime < 0) {
                    this.checkForMobsTime = 120 + GammaroachEntity.this.f_19796_.m_188503_(100);
                    Predicate<Entity> monsterAway = animal -> animal instanceof Enemy && !(animal instanceof GammaroachEntity) && animal.m_20270_((Entity)target) > 5.0f && !animal.m_20159_();
                    List list = GammaroachEntity.this.m_9236_().m_6443_(Mob.class, GammaroachEntity.this.m_20191_().m_82377_(30.0, 12.0, 30.0), EntitySelector.f_20408_.and(monsterAway));
                    list.sort(Comparator.comparingDouble(arg_0 -> ((GammaroachEntity)GammaroachEntity.this).m_20280_(arg_0)));
                    if (!list.isEmpty()) {
                        this.pickupMonster = (LivingEntity)list.get(0);
                    }
                }
                if (this.pickupMonster == null || this.pickupMonster.m_20365_((Entity)GammaroachEntity.this)) {
                    GammaroachEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                    GammaroachEntity.this.m_21391_((Entity)target, 180.0f, 30.0f);
                    if (GammaroachEntity.this.m_20270_((Entity)target) < 1.5f + target.m_20205_()) {
                        if (GammaroachEntity.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                            GammaroachEntity.this.setAnimation(ANIMATION_RAM);
                        } else if (GammaroachEntity.this.getAnimation() == ANIMATION_RAM && GammaroachEntity.this.getAnimationTick() > 8 && GammaroachEntity.this.getAnimationTick() < 15) {
                            GammaroachEntity.this.m_216990_((SoundEvent)ACSoundRegistry.GAMMAROACH_ATTACK.get());
                            target.m_6469_(GammaroachEntity.this.m_269291_().m_269333_((LivingEntity)GammaroachEntity.this), (float)GammaroachEntity.this.m_21133_(Attributes.f_22281_));
                        }
                        if (this.pickupMonster != null) {
                            this.pickupMonster.m_8127_();
                            this.pickupMonster = null;
                        }
                    }
                } else if (this.pickupMonster.m_6084_() && !this.pickupMonster.m_20159_()) {
                    GammaroachEntity.this.m_21573_().m_5624_((Entity)this.pickupMonster, 1.0);
                    GammaroachEntity.this.m_21391_((Entity)this.pickupMonster, 180.0f, 30.0f);
                    if (GammaroachEntity.this.m_20270_((Entity)this.pickupMonster) < 1.5f + this.pickupMonster.m_20205_()) {
                        this.pickupMonster.m_7998_((Entity)GammaroachEntity.this, true);
                        this.pickupMonster.m_6469_(GammaroachEntity.this.m_269291_().m_269325_(), 1.0f);
                    }
                } else {
                    this.pickupMonster = null;
                }
            }
        }
    }
}

