/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GroundPathNavigatorNoSpin;
import com.github.alexmodguy.alexscaves.server.entity.item.ThrownWasteDrumEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BrainiacEntity
extends Monster
implements IAnimatedEntity {
    private Animation currentAnimation;
    private int animationTick;
    public static final Animation ANIMATION_THROW_BARREL = Animation.create((int)30);
    public static final Animation ANIMATION_DRINK_BARREL = Animation.create((int)75);
    public static final Animation ANIMATION_BITE = Animation.create((int)25);
    public static final Animation ANIMATION_SMASH = Animation.create((int)20);
    private static final EntityDataAccessor<Boolean> HAS_BARREL = SynchedEntityData.m_135353_(BrainiacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TONGUE_TARGET_ID = SynchedEntityData.m_135353_(BrainiacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TONGUE_SHOOT_TICK = SynchedEntityData.m_135353_(BrainiacEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevRaiseArmsAmount = 0.0f;
    private float raiseArmsAmount = 0.0f;
    private float prevLeftArmAmount = 0.0f;
    private float raiseLeftArmAmount = 0.0f;
    private float prevShootTongueAmount = 0.0f;
    private float shootTongueAmount = 0.0f;
    private float prevLastTongueDistance = 0.0f;
    private float lastTongueDistance = 0.0f;

    public BrainiacEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_BARREL, (Object)true);
        this.f_19804_.m_135372_(TONGUE_TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(TONGUE_SHOOT_TICK, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(2, (Goal)new PickupBarrelGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 45));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigatorNoSpin((Mob)this, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevRaiseArmsAmount = this.raiseArmsAmount;
        this.prevLeftArmAmount = this.raiseLeftArmAmount;
        this.prevShootTongueAmount = this.shootTongueAmount;
        this.prevLastTongueDistance = this.lastTongueDistance;
        if (this.getAnimation() == ANIMATION_SMASH && this.raiseArmsAmount < 5.0f) {
            this.raiseArmsAmount += 1.0f;
        }
        if (this.getAnimation() != ANIMATION_SMASH && this.raiseArmsAmount > 0.0f) {
            this.raiseArmsAmount -= 1.0f;
        }
        if (this.raisingLeftArm() && this.raiseLeftArmAmount < 5.0f) {
            this.raiseLeftArmAmount += 1.0f;
        }
        if (!this.raisingLeftArm() && this.raiseLeftArmAmount > 0.0f) {
            this.raiseLeftArmAmount -= 1.0f;
        }
        if (this.getLickTicks() > 0 && this.shootTongueAmount < 10.0f) {
            this.shootTongueAmount += 1.0f;
        }
        if (this.getLickTicks() <= 0 && this.shootTongueAmount > 0.0f) {
            this.shootTongueAmount -= 1.0f;
        }
        if (!this.m_9236_().f_46443_ && this.hasBarrel()) {
            LivingEntity attackTarget;
            if (this.getAnimation() == ANIMATION_DRINK_BARREL && this.getAnimationTick() >= 60) {
                this.setHasBarrel(false);
                this.m_5634_(10.0f);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 400, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 4));
            }
            if (this.getAnimation() == ANIMATION_THROW_BARREL && this.getAnimationTick() >= 15 && (attackTarget = this.m_5448_()) != null && attackTarget.m_6084_()) {
                this.setHasBarrel(false);
                Vec3 hand = new Vec3((double)0.65f, (double)-0.3f, (double)0.9f).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_6080_() * ((float)Math.PI / 180));
                Vec3 handOnBody = this.m_146892_().m_82549_(hand);
                ThrownWasteDrumEntity wasteDrumEntity = (ThrownWasteDrumEntity)((EntityType)ACEntityRegistry.THROWN_WASTE_DRUM.get()).m_20615_(this.m_9236_());
                wasteDrumEntity.m_146884_(handOnBody);
                Vec3 toss = attackTarget.m_146892_().m_82546_(handOnBody).m_82542_((double)0.35f, 0.0, (double)0.35f).m_82520_(0.0, 0.4, 0.0);
                wasteDrumEntity.m_146922_(-((float)Mth.m_14136_((double)toss.f_82479_, (double)toss.f_82481_)) * 180.0f / (float)Math.PI);
                this.m_9236_().m_7967_((Entity)wasteDrumEntity);
                wasteDrumEntity.m_20256_(toss.m_82541_().m_82490_((double)(attackTarget.m_20270_((Entity)this) * 0.2f)));
            }
        }
        Entity tongueTarget = this.getTongueTarget();
        if (this.m_9236_().f_46443_) {
            if (tongueTarget != null && tongueTarget.m_6084_()) {
                this.lastTongueDistance = this.m_20270_(tongueTarget) - 0.5f;
            }
        } else {
            LivingEntity attackTarget = this.m_5448_();
            if (this.getLickTicks() > 0) {
                this.setLickTicks(this.getLickTicks() - 1);
                if (attackTarget != null && attackTarget.m_6084_() && this.m_142582_((Entity)attackTarget) && attackTarget.m_20270_((Entity)this) < 20.0f) {
                    this.setTongueTargetId(attackTarget.m_19879_());
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, attackTarget.m_146892_());
                } else {
                    this.setTongueTargetId(-1);
                }
            } else {
                this.setTongueTargetId(-1);
            }
        }
        if (tongueTarget instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)tongueTarget;
            if (this.shootTongueAmount >= 5.0f) {
                this.postAttackEffect(living);
                tongueTarget.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 4.0f);
                living.m_147240_(0.3, living.m_20185_() - this.m_20185_(), tongueTarget.m_20189_() - this.m_20189_());
                this.setLickTicks(0);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_THROW_BARREL, ANIMATION_DRINK_BARREL, ANIMATION_SMASH, ANIMATION_BITE};
    }

    public float getRaiseArmsAmount(float partialTick) {
        return (this.prevRaiseArmsAmount + (this.raiseArmsAmount - this.prevRaiseArmsAmount) * partialTick) * 0.2f;
    }

    public boolean raisingLeftArm() {
        return this.getAnimation() == ANIMATION_DRINK_BARREL || this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_THROW_BARREL;
    }

    public float getRaiseLeftArmAmount(float partialTick) {
        return (this.prevLeftArmAmount + (this.raiseLeftArmAmount - this.prevLeftArmAmount) * partialTick) * 0.2f;
    }

    public float getLastTongueDistance(float partialTick) {
        return this.prevLastTongueDistance + (this.lastTongueDistance - this.prevLastTongueDistance) * partialTick;
    }

    public float getShootTongueAmount(float partialTick) {
        return (this.prevShootTongueAmount + (this.shootTongueAmount - this.prevShootTongueAmount) * partialTick) * 0.1f;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasBarrel(compound.m_128471_("HasBarrel"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasBarrel", this.hasBarrel());
    }

    public Entity getTongueTarget() {
        int id = (Integer)this.f_19804_.m_135370_(TONGUE_TARGET_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasBarrel() && this.shouldDropBlocks()) {
            this.m_19983_(new ItemStack((ItemLike)ACBlockRegistry.WASTE_DRUM.get()));
        }
    }

    private boolean shouldDropBlocks() {
        DamageSource lastDamageSource = this.m_21225_();
        if (lastDamageSource != null) {
            return lastDamageSource.m_7639_() != null || lastDamageSource.m_7640_() != null;
        }
        return false;
    }

    public void postAttackEffect(LivingEntity entity) {
        if (entity != null && entity.m_6084_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 400));
        }
    }

    public void setTongueTargetId(int id) {
        this.f_19804_.m_135381_(TONGUE_TARGET_ID, (Object)id);
    }

    public int getLickTicks() {
        return (Integer)this.f_19804_.m_135370_(TONGUE_SHOOT_TICK);
    }

    public void setLickTicks(int ticks) {
        this.f_19804_.m_135381_(TONGUE_SHOOT_TICK, (Object)ticks);
    }

    public boolean hasBarrel() {
        return (Boolean)this.f_19804_.m_135370_(HAS_BARREL);
    }

    public void setHasBarrel(boolean barrel) {
        this.f_19804_.m_135381_(HAS_BARREL, (Object)barrel);
    }

    public float getStepHeight() {
        return 1.1f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.BRAINIAC_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.BRAINIAC_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.BRAINIAC_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)ACSoundRegistry.BRAINIAC_STEP.get(), 1.0f, 1.0f);
    }

    private class MeleeGoal
    extends Goal {
        private int tongueCooldown = 0;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = BrainiacEntity.this.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8037_() {
            LivingEntity target = BrainiacEntity.this.m_5448_();
            if (this.tongueCooldown > 0) {
                --this.tongueCooldown;
            }
            if (target != null && target.m_6084_()) {
                double dist = BrainiacEntity.this.m_20270_((Entity)target);
                if (BrainiacEntity.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    if (BrainiacEntity.this.m_21223_() < BrainiacEntity.this.m_21233_() * 0.5f && BrainiacEntity.this.hasBarrel() && BrainiacEntity.this.f_19796_.m_188503_(20) == 0) {
                        BrainiacEntity.this.setAnimation(ANIMATION_DRINK_BARREL);
                    }
                    BrainiacEntity.this.m_21573_().m_5624_((Entity)target, 1.2);
                    if (BrainiacEntity.this.m_142582_((Entity)target)) {
                        if (BrainiacEntity.this.m_21223_() < BrainiacEntity.this.m_21233_() * 0.75f && dist < 20.0 && BrainiacEntity.this.hasBarrel() && BrainiacEntity.this.f_19796_.m_188503_(30) == 0) {
                            BrainiacEntity.this.setAnimation(ANIMATION_THROW_BARREL);
                            BrainiacEntity.this.m_216990_((SoundEvent)ACSoundRegistry.BRAINIAC_THROW.get());
                        }
                        if (dist < (double)(BrainiacEntity.this.m_20205_() + target.m_20205_()) + 3.5) {
                            BrainiacEntity.this.setAnimation(BrainiacEntity.this.f_19796_.m_188499_() ? ANIMATION_SMASH : ANIMATION_BITE);
                            BrainiacEntity.this.m_216990_((SoundEvent)ACSoundRegistry.BRAINIAC_ATTACK.get());
                            return;
                        }
                        if (this.tongueCooldown == 0 && BrainiacEntity.this.f_19796_.m_188503_(16) == 0 && dist < 25.0) {
                            BrainiacEntity.this.m_216990_((SoundEvent)ACSoundRegistry.BRAINIAC_LICK.get());
                            BrainiacEntity.this.setLickTicks(20);
                            this.tongueCooldown = 15 + BrainiacEntity.this.f_19796_.m_188503_(15);
                        }
                    } else {
                        BrainiacEntity.this.setLickTicks(0);
                    }
                }
                if (BrainiacEntity.this.getAnimation() == ANIMATION_SMASH && BrainiacEntity.this.getAnimationTick() >= 10 && BrainiacEntity.this.getAnimationTick() <= 15) {
                    this.checkAndDealDamage(target, 2.0f);
                }
                if (BrainiacEntity.this.getAnimation() == ANIMATION_BITE && BrainiacEntity.this.getAnimationTick() >= 10 && BrainiacEntity.this.getAnimationTick() <= 15) {
                    this.checkAndDealDamage(target, 0.0f);
                }
            }
        }

        private void checkAndDealDamage(LivingEntity target, float damageMultiplier) {
            if (BrainiacEntity.this.m_142582_((Entity)target) && (double)BrainiacEntity.this.m_20270_((Entity)target) < (double)(BrainiacEntity.this.m_20205_() + target.m_20205_()) + 2.0) {
                target.m_6469_(BrainiacEntity.this.m_269291_().m_269333_((LivingEntity)BrainiacEntity.this), (float)BrainiacEntity.this.m_21051_(Attributes.f_22281_).m_22135_() * damageMultiplier);
                BrainiacEntity.this.postAttackEffect(target);
                target.m_147240_(0.3, BrainiacEntity.this.m_20185_() - target.m_20185_(), BrainiacEntity.this.m_20189_() - target.m_20189_());
            }
        }
    }

    private class PickupBarrelGoal
    extends MoveToBlockGoal {
        public PickupBarrelGoal() {
            super((PathfinderMob)BrainiacEntity.this, 1.0, 20, 6);
        }

        protected int m_6099_(PathfinderMob mob) {
            return PickupBarrelGoal.m_186073_((int)(40 + BrainiacEntity.this.m_217043_().m_188503_(40)));
        }

        protected BlockPos m_6669_() {
            return this.f_25602_;
        }

        protected void m_25624_() {
            BlockPos pos = this.m_6669_();
            this.f_25598_.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, this.f_25599_);
        }

        public boolean m_8036_() {
            if (BrainiacEntity.this.hasBarrel()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !BrainiacEntity.this.hasBarrel();
        }

        public double m_8052_() {
            return BrainiacEntity.this.m_20205_() + 1.0f;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25602_ != null) {
                BrainiacEntity.this.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.f_25602_));
                if (this.m_25625_()) {
                    BrainiacEntity.this.m_21573_().m_26573_();
                    if (BrainiacEntity.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                        BrainiacEntity.this.setAnimation(ANIMATION_BITE);
                    }
                    if (BrainiacEntity.this.getAnimation() == ANIMATION_BITE && BrainiacEntity.this.getAnimationTick() >= 10 && BrainiacEntity.this.getAnimationTick() <= 15 && this.m_6465_((LevelReader)BrainiacEntity.this.m_9236_(), this.f_25602_)) {
                        BrainiacEntity.this.m_9236_().m_46961_(this.f_25602_, false);
                        BrainiacEntity.this.setHasBarrel(true);
                    }
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.f_25602_ = BlockPos.f_121853_;
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            return pos != null && worldIn.m_8055_(pos).m_60713_((Block)ACBlockRegistry.WASTE_DRUM.get());
        }
    }
}

