/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.TeletorEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.google.common.collect.Multimap;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MagneticWeaponEntity
extends Entity {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK = SynchedEntityData.m_135353_(MagneticWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Optional<UUID>> CONTROLLER_UUID = SynchedEntityData.m_135353_(MagneticWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CONTROLLER_ID = SynchedEntityData.m_135353_(MagneticWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(MagneticWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IDLING = SynchedEntityData.m_135353_(MagneticWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float prevStrikeProgress;
    private float strikeProgress;
    private float prevReturnProgress;
    private float returnProgress;
    private int playerUseCooldown = 0;
    private boolean comingBack = false;
    private float destroyBlockProgress;
    private BlockPos lastSelectedBlock;
    private int totalMiningTime = 0;
    private boolean hadPlayerController = false;
    private boolean spawnedItem = false;
    public boolean returnFlag = false;

    public MagneticWeaponEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public MagneticWeaponEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK, (Object)new ItemStack((ItemLike)Items.f_42383_));
        this.f_19804_.m_135372_(CONTROLLER_UUID, Optional.empty());
        this.f_19804_.m_135372_(CONTROLLER_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(IDLING, (Object)true);
    }

    /*
     * Unable to fully structure code
     */
    public void m_8119_() {
        block36: {
            block38: {
                block37: {
                    block35: {
                        super.m_8119_();
                        this.prevStrikeProgress = this.strikeProgress;
                        this.prevReturnProgress = this.returnProgress;
                        controller = this.getController();
                        target = this.getTarget();
                        if (!this.m_9236_().f_46443_) {
                            this.f_19794_ = this.comingBack != false || controller instanceof TeletorEntity != false && (target == null || target.m_6084_() == false);
                            if (controller == null && this.f_19797_ > 20 || this.getItemStack().m_41619_()) {
                                if (this.hadPlayerController) {
                                    this.plopItem();
                                    this.hadPlayerController = false;
                                }
                                this.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                        }
                        if ((this.getTarget() == null || this.comingBack || this.playerUseCooldown > 0) && this.strikeProgress > 0.0f) {
                            this.strikeProgress = Math.max(0.0f, this.strikeProgress - 0.1f);
                        }
                        if (!(controller instanceof TeletorEntity)) break block35;
                        teletor = (TeletorEntity)controller;
                        this.f_19804_.m_135381_(MagneticWeaponEntity.CONTROLLER_ID, (Object)teletor.m_19879_());
                        teletor.setWeaponUUID(this.m_20148_());
                        if (!this.m_9236_().f_46443_) {
                            e = teletor.m_5448_();
                            this.f_19804_.m_135381_(MagneticWeaponEntity.TARGET_ID, (Object)(e != null && e.m_6084_() != false ? e.m_19879_() : -1));
                        }
                        attacking = this.comingBack == false && target != null && target.m_6084_() != false;
                        vec3 = attacking != false ? target.m_146892_() : teletor.getWeaponPosition();
                        want = vec3.m_82546_(this.m_20182_());
                        if (target != null && !this.comingBack) {
                            this.f_19804_.m_135381_(MagneticWeaponEntity.IDLING, (Object)false);
                            if (want.m_82553_() < (double)(target.m_20205_() + 1.0f)) {
                                if (this.strikeProgress < 1.0f) {
                                    this.strikeProgress = Math.max(0.0f, this.strikeProgress + 0.35f);
                                } else {
                                    this.hurtEntity((LivingEntity)teletor, target);
                                    this.comingBack = true;
                                }
                            } else if (want.m_82553_() > 32.0) {
                                this.comingBack = true;
                            }
                        }
                        this.directMovementTowards(vec3, 0.1f);
                        if (this.m_20270_(controller) < 2.5f && this.m_20186_() > controller.m_20186_()) {
                            this.f_19804_.m_135381_(MagneticWeaponEntity.IDLING, (Object)true);
                            if (this.comingBack) {
                                this.comingBack = false;
                            }
                        }
                        break block36;
                    }
                    if (!(controller instanceof Player)) break block36;
                    player = (Player)controller;
                    moveTo = null;
                    this.f_19804_.m_135381_(MagneticWeaponEntity.CONTROLLER_ID, (Object)controller.m_19879_());
                    this.f_19804_.m_135381_(MagneticWeaponEntity.IDLING, (Object)false);
                    this.comingBack = this.isOwnerWearingGauntlet() == false;
                    speed = 0.1f;
                    if (!this.isOwnerWearingGauntlet()) break block37;
                    this.hadPlayerController = true;
                    maxDist = 30.0f;
                    miningBlock = null;
                    hitresult = ProjectileUtil.m_278180_((Entity)player, (Predicate<Entity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, m_271807_(), (Lnet/minecraft/world/entity/Entity;)Z)(), (double)maxDist);
                    if (!(hitresult instanceof EntityHitResult)) ** GOTO lbl-1000
                    entityHitResult = (EntityHitResult)hitresult;
                    if (this.playerUseCooldown == 0) {
                        entity = entityHitResult.m_82443_();
                        moveTo = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
                        speed = 0.2f;
                        if (this.m_20270_(entity) < entity.m_20205_() + 1.5f) {
                            if (this.strikeProgress < 1.0f) {
                                this.strikeProgress = Math.max(0.0f, this.strikeProgress + 0.35f);
                            } else {
                                this.hurtEntity((LivingEntity)player, entity);
                                this.playerUseCooldown = 5 + this.f_19796_.m_188503_(5);
                            }
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        moveTo = player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82490_((double)(maxDist - 20.0f)));
                        if ((hitresult.m_6662_() == HitResult.Type.BLOCK || hitresult.m_82450_().m_82546_(player.m_146892_()).m_82553_() < (double)maxDist) && hitresult instanceof BlockHitResult) {
                            blockHitResult = (BlockHitResult)hitresult;
                            if (this.m_20238_(Vec3.m_82512_((Vec3i)blockHitResult.m_82425_())) < 2.25) {
                                miningBlock = blockHitResult.m_82425_();
                            }
                            if (!this.m_9236_().m_8055_(blockHitResult.m_82425_()).m_60795_()) {
                                moveTo = hitresult.m_82450_();
                            }
                        }
                    }
                    if (miningBlock != null) {
                        if (this.lastSelectedBlock == null || !this.lastSelectedBlock.equals(miningBlock)) {
                            if (this.lastSelectedBlock != null) {
                                this.m_9236_().m_6801_(player.m_19879_(), this.lastSelectedBlock, -1);
                            }
                            this.lastSelectedBlock = miningBlock;
                            this.destroyBlockProgress = 0.0f;
                        }
                        miningState = this.m_9236_().m_8055_(miningBlock);
                        soundType = miningState.m_60827_();
                        f = miningState.m_60800_((BlockGetter)this.m_9236_(), miningBlock);
                        itemDestroySpeed = this.getDigSpeed(player, miningState, miningBlock);
                        if (itemDestroySpeed > 1.0f) {
                            if (this.totalMiningTime % 4 == 0) {
                                this.m_5496_(soundType.m_56778_(), (soundType.m_56773_() + 1.0f) / 8.0f, soundType.m_56774_() * 0.5f);
                            }
                            ++this.totalMiningTime;
                            this.strikeProgress = (float)Math.abs(Math.sin((float)this.f_19797_ * 0.6f) * 1.2000000476837158 - 0.20000000298023224);
                            j = itemDestroySpeed / f / 10.0f;
                            this.destroyBlockProgress += j;
                            this.m_9236_().m_6801_(player.m_19879_(), this.lastSelectedBlock, (int)(this.destroyBlockProgress * 10.0f));
                            if (this.destroyBlockProgress >= 1.0f && !this.m_9236_().f_46443_) {
                                this.damageItem(1);
                                itemStack = this.getItemStack();
                                itemStack.m_41686_(this.m_9236_(), miningState, miningBlock, player);
                                fortuneLevel = itemStack.getEnchantmentLevel(Enchantments.f_44987_);
                                silkTouchLevel = itemStack.getEnchantmentLevel(Enchantments.f_44985_);
                                exp = miningState.getExpDrop((LevelReader)this.m_9236_(), this.m_9236_().f_46441_, miningBlock, fortuneLevel, silkTouchLevel);
                                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemStack, (InteractionHand)InteractionHand.MAIN_HAND);
                                flag = this.m_9236_().m_46961_(miningBlock, false);
                                miningState.m_60734_().m_6240_(this.m_9236_(), player, miningBlock, miningState, this.m_9236_().m_7702_(miningBlock), itemStack);
                                if (flag && exp > 0 && (var21_24 = this.m_9236_()) instanceof ServerLevel) {
                                    serverLevel = (ServerLevel)var21_24;
                                    miningState.m_60734_().m_49805_(serverLevel, miningBlock, exp);
                                }
                                this.destroyBlockProgress = 0.0f;
                            }
                        }
                    }
                    break block38;
                }
                if (this.returnProgress < 1.0f) {
                    this.returnProgress = Math.min(1.0f, this.returnProgress + 0.2f);
                }
                if (this.lastSelectedBlock != null) {
                    this.m_9236_().m_6801_(player.m_19879_(), this.lastSelectedBlock, -1);
                    this.lastSelectedBlock = null;
                }
                moveTo = player.m_20182_().m_82520_(0.0, 1.0, 0.0);
                if ((double)this.m_20270_(controller) < 1.4 && !this.m_213877_()) {
                    if (!this.spawnedItem && player.m_36356_(this.getItemStack())) {
                        this.spawnedItem = true;
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    } else {
                        this.plopItem();
                    }
                }
            }
            if (moveTo != null) {
                this.directMovementTowards(moveTo, speed);
            }
        }
        if (this.playerUseCooldown > 0) {
            --this.playerUseCooldown;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.8999999761581421));
    }

    private void plopItem() {
        if (!this.spawnedItem) {
            this.spawnedItem = true;
            ItemEntity itementity = this.m_19983_(this.getItemStack());
            if (itementity != null) {
                itementity.m_32061_();
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void damageItem(int damageAmount) {
        Player player;
        LivingEntity living;
        Entity entity = this.getController();
        if (!(!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) instanceof Player && (player = (Player)living).m_7500_())) {
            ItemStack stack = this.getItemStack();
            stack.m_41622_(damageAmount, living, player1 -> player1.m_21190_(player1.m_7655_()));
            if (stack.m_41773_() >= stack.m_41776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public float getDigSpeed(Player player, BlockState state, @Nullable BlockPos pos) {
        int i;
        ItemStack stack = this.getItemStack();
        float f = stack.m_41691_(state);
        if (f > 1.0f && (i = EnchantmentHelper.m_44926_((LivingEntity)player)) > 0 && !stack.m_41619_()) {
            f += (float)(i * i + 1);
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            f *= (switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (this.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            f /= 5.0f;
        }
        if (!this.m_20096_()) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((Player)player, (BlockState)state, (float)f, (BlockPos)pos);
        return f;
    }

    private void hurtEntity(LivingEntity holder, Entity target) {
        int i;
        ItemStack itemStack = this.getItemStack();
        float f = (float)holder.m_21133_(Attributes.f_22281_) + (float)this.getDamageForItem(itemStack);
        float f1 = (float)holder.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)((LivingEntity)target).m_6336_());
            f1 += (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44980_, (LivingEntity)holder);
        }
        if ((i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemStack)) > 0) {
            target.m_20254_(i * 4);
        }
        if (target.m_6469_(this.m_269291_().m_269333_(holder), f)) {
            holder.m_19970_(holder, target);
            this.damageItem(1);
            if (f1 > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
        }
        if (this.m_6060_()) {
            target.m_20254_(5);
        }
        if (holder instanceof Player && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_6598_((Player)holder);
            if (living.m_21223_() <= 0.0f && holder.m_20270_(target) >= 19.5f) {
                ACAdvancementTriggerRegistry.KILL_MOB_WITH_GALENA_GAUNTLET.triggerForEntity((Entity)holder);
            }
        }
    }

    private void directMovementTowards(Vec3 moveTo, float speed) {
        Vec3 want = moveTo.m_82546_(this.m_20182_());
        if (want.m_82553_() > 1.0) {
            want = want.m_82541_();
        }
        float targetXRot = (float)(-(Mth.m_14136_((double)want.f_82480_, (double)want.m_165924_()) * 57.2957763671875));
        float targetYRot = (float)(-Mth.m_14136_((double)want.f_82479_, (double)want.f_82481_) * 57.2957763671875);
        if (this.isIdling()) {
            targetXRot = this.m_146909_();
            targetYRot = this.m_146908_() + 5.0f;
        }
        this.m_146926_(Mth.m_14148_((float)this.m_146909_(), (float)targetXRot, (float)5.0f));
        this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)targetYRot, (float)5.0f));
        this.m_20256_(this.m_20184_().m_82549_(want.m_82490_((double)speed)));
    }

    private boolean isOwnerWearingGauntlet() {
        LivingEntity living;
        Entity entity = this.getController();
        return entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().m_150930_((Item)ACItemRegistry.GALENA_GAUNTLET.get()) && living.m_6084_() && !this.returnFlag;
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("WeaponStack")) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("WeaponStack")));
        }
        if (tag.m_128403_("ControllerUUID")) {
            this.setControllerUUID(tag.m_128342_("ControllerUUID"));
        }
    }

    public double getDamageForItem(ItemStack itemStack) {
        Multimap map = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        if (!map.isEmpty()) {
            double d = 0.0;
            for (AttributeModifier mod : map.get((Object)Attributes.f_22281_)) {
                d += mod.m_22218_();
            }
            return d;
        }
        return 0.0;
    }

    protected void m_7380_(CompoundTag tag) {
        if (!this.getItemStack().m_41619_()) {
            CompoundTag stackTag = new CompoundTag();
            this.getItemStack().m_41739_(stackTag);
            tag.m_128365_("WeaponStack", (Tag)stackTag);
        }
        if (this.getControllerUUID() != null) {
            tag.m_128362_("ControllerUUID", this.getControllerUUID());
        }
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(ITEMSTACK);
    }

    public void setItemStack(ItemStack item) {
        this.f_19804_.m_135381_(ITEMSTACK, (Object)item);
    }

    public boolean isIdling() {
        return (Boolean)this.f_19804_.m_135370_(IDLING);
    }

    @Nullable
    public UUID getControllerUUID() {
        return ((Optional)this.f_19804_.m_135370_(CONTROLLER_UUID)).orElse(null);
    }

    public void setControllerUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CONTROLLER_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getController() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getControllerUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(CONTROLLER_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public Entity getTarget() {
        int id = (Integer)this.f_19804_.m_135370_(TARGET_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public float getStrikeProgress(float partialTick) {
        return this.prevStrikeProgress + (this.strikeProgress - this.prevStrikeProgress) * partialTick;
    }

    public float getReturnProgress(float partialTick) {
        return this.prevReturnProgress + (this.returnProgress - this.prevReturnProgress) * partialTick;
    }

    public Vec3 getControllerHandPos(Player controller, float partialTicks) {
        float yBodyRot = Mth.m_14179_((float)partialTicks, (float)controller.f_20884_, (float)controller.f_20883_);
        boolean mainHand = controller.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.GALENA_GAUNTLET.get());
        Vec3 offset = new Vec3((double)(controller.m_20205_() * (mainHand ? -0.75f : 0.75f)), (double)(controller.m_20206_() * 0.68f), (double)(controller.m_20205_() * -0.1f)).m_82524_((float)Math.toRadians(-yBodyRot));
        Vec3 armViewExtra = controller.m_20252_(partialTicks).m_82541_().m_82490_(0.75);
        return controller.m_20318_(partialTicks).m_82549_(offset).m_82549_(armViewExtra);
    }
}

