/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.config;

import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationNoiseCondition;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.event.EventReplaceBiome;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class BiomeGenerationConfig {
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final String OVERWORLD = "minecraft:overworld";
    private static final BiomeGenerationNoiseCondition MAGNETIC_CAVES_CONDITION = new BiomeGenerationNoiseCondition.Builder().dimensions("minecraft:overworld").distanceFromSpawn(400).alexscavesRarityOffset(0).continentalness(0.6f, 1.0f).depth(0.2f, 1.0f).build();
    private static final BiomeGenerationNoiseCondition PRIMORDIAL_CAVES_CONDITION = new BiomeGenerationNoiseCondition.Builder().dimensions("minecraft:overworld").distanceFromSpawn(450).alexscavesRarityOffset(1).continentalness(0.4f, 1.0f).depth(0.15f, 1.5f).build();
    private static final BiomeGenerationNoiseCondition TOXIC_CAVES_CONDITION = new BiomeGenerationNoiseCondition.Builder().dimensions("minecraft:overworld").distanceFromSpawn(650).alexscavesRarityOffset(2).continentalness(0.5f, 1.0f).depth(0.3f, 1.5f).build();
    private static final BiomeGenerationNoiseCondition ABYSSAL_CHASM_CONDITION = new BiomeGenerationNoiseCondition.Builder().dimensions("minecraft:overworld").distanceFromSpawn(400).alexscavesRarityOffset(3).continentalness(-0.95f, -0.65f).temperature(-1.0f, 0.5f).depth(0.2f, 1.5f).build();
    private static final BiomeGenerationNoiseCondition FORLORN_HOLLOWS_CONDITION = new BiomeGenerationNoiseCondition.Builder().dimensions("minecraft:overworld").distanceFromSpawn(650).alexscavesRarityOffset(4).continentalness(0.6f, 1.0f).depth(0.3f, 1.5f).build();
    private static Map<ResourceKey<Biome>, BiomeGenerationNoiseCondition> biomes = new HashMap<ResourceKey<Biome>, BiomeGenerationNoiseCondition>();

    public static void reloadConfig() {
        biomes.put(ACBiomeRegistry.MAGNETIC_CAVES, BiomeGenerationConfig.getConfigData("magnetic_caves", MAGNETIC_CAVES_CONDITION));
        biomes.put(ACBiomeRegistry.PRIMORDIAL_CAVES, BiomeGenerationConfig.getConfigData("primordial_caves", PRIMORDIAL_CAVES_CONDITION));
        biomes.put(ACBiomeRegistry.TOXIC_CAVES, BiomeGenerationConfig.getConfigData("toxic_caves", TOXIC_CAVES_CONDITION));
        biomes.put(ACBiomeRegistry.ABYSSAL_CHASM, BiomeGenerationConfig.getConfigData("abyssal_chasm", ABYSSAL_CHASM_CONDITION));
        biomes.put(ACBiomeRegistry.FORLORN_HOLLOWS, BiomeGenerationConfig.getConfigData("forlorn_hollows", FORLORN_HOLLOWS_CONDITION));
    }

    @Nullable
    public static ResourceKey<Biome> getBiomeForEvent(EventReplaceBiome event) {
        for (Map.Entry<ResourceKey<Biome>, BiomeGenerationNoiseCondition> condition : biomes.entrySet()) {
            if (!condition.getValue().test(event)) continue;
            return condition.getKey();
        }
        return null;
    }

    public static int getBiomeCount() {
        return biomes.size();
    }

    private static <T> T getOrCreateConfigFile(File configDir, String configName, T defaults, Type type, Predicate<T> isInvalid) {
        block8: {
            File configFile = new File(configDir, configName + ".json");
            if (!configFile.exists()) {
                try {
                    FileUtils.write((File)configFile, (CharSequence)GSON.toJson(defaults));
                }
                catch (IOException e) {
                    Citadel.LOGGER.error("Biome Generation Config: Could not write " + configFile, (Throwable)e);
                }
            }
            try {
                Object found = GSON.fromJson(FileUtils.readFileToString((File)configFile), type);
                if (isInvalid.test(found)) {
                    Citadel.LOGGER.warn("Old Biome Generation Config format found for " + configName + ", replacing with new one.");
                    try {
                        FileUtils.write((File)configFile, (CharSequence)GSON.toJson(defaults));
                    }
                    catch (IOException e) {
                        Citadel.LOGGER.error("Biome Generation Config: Could not write " + configFile, (Throwable)e);
                    }
                    break block8;
                }
                return (T)found;
            }
            catch (Exception e) {
                Citadel.LOGGER.error("Biome Generation Config: Could not load " + configFile, (Throwable)e);
            }
        }
        return defaults;
    }

    private static File getConfigDirectory() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path jsonPath = Paths.get(configPath.toAbsolutePath().toString(), "alexscaves_biome_generation");
        return jsonPath.toFile();
    }

    private static BiomeGenerationNoiseCondition getConfigData(String fileName, BiomeGenerationNoiseCondition defaultConfigData) {
        BiomeGenerationNoiseCondition configData = BiomeGenerationConfig.getOrCreateConfigFile(BiomeGenerationConfig.getConfigDirectory(), fileName, defaultConfigData, new TypeToken<BiomeGenerationNoiseCondition>(){}.getType(), BiomeGenerationNoiseCondition::isInvalid);
        return configData;
    }
}

