/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.RadgillEntity;
import com.github.alexmodguy.alexscaves.server.item.HazmatArmorItem;
import com.github.alexmodguy.alexscaves.server.message.WorldEventMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.RegistryObject;

public class AcidBlock
extends LiquidBlock {
    private static Map<Block, Block> CORRODES_INTERACTIONS;

    public AcidBlock(RegistryObject<FlowingFluid> flowingFluid, BlockBehaviour.Properties properties) {
        super(flowingFluid, properties);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        boolean top;
        if (randomSource.m_188503_(400) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ACSoundRegistry.ACID_IDLE.get(), SoundSource.BLOCKS, 0.5f, randomSource.m_188501_() * 0.4f + 0.8f, false);
        }
        if (randomSource.m_188503_((top = level.m_6425_(pos.m_7494_()).m_76178_()) ? 10 : 40) == 0) {
            float height = top ? state.m_60819_().m_76155_((BlockGetter)level, pos) : randomSource.m_188501_();
            level.m_7106_((ParticleOptions)ACParticleRegistry.ACID_BUBBLE.get(), (double)((float)pos.m_123341_() + randomSource.m_188501_()), (double)((float)pos.m_123342_() + height), (double)((float)pos.m_123343_() + randomSource.m_188501_()), (double)((randomSource.m_188501_() - 0.5f) * 0.1f), (double)(0.05f + randomSource.m_188501_() * 0.1f), (double)((randomSource.m_188501_() - 0.5f) * 0.1f));
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (!entity.m_6095_().m_204039_(ACTagRegistry.RESISTS_ACID) && entity.getFluidTypeHeight((FluidType)ACFluidRegistry.ACID_FLUID_TYPE.get()) > 0.1) {
            boolean armor = false;
            boolean hurtSound = false;
            float dmgMultiplier = 1.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    Player player;
                    ItemStack item;
                    if (!slot.m_254934_() || (item = living.m_6844_(slot)) == null || !item.m_41763_() || item.m_41720_() instanceof HazmatArmorItem) continue;
                    armor = true;
                    if (!(living.m_217043_().m_188501_() < 0.05f) || entity instanceof Player && (player = (Player)entity).m_7500_()) continue;
                    item.m_41622_(1, living, e -> e.m_21166_(slot));
                }
                dmgMultiplier = 1.0f - (float)HazmatArmorItem.getWornAmount(living) / 4.0f;
            }
            if (armor) {
                ACAdvancementTriggerRegistry.ENTER_ACID_WITH_ARMOR.triggerForEntity(entity);
            }
            if (level.f_46441_.m_188501_() < dmgMultiplier) {
                hurtSound = entity.m_6469_(ACDamageTypes.causeAcidDamage(level.m_9598_()), dmgMultiplier * (float)(armor ? 0.01 : 1.0));
            }
            if (hurtSound) {
                entity.m_216990_((SoundEvent)ACSoundRegistry.ACID_BURN.get());
            }
        }
        if (entity instanceof LivingEntity && entity.f_19788_ > entity.f_19829_ && !(entity instanceof RadgillEntity)) {
            entity.f_19829_ = entity.f_19788_ + 1.0f;
            Vec3 vec3 = entity.m_20184_();
            float f1 = Math.min(1.0f, (float)vec3.m_82553_());
            entity.m_5496_((SoundEvent)ACSoundRegistry.ACID_SWIM.get(), f1, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState state2, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, state2, isMoving);
        this.tickCorrosion(worldIn, pos);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.tickCorrosion(worldIn, pos);
    }

    public void tickCorrosion(Level worldIn, BlockPos pos) {
        AcidBlock.initCorrosion();
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            BlockPos offset = pos.m_121945_(direction);
            BlockState state1 = worldIn.m_8055_(offset);
            if (!CORRODES_INTERACTIONS.containsKey(state1.m_60734_())) continue;
            AlexsCaves.sendMSGToAll(new WorldEventMessage(0, offset.m_123341_(), offset.m_123342_(), offset.m_123343_()));
            BlockState transform = CORRODES_INTERACTIONS.get(state1.m_60734_()).m_49966_();
            for (Property prop : state1.m_61147_()) {
                transform = transform.m_61138_(prop) ? (BlockState)transform.m_61124_(prop, state1.m_61143_(prop)) : transform;
            }
            worldIn.m_46597_(offset, transform);
            Vec3 vec3 = offset.m_252807_();
            Player player = worldIn.m_45924_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 8.0, false);
            if (player == null) continue;
            ACAdvancementTriggerRegistry.ACID_CREATE_RUST.triggerForEntity((Entity)player);
        }
    }

    public static boolean doesBlockCorrode(BlockState state) {
        AcidBlock.initCorrosion();
        return CORRODES_INTERACTIONS.containsKey(state.m_60734_());
    }

    private static void initCorrosion() {
        if (CORRODES_INTERACTIONS != null) {
            return;
        }
        CORRODES_INTERACTIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(Blocks.f_152504_, Blocks.f_152502_);
            map.put(Blocks.f_152502_, Blocks.f_152503_);
            map.put(Blocks.f_152503_, Blocks.f_152501_);
            map.put(Blocks.f_152510_, Blocks.f_152508_);
            map.put(Blocks.f_152508_, Blocks.f_152509_);
            map.put(Blocks.f_152509_, Blocks.f_152507_);
            map.put(Blocks.f_152570_, Blocks.f_152568_);
            map.put(Blocks.f_152568_, Blocks.f_152569_);
            map.put(Blocks.f_152569_, Blocks.f_152567_);
            map.put(Blocks.f_152566_, Blocks.f_152564_);
            map.put(Blocks.f_152564_, Blocks.f_152565_);
            map.put(Blocks.f_152565_, Blocks.f_152563_);
            map.put((Block)ACBlockRegistry.SCRAP_METAL.get(), (Block)ACBlockRegistry.RUSTY_SCRAP_METAL.get());
            map.put((Block)ACBlockRegistry.SCRAP_METAL_PLATE.get(), (Block)ACBlockRegistry.RUSTY_SCRAP_METAL_PLATE.get());
            map.put((Block)ACBlockRegistry.METAL_BARREL.get(), (Block)ACBlockRegistry.RUSTY_BARREL.get());
            map.put((Block)ACBlockRegistry.METAL_SCAFFOLDING.get(), (Block)ACBlockRegistry.RUSTY_SCAFFOLDING.get());
            map.put((Block)ACBlockRegistry.METAL_REBAR.get(), (Block)ACBlockRegistry.RUSTY_REBAR.get());
        });
    }
}

