/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.misc;

import com.github.alexmodguy.alexscaves.client.render.misc.DefaultMapBackgrounds;
import com.github.alexmodguy.alexscaves.server.item.CaveMapItem;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.joml.Matrix4f;

public class CaveMapRenderer {
    private static final Map<ItemStack, CaveMapRenderer> CAVE_MAPS_ITEM_FRAME = new HashMap<ItemStack, CaveMapRenderer>();
    private static final Map<ItemStack, CaveMapRenderer> CAVE_MAPS_HAND = new HashMap<ItemStack, CaveMapRenderer>();
    public static final RenderType MAP_BACKGROUND = RenderType.m_110497_((ResourceLocation)new ResourceLocation("textures/map/map_background.png"));
    public static final RenderType CAVE_MAP_PLAYER_TEXTURE = RenderType.m_110497_((ResourceLocation)new ResourceLocation("alexscaves", "textures/misc/map/cave_map_player.png"));
    public static final RenderType CAVE_MAP_PLAYER_DIRECTION_TEXTURE = RenderType.m_110497_((ResourceLocation)new ResourceLocation("alexscaves", "textures/misc/map/cave_map_player_direction.png"));
    private final RenderType renderType;
    public BlockPos target;
    private final DynamicTexture texture;
    public List<BiomeLabel> labels = new ArrayList<BiomeLabel>();
    public final int[] mapBiomes;
    private final boolean transparent;

    public CaveMapRenderer(BlockPos target, int[] mapBiomes, long seed, boolean transparent, int index) {
        this.transparent = transparent;
        this.target = target;
        this.mapBiomes = mapBiomes;
        this.texture = new DynamicTexture(128, 128, true);
        ResourceLocation resourcelocation = Minecraft.m_91087_().f_90987_.m_118490_("cave_map/" + index + (transparent ? "" : "_frame"), this.texture);
        this.renderType = RenderType.m_110497_((ResourceLocation)resourcelocation);
        this.updateTexture();
        this.updateLabels(new LegacyRandomSource(seed));
    }

    public static CaveMapRenderer getMapFor(ItemStack item, boolean transparent) {
        if (transparent) {
            if (CAVE_MAPS_HAND.containsKey(item)) {
                return CAVE_MAPS_HAND.get(item);
            }
            CaveMapRenderer mapRenderer = new CaveMapRenderer(CaveMapItem.getBiomeBlockPos(item), CaveMapItem.createBiomeArray(item), CaveMapItem.getSeed(item), transparent, CAVE_MAPS_HAND.size());
            CAVE_MAPS_HAND.put(item, mapRenderer);
            return mapRenderer;
        }
        if (CAVE_MAPS_ITEM_FRAME.containsKey(item)) {
            return CAVE_MAPS_ITEM_FRAME.get(item);
        }
        CaveMapRenderer mapRenderer = new CaveMapRenderer(CaveMapItem.getBiomeBlockPos(item), CaveMapItem.createBiomeArray(item), CaveMapItem.getSeed(item), transparent, CAVE_MAPS_ITEM_FRAME.size());
        CAVE_MAPS_ITEM_FRAME.put(item, mapRenderer);
        return mapRenderer;
    }

    private void updateTexture() {
        Registry registry = Minecraft.m_91087_().f_91073_.m_9598_().m_6632_(Registries.f_256952_).orElse(null);
        if (registry != null && this.mapBiomes.length >= 16384) {
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    int k = j + i * 128;
                    int biomeId = this.mapBiomes[k];
                    Holder biome = (Holder)registry.m_206115_().m_7942_(biomeId);
                    int biomeColor = biome.m_203656_(ACTagRegistry.CAVE_MAP_BORDER_ON) && this.isBorderBiome((Registry<Biome>)registry, (Holder<Biome>)biome, i, j) ? DefaultMapBackgrounds.BORDER.getMapColor(i, j) : this.getBiomeColor((Holder<Biome>)biome, j, i);
                    int r = FastColor.ABGR32.m_266313_((int)biomeColor);
                    int g = FastColor.ABGR32.m_266446_((int)biomeColor);
                    int b = FastColor.ABGR32.m_266247_((int)biomeColor);
                    double edge = Math.sqrt((i - 64) * (i - 64) + (j - 64) * (j - 64)) / 128.0;
                    int alpha = this.transparent ? Math.max(255 - (int)(255.0 * (edge * edge)), 10) : 255;
                    this.texture.m_117991_().m_84988_(j, i, FastColor.ABGR32.m_266248_((int)alpha, (int)b, (int)g, (int)r));
                }
            }
        }
        this.texture.m_117985_();
    }

    private boolean isBorderBiome(Registry<Biome> registry, Holder<Biome> biome, int i, int j) {
        int k = j + i * 128;
        int left = k - 1;
        int right = k + 1;
        int up = j + (i - 1) * 128;
        int down = j + (i + 1) * 128;
        if (left >= 0 && left < this.mapBiomes.length && left % 128 != 127 && left % 128 != 0 && registry.m_206115_().m_7942_(this.mapBiomes[left]) != biome) {
            return true;
        }
        if (right >= 0 && right < this.mapBiomes.length && right % 128 != 127 && right % 128 != 0 && registry.m_206115_().m_7942_(this.mapBiomes[right]) != biome) {
            return true;
        }
        if (up >= 0 && up < this.mapBiomes.length && up % 128 != 127 && up % 128 != 0 && registry.m_206115_().m_7942_(this.mapBiomes[up]) != biome) {
            return true;
        }
        return down >= 0 && down < this.mapBiomes.length && down % 128 != 127 && down % 128 != 0 && registry.m_206115_().m_7942_(this.mapBiomes[down]) != biome;
    }

    private void updateLabels(LegacyRandomSource random) {
        this.labels.clear();
        int extraBiomes = random.m_188503_(3) + 3;
        Registry registry = Minecraft.m_91087_().f_91073_.m_9598_().m_6632_(Registries.f_256952_).orElse(null);
        if (registry != null && this.mapBiomes.length >= 16384) {
            Pair<Integer, Integer> targetBiomeLoc = this.centerBiomeCoordinates(64, 64);
            BiomeLabel centerLabel = this.buildLabelFrom(targetBiomeLoc, (Registry<Biome>)registry, ((Integer)targetBiomeLoc.getFirst() - 64) / 2, true);
            this.labels.add(centerLabel);
            for (int i = 0; i < extraBiomes; ++i) {
                Vec3 randomOffsetFromCenterVec = new Vec3(0.0, 0.0, (double)(random.m_188503_(20) + 40)).m_82524_((float)Math.toRadians(360.0f / (float)extraBiomes * (float)i + random.m_188501_() * 40.0f));
                int offsetX = Mth.m_14045_((int)(centerLabel.x() + (int)randomOffsetFromCenterVec.f_82479_), (int)10, (int)118);
                int offsetY = Mth.m_14045_((int)(centerLabel.y() + (int)randomOffsetFromCenterVec.f_82481_), (int)10, (int)118);
                Pair<Integer, Integer> extraBiomeLoc = this.centerBiomeCoordinates(offsetX, offsetY);
                BiomeLabel builtLabel = this.buildLabelFrom(extraBiomeLoc, (Registry<Biome>)registry, ((Integer)extraBiomeLoc.getFirst() - 64) / 2, false);
                if (this.labels.stream().anyMatch(biomeLabel -> biomeLabel.conflictsWith(builtLabel))) continue;
                this.labels.add(builtLabel);
            }
        }
    }

    private BiomeLabel buildLabelFrom(Pair<Integer, Integer> targetBiomeLoc, Registry<Biome> registry, int rotation, boolean center) {
        int k = (Integer)targetBiomeLoc.getFirst() + (Integer)targetBiomeLoc.getSecond() * 128;
        int biomeId = this.mapBiomes[k];
        ResourceKey biomeResourceKey = (ResourceKey)((Holder)registry.m_206115_().m_7942_(biomeId)).m_203543_().get();
        return new BiomeLabel((ResourceKey<Biome>)biomeResourceKey, (Integer)targetBiomeLoc.getFirst(), (Integer)targetBiomeLoc.getSecond(), rotation);
    }

    private Pair<Integer, Integer> centerBiomeCoordinates(int xIn, int yIn) {
        int colorFor = this.mapBiomes[xIn + yIn * 128];
        int farRightX = xIn;
        int farUpY = yIn;
        int farDownY = yIn;
        for (int farLeftX = xIn; farLeftX > 0 && this.mapBiomes[farLeftX + yIn * 128] == colorFor; --farLeftX) {
        }
        while (farRightX < 128 && this.mapBiomes[farRightX + yIn * 128] == colorFor) {
            ++farRightX;
        }
        while (farDownY > 0 && this.mapBiomes[xIn + farDownY * 128] == colorFor) {
            --farDownY;
        }
        while (farUpY < 128 && this.mapBiomes[xIn + farUpY * 128] == colorFor) {
            ++farUpY;
        }
        return new Pair((Object)xIn, (Object)yIn);
    }

    private int getBiomeColor(Holder<Biome> biome, int u, int v) {
        if (biome.m_203565_(ACBiomeRegistry.MAGNETIC_CAVES)) {
            return DefaultMapBackgrounds.MAGNETIC_CAVES.getMapColor(u, v);
        }
        if (biome.m_203565_(ACBiomeRegistry.PRIMORDIAL_CAVES)) {
            return DefaultMapBackgrounds.PRIMORDIAL_CAVES.getMapColor(u, v);
        }
        if (biome.m_203565_(ACBiomeRegistry.TOXIC_CAVES)) {
            return DefaultMapBackgrounds.TOXIC_CAVES.getMapColor(u, v);
        }
        if (biome.m_203565_(ACBiomeRegistry.ABYSSAL_CHASM)) {
            return DefaultMapBackgrounds.ABYSSAL_CHASM.getMapColor(u, v);
        }
        if (biome.m_203565_(ACBiomeRegistry.FORLORN_HOLLOWS)) {
            return DefaultMapBackgrounds.FORLORN_HOLLOWS.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_SNOWY) && biome.m_203656_(BiomeTags.f_207603_)) {
            return DefaultMapBackgrounds.FROZEN_OCEAN.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_WATER)) {
            return DefaultMapBackgrounds.WATER.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_DESERT)) {
            return DefaultMapBackgrounds.DESERT.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_207610_)) {
            return DefaultMapBackgrounds.JUNGLE.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_207607_)) {
            return DefaultMapBackgrounds.BADLANDS.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_MOUNTAIN) && biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return DefaultMapBackgrounds.SNOWY_MOUNTAIN.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS) && biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return DefaultMapBackgrounds.SNOWY_TAIGA.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_MOUNTAIN)) {
            return DefaultMapBackgrounds.MOUNTAIN.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            return DefaultMapBackgrounds.SWAMP.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_SNOWY) && biome.m_203656_(Tags.Biomes.IS_RARE)) {
            return DefaultMapBackgrounds.ICE_SPIKES.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return DefaultMapBackgrounds.SNOWY.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_CONIFEROUS)) {
            return DefaultMapBackgrounds.TAIGA.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_MUSHROOM)) {
            return DefaultMapBackgrounds.MUSHROOM.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_207611_) && biome.m_203656_(Tags.Biomes.IS_SPOOKY)) {
            return DefaultMapBackgrounds.ROOFED_FOREST.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_207611_)) {
            return DefaultMapBackgrounds.FOREST.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_215816_)) {
            return DefaultMapBackgrounds.SAVANNA.getMapColor(u, v);
        }
        if (biome.m_203656_(Tags.Biomes.IS_PLAINS)) {
            return DefaultMapBackgrounds.PLAINS.getMapColor(u, v);
        }
        if (biome.m_203565_(Biomes.f_186760_)) {
            return DefaultMapBackgrounds.STONY_SHORE.getMapColor(u, v);
        }
        if (biome.m_203656_(BiomeTags.f_207604_)) {
            return DefaultMapBackgrounds.BEACH.getMapColor(u, v);
        }
        if (biome.m_203565_(Biomes.f_151784_)) {
            return DefaultMapBackgrounds.DRIPSTONE_CAVES.getMapColor(u, v);
        }
        if (biome.m_203565_(Biomes.f_151785_)) {
            return DefaultMapBackgrounds.LUSH_CAVES.getMapColor(u, v);
        }
        if (biome.m_203565_(Biomes.f_220594_)) {
            return DefaultMapBackgrounds.DEEP_DARK.getMapColor(u, v);
        }
        return DefaultMapBackgrounds.DEFAULT.getMapColor(u, v);
    }

    public void renderLabels(PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        for (BiomeLabel label : this.labels) {
            poseStack.m_85836_();
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent component = Component.m_237115_((String)this.getBiomeString(label.biome.m_135782_().toString()));
            int textWidth = font.m_92724_(component.m_7532_());
            float distFromCenter = (float)Math.sqrt((label.x() - 64) * (label.x() - 64) + (label.y() - 64) * (label.y() - 64));
            float textScale = Mth.m_14036_((float)((128.0f - distFromCenter) / 128.0f), (float)0.5f, (float)1.0f) * Math.min(100.0f / (float)textWidth, 1.0f);
            if ((float)label.x() - (float)textWidth * 0.5f < 0.0f) {
                poseStack.m_252880_((float)textWidth * 0.25f, 0.0f, 0.0f);
            }
            poseStack.m_252880_(0.0f + (float)label.x() - (float)textWidth * textScale / 2.0f, (float)label.y(), -0.025f);
            poseStack.m_85841_(textScale, textScale, -1.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)label.rotation()));
            poseStack.m_85836_();
            poseStack.m_85841_(1.1f, 1.1f, 1.1f);
            float f1 = -textWidth / 4;
            int color1 = 8874331;
            int color2 = 15457474;
            font.m_168645_(component.m_7532_(), f1, 0.0f, color1, color2, poseStack.m_85850_().m_252922_(), multiBufferSource, light);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, ItemStack map, boolean fullFrame, int light) {
        if (fullFrame) {
            poseStack.m_252880_(-64.0f, -64.0f, 55.0f);
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(this.renderType);
        vertexconsumer.m_252986_(matrix4f, 0.0f, 128.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 128.0f, 128.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 128.0f, 0.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        vertexconsumer.m_252986_(matrix4f, 0.0f, 0.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
        this.renderLabels(poseStack, multiBufferSource, light);
        if (!fullFrame) {
            poseStack.m_85836_();
            double dimensionScale = Minecraft.m_91087_().f_91074_.m_9236_().m_6042_().f_63859_();
            double playerX = (Minecraft.m_91087_().f_91074_.m_20185_() * dimensionScale - (double)this.target.m_123341_()) / (double)CaveMapItem.MAP_SCALE;
            double playerZ = (Minecraft.m_91087_().f_91074_.m_20189_() * dimensionScale - (double)this.target.m_123343_()) / (double)CaveMapItem.MAP_SCALE;
            float renderPlayerX = Mth.m_14036_((float)((float)playerX + 64.0f), (float)0.0f, (float)128.0f);
            float renderPlayerZ = Mth.m_14036_((float)((float)playerZ + 64.0f), (float)0.0f, (float)128.0f);
            poseStack.m_252880_(renderPlayerX, renderPlayerZ, -0.05f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Minecraft.m_91087_().f_91074_.m_146908_() + 180.0f));
            this.renderDetail(multiBufferSource.m_6299_(CAVE_MAP_PLAYER_TEXTURE), poseStack, 3, light, 4.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private String getBiomeString(String id) {
        return "biome." + id.replace(":", ".");
    }

    private void renderDetail(VertexConsumer vertexconsumer1, PoseStack poseStack, int yOffset, int light, float scale) {
        Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
        vertexconsumer1.m_252986_(matrix4f1, -1.0f * scale, 1.0f * scale, (float)yOffset * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer1.m_252986_(matrix4f1, 1.0f * scale, 1.0f * scale, (float)yOffset * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
        vertexconsumer1.m_252986_(matrix4f1, 1.0f * scale, -1.0f * scale, (float)yOffset * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
        vertexconsumer1.m_252986_(matrix4f1, -1.0f * scale, -1.0f * scale, (float)yOffset * -0.001f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
    }

    private record BiomeLabel(ResourceKey<Biome> biome, int x, int y, int rotation) {
        public boolean conflictsWith(BiomeLabel other) {
            int xD = this.x - other.x;
            int yD = this.y - other.y;
            return Math.sqrt(xD * xD + yD * yD) <= 40.0 || this.biome.equals(other.biome);
        }
    }
}

