/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.item;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.item.RaygunItem;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RaygunRenderHelper {
    private static final ResourceLocation RAYGUN_RAY = new ResourceLocation("alexscaves:textures/entity/raygun_ray.png");

    private static void renderRay(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 vec3, float useAmount, float offset, boolean irradiated) {
        float f2 = -1.0f * (offset * 0.25f % 1.0f);
        poseStack.m_85836_();
        float length = (float)vec3.m_82553_();
        vec3 = vec3.m_82541_();
        float f5 = (float)Math.acos(vec3.f_82480_);
        float f6 = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(offset * 3.0f));
        float f8 = 1.0f;
        int j = (int)(f8 * 255.0f);
        int k = (int)(f8 * 255.0f);
        int l = (int)(f8 * 255.0f);
        float v = -1.0f + f2;
        float v1 = length * 1.0f + v;
        float endWidth = 1.3f;
        float startMiddle = 0.0f;
        if (irradiated) {
            PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
        }
        VertexConsumer ivertexbuilder = bufferSource.m_6299_(ACRenderTypes.getRaygunRay(RAYGUN_RAY, irradiated));
        PoseStack.Pose matrixstack$entry = poseStack.m_85850_();
        poseStack.m_85836_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, startMiddle, 0.0f, 0.0f, j, k, l, 0.5f, v);
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, -endWidth, length, 0.0f, j, k, l, 0.0f, v1);
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, endWidth, length, 0.0f, j, k, l, 1.0f, v1);
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, 0.0f, 0.0f, startMiddle, j, k, l, 0.5f, v);
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, 0.0f, length, endWidth, j, k, l, 1.0f, v1);
        RaygunRenderHelper.vertex(ivertexbuilder, matrix4f, matrix3f, 0.0f, length, -endWidth, j, k, l, 0.0f, v1);
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float x, float y, float z, int p_229108_6_, int p_229108_7_, int p_229108_8_, float u, float v) {
        p_229108_0_.m_252986_(p_229108_1_, x, y, z).m_6122_(p_229108_6_, p_229108_7_, p_229108_8_, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_229108_2_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderRaysFor(LivingEntity entity, Vec3 rayFrom, PoseStack poseStack, MultiBufferSource bufferSource, float partialTick, boolean firstPerson, int firstPersonPass) {
        Vec3 vec3;
        Vec3 gunPos;
        Vec3 rayPosition;
        float ageInTicks;
        float useRaygunAmount;
        ItemStack stack;
        if (entity.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RaygunItem && entity.m_6117_()) {
            stack = entity.m_21120_(InteractionHand.MAIN_HAND);
            useRaygunAmount = (float)RaygunItem.getUseTime(stack) / 5.0f;
            ageInTicks = (float)entity.f_19797_ + partialTick;
            rayPosition = RaygunItem.getLerpedRayPosition(stack, partialTick);
            if (rayPosition != null && (float)RaygunItem.getUseTime(stack) >= 5.0f) {
                gunPos = RaygunRenderHelper.getGunOffset(entity, partialTick, firstPerson, entity.m_5737_() == HumanoidArm.LEFT);
                vec3 = rayPosition.m_82546_(rayFrom.m_82549_(gunPos));
                poseStack.m_85836_();
                poseStack.m_85837_(gunPos.f_82479_, gunPos.f_82480_, gunPos.f_82481_);
                if (firstPersonPass == 0 || firstPersonPass == 1) {
                    RaygunRenderHelper.renderRay(poseStack, bufferSource, vec3, useRaygunAmount, ageInTicks, false);
                }
                if (firstPersonPass == 0 || firstPersonPass == 2) {
                    RaygunRenderHelper.renderRay(poseStack, bufferSource, vec3, useRaygunAmount, ageInTicks, true);
                }
                poseStack.m_85849_();
            }
        }
        if (entity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof RaygunItem && entity.m_6117_()) {
            stack = entity.m_21120_(InteractionHand.OFF_HAND);
            useRaygunAmount = (float)RaygunItem.getUseTime(stack) / 5.0f;
            ageInTicks = (float)entity.f_19797_ + partialTick;
            rayPosition = RaygunItem.getLerpedRayPosition(stack, partialTick);
            if (rayPosition != null && (float)RaygunItem.getUseTime(stack) >= 5.0f) {
                gunPos = RaygunRenderHelper.getGunOffset(entity, partialTick, firstPerson, entity.m_5737_() == HumanoidArm.RIGHT);
                vec3 = rayPosition.m_82546_(rayFrom.m_82549_(gunPos));
                poseStack.m_85836_();
                poseStack.m_85837_(gunPos.f_82479_, gunPos.f_82480_, gunPos.f_82481_);
                if (firstPersonPass == 0 || firstPersonPass == 1) {
                    RaygunRenderHelper.renderRay(poseStack, bufferSource, vec3, useRaygunAmount, ageInTicks, false);
                }
                if (firstPersonPass == 0 || firstPersonPass == 2) {
                    RaygunRenderHelper.renderRay(poseStack, bufferSource, vec3, useRaygunAmount, ageInTicks, true);
                }
                poseStack.m_85849_();
            }
        }
    }

    private static Vec3 getGunOffset(LivingEntity entity, float partialTicks, boolean firstPerson, boolean left) {
        int i;
        int n = i = left ? -1 : 1;
        if (firstPerson) {
            double d7 = 1000.0 / (double)((Integer)Minecraft.m_91087_().m_91290_().f_114360_.m_231837_().m_231551_()).intValue();
            Vec3 vec3 = Minecraft.m_91087_().m_91290_().f_114358_.m_167684_().m_167695_((float)i * 0.35f, -0.25f);
            float f = entity.m_21324_(partialTicks);
            float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
            vec3 = vec3.m_82490_(d7);
            vec3 = vec3.m_82524_(f1 * 0.5f);
            vec3 = vec3.m_82496_(-f1 * 0.7f);
            return vec3;
        }
        float yBodyRot = Mth.m_14179_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        Vec3 offset = new Vec3((double)(entity.m_20205_() * -0.5f * (float)i), (double)(entity.m_20206_() * 0.8f), 0.0).m_82524_((float)Math.toRadians(-yBodyRot));
        Vec3 armViewExtra = entity.m_20252_(partialTicks).m_82541_().m_82490_(1.5);
        return offset.m_82549_(armViewExtra);
    }
}

