/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.VallumraptorModel;
import com.github.alexmodguy.alexscaves.server.entity.living.VallumraptorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class VallumraptorRenderer
extends MobRenderer<VallumraptorEntity, VallumraptorModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/vallumraptor.png");
    private static final ResourceLocation TEXTURE_ELDER = new ResourceLocation("alexscaves:textures/entity/vallumraptor_elder.png");
    private static final ResourceLocation TEXTURE_ALAN = new ResourceLocation("alexscaves:textures/entity/vallumraptor_alan.png");
    private static final ResourceLocation TEXTURE_ALAN_ELDER = new ResourceLocation("alexscaves:textures/entity/vallumraptor_alan_elder.png");
    private static final ResourceLocation TEXTURE_RETRO = new ResourceLocation("alexscaves:textures/entity/vallumraptor_retro.png");
    private static final ResourceLocation TEXTURE_RETRO_ELDER = new ResourceLocation("alexscaves:textures/entity/vallumraptor_retro_elder.png");

    public VallumraptorRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new VallumraptorModel(), 0.3f);
        this.m_115326_(new ItemLayer());
    }

    protected void scale(VallumraptorEntity mob, PoseStack matrixStackIn, float partialTicks) {
        if (mob.isElder()) {
            matrixStackIn.m_85841_(1.1f, 1.1f, 1.1f);
        }
        float alpha = 1.0f - 0.9f * mob.getHideProgress(partialTicks);
        ((VallumraptorModel)this.f_115290_).setAlpha(alpha);
    }

    public ResourceLocation getTextureLocation(VallumraptorEntity entity) {
        if (entity.m_8077_() && "alan".equalsIgnoreCase(entity.m_7755_().getString())) {
            return entity.isElder() ? TEXTURE_ALAN_ELDER : TEXTURE_ALAN;
        }
        if (entity.isRetro()) {
            return entity.isElder() ? TEXTURE_RETRO_ELDER : TEXTURE_RETRO;
        }
        return entity.isElder() ? TEXTURE_ELDER : TEXTURE;
    }

    @Nullable
    protected RenderType getRenderType(VallumraptorEntity entity, boolean defColor, boolean invis, boolean v) {
        if (entity.getHideProgress(1.0f) > 0.0f) {
            ResourceLocation resourcelocation = this.getTextureLocation(entity);
            return RenderType.m_110473_((ResourceLocation)resourcelocation);
        }
        return super.m_7225_((LivingEntity)entity, defColor, invis, v);
    }

    class ItemLayer
    extends RenderLayer<VallumraptorEntity, VallumraptorModel> {
        public ItemLayer() {
            super((RenderLayerParent)VallumraptorRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, VallumraptorEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = entitylivingbaseIn.m_21205_();
            if (!itemstack.m_41619_()) {
                boolean left = entitylivingbaseIn.m_21526_();
                matrixStackIn.m_85836_();
                if (entitylivingbaseIn.m_6162_()) {
                    matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                    matrixStackIn.m_85837_(0.0, 1.5, 0.0);
                }
                matrixStackIn.m_85836_();
                ((VallumraptorModel)this.m_117386_()).translateToHand(matrixStackIn, left);
                if (entitylivingbaseIn.m_6162_()) {
                    matrixStackIn.m_85837_(0.0, (double)0.1f, -0.6);
                }
                matrixStackIn.m_252880_(left ? -0.2f : 0.2f, 0.2f, -0.3f);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-10.0f));
                ItemInHandRenderer renderer = Minecraft.m_91087_().m_91290_().m_234586_();
                renderer.m_269530_((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
            }
        }
    }
}

