/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.thread;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConditionalRunnable {
    private final Runnable runnable;
    private final ConditionChecker conditionChecker;
    private final ScheduledExecutorService scheduler;

    private ConditionalRunnable(Runnable runnable, ConditionChecker conditionChecker) {
        this.runnable = runnable;
        this.conditionChecker = conditionChecker;
        this.scheduler = Executors.newScheduledThreadPool(5);
    }

    public static void create(Runnable runnable, ConditionChecker conditionChecker) {
        new ConditionalRunnable(runnable, conditionChecker).start();
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this::executeIfConditionSucceeds, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    private void executeIfConditionSucceeds() {
        if (this.conditionChecker.checkCondition()) {
            this.scheduler.shutdown();
            this.runnable.run();
        }
    }

    public static interface ConditionChecker {
        public boolean checkCondition();
    }
}

