/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GNetworkHandler;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class SpectreFlare
extends FireworkRocketEntity {
    public SpectreFlare(EntityType<? extends SpectreFlare> type, Level world) {
        super(type, world);
    }

    public SpectreFlare(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        super(world, stack, entity, x, y, z, shotAtAngle);
    }

    public SpectreFlare(Level level, @Nullable Entity entity, double d, double e, double f, ItemStack itemStack) {
        this(level, d, e, f, itemStack);
        this.m_5602_(entity);
    }

    public SpectreFlare(Level level, double d, double e, double f, ItemStack itemStack) {
        super((EntityType)GEntityTypes.SPECTRE_FLARE.get(), level);
        this.f_37022_ = 0;
        this.m_6034_(d, e, f);
        if (!itemStack.m_41619_() && itemStack.m_41782_()) {
            this.f_19804_.m_135381_(f_37019_, (Object)itemStack.m_41777_());
        }
        this.m_20334_(this.f_19796_.m_216328_(0.0, 0.002297), 0.05, this.f_19796_.m_216328_(0.0, 0.002297));
        this.f_37023_ = 100;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_37022_ > this.f_37023_) {
            this.spawnSpectatorVision(this.m_20182_());
            this.m_9236_().m_7605_((Entity)this, (byte)17);
            this.m_146852_(GameEvent.f_157812_, this.m_19749_());
            this.m_146870_();
        }
    }

    public EntityType<?> m_6095_() {
        return (EntityType)GEntityTypes.SPECTRE_FLARE.get();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.m_9236_().m_5776_()) {
            BlockPos hitPos = result.m_82425_();
            BlockPos placePos = hitPos.m_121945_(result.m_82434_());
            if (this.m_9236_().m_8055_(hitPos).m_60838_((BlockGetter)this.m_9236_(), hitPos) && (!this.m_9236_().m_6425_(placePos).m_205070_(FluidTags.f_13132_) || this.m_9236_().m_7433_(placePos, DripstoneUtils::m_159664_))) {
                this.spawnSpectatorVision(Vec3.m_82512_((Vec3i)placePos));
            }
            this.m_146870_();
        }
    }

    private void spawnSpectatorVision(Vec3 vec3) {
        ServerPlayer serverPlayer;
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer && !((SpectreBoundSpyglass)(serverPlayer = (ServerPlayer)entity)).isUsingSpectreBoundedSpyglass()) {
            SpectatorVision spectatorVision = SpectatorVision.create(this.m_9236_(), vec3, serverPlayer, 120);
            serverPlayer.m_6330_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), this.m_5720_(), 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)spectatorVision);
            ((SpectreBoundSpyglass)serverPlayer).setUsingSpectreBoundedSpyglass(true);
            GNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SendPerspectivePacket(serverPlayer.m_20148_(), spectatorVision.m_19879_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isCameraEntitySpectatorVision() {
        return Minecraft.m_91087_().m_91288_() instanceof Spectatable;
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)GItems.SPECTRE_FLARE.get());
    }
}

