/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.galosphere.datagen.GBiomeTagsProvider;
import net.orcinus.galosphere.datagen.GBlockTagsProvider;
import net.orcinus.galosphere.datagen.GBlockstateProvider;
import net.orcinus.galosphere.datagen.GDatapackBuiltinEntriesProvider;
import net.orcinus.galosphere.datagen.GEntityTypeTagsProvider;
import net.orcinus.galosphere.datagen.GItemModelProvider;
import net.orcinus.galosphere.datagen.GItemTagsProvider;
import net.orcinus.galosphere.datagen.GLootTableProvider;
import net.orcinus.galosphere.datagen.GRecipeProvider;

@Mod.EventBusSubscriber(modid="galosphere", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GDataGenerator {
    private GDataGenerator() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        dataGenerator.addProvider(client, (DataProvider)new GBlockstateProvider(packOutput, helper));
        dataGenerator.addProvider(client, (DataProvider)new GItemModelProvider(packOutput, helper));
        dataGenerator.addProvider(server, (DataProvider)new GRecipeProvider(packOutput));
        dataGenerator.addProvider(server, (DataProvider)new GLootTableProvider(packOutput));
        GBlockTagsProvider blockTagsProvider = new GBlockTagsProvider(packOutput, lookupProvider, helper);
        dataGenerator.addProvider(server, (DataProvider)blockTagsProvider);
        dataGenerator.addProvider(server, (DataProvider)new GItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), helper));
        dataGenerator.addProvider(server, (DataProvider)new GEntityTypeTagsProvider(packOutput, lookupProvider, helper));
        dataGenerator.addProvider(server, (DataProvider)new GDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new GBiomeTagsProvider(packOutput, lookupProvider, helper));
    }
}

