/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import net.orcinus.galosphere.blocks.SilverLatticeBlock;
import net.orcinus.galosphere.init.GBlocks;

public class SilverLatticeVineBlock
extends SilverLatticeBlock
implements BonemealableBlock {
    public static final BooleanProperty BERRIES = BlockStateProperties.f_155977_;
    public static final BooleanProperty SPREADABLE = BooleanProperty.m_61465_((String)"spreadable");

    public SilverLatticeVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SPREADABLE, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BERRIES, SPREADABLE});
    }

    public boolean m_6724_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)BERRIES) == false || (Boolean)blockState.m_61143_((Property)SPREADABLE) != false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!((Boolean)blockState.m_61143_((Property)SPREADABLE)).booleanValue()) {
            return;
        }
        if (randomSource.m_188499_()) {
            if (((Boolean)blockState.m_61143_((Property)BERRIES)).booleanValue()) {
                for (Direction direction : Direction.values()) {
                    BlockPos relativePos = blockPos.m_121945_(direction);
                    BlockState relativeState = serverLevel.m_8055_(relativePos);
                    if (!relativeState.m_60713_((Block)GBlocks.SILVER_LATTICE.get())) continue;
                    serverLevel.m_46597_(relativePos, ((Block)GBlocks.GLOW_BERRIES_SILVER_LATTICE.get()).m_152465_(relativeState));
                    break;
                }
            } else {
                BlockState state = (BlockState)blockState.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(true));
                serverLevel.m_46597_(blockPos, state);
                serverLevel.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)state));
            }
        }
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)GBlocks.SILVER_LATTICE.get());
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_204117_(Tags.Items.SHEARS) && ((Boolean)blockState.m_61143_((Property)SPREADABLE)).booleanValue()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, stack);
            }
            level.m_5594_(player, blockPos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)SPREADABLE, (Comparable)Boolean.valueOf(false)));
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(interactionHand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (stack.m_41619_()) {
            BlockState lattice = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)GBlocks.SILVER_LATTICE.get()).m_49966_().m_61124_((Property)f_52309_, (Comparable)((Boolean)blockState.m_61143_((Property)f_52309_)))).m_61124_((Property)f_52310_, (Comparable)((Boolean)blockState.m_61143_((Property)f_52310_)))).m_61124_((Property)f_52311_, (Comparable)((Boolean)blockState.m_61143_((Property)f_52311_)))).m_61124_((Property)f_52312_, (Comparable)((Boolean)blockState.m_61143_((Property)f_52312_)))).m_61124_((Property)f_52313_, (Comparable)((Boolean)blockState.m_61143_((Property)f_52313_)));
            if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_151079_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_151079_), false);
            }
            BlockState newState = (Boolean)blockState.m_61143_((Property)BERRIES) != false ? (BlockState)blockState.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(false)) : lattice;
            level.m_46597_(blockPos, newState);
            level.m_5594_(null, blockPos, SoundEvents.f_144086_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public boolean m_7370_(LevelReader blockGetter, BlockPos blockPos, BlockState blockState, boolean bl) {
        return (Boolean)blockState.m_61143_((Property)BERRIES) == false;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

