/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;

public class MutantArrow
extends Entity {
    private static final EntityDataAccessor<Integer> TARGET_X = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_Y = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_Z = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> CLONES = SynchedEntityData.m_135353_(MutantArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int damage;
    private final List<Entity> pointedEntities;
    private MobEffectInstance effectInstance;
    private LivingEntity shooter;

    public MutantArrow(EntityType<? extends MutantArrow> type, Level world) {
        super(type, world);
        this.damage = 10 + this.f_19796_.m_188503_(3);
        this.pointedEntities = new ArrayList<Entity>();
        this.f_19794_ = true;
    }

    public MutantArrow(Level world, LivingEntity shooter, LivingEntity target) {
        this((EntityType<? extends MutantArrow>)((EntityType)ModRegistry.MUTANT_ARROW_ENTITY_TYPE.get()), world);
        this.shooter = shooter;
        if (!world.f_46443_) {
            this.setTargetX(target.m_20185_());
            this.setTargetY(target.m_20186_());
            this.setTargetZ(target.m_20189_());
        }
        double yPos = shooter.m_20188_();
        if (shooter instanceof MutantSkeleton) {
            yPos = shooter.m_20186_() + 1.28;
        }
        this.m_6034_(shooter.m_20185_(), yPos, shooter.m_20189_());
        double x = this.getTargetX() - this.m_20185_();
        double y = this.getTargetY() - this.m_20186_();
        double z = this.getTargetZ() - this.m_20189_();
        double d = Math.sqrt(x * x + z * z);
        this.m_146922_(180.0f + (float)Math.toDegrees(Math.atan2(x, z)));
        this.m_146926_((float)Math.toDegrees(Math.atan2(y, d)));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_X, (Object)0);
        this.f_19804_.m_135372_(TARGET_Y, (Object)0);
        this.f_19804_.m_135372_(TARGET_Z, (Object)0);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(12.0f));
        this.f_19804_.m_135372_(CLONES, (Object)10);
    }

    public double getTargetX() {
        return (double)((Integer)this.f_19804_.m_135370_(TARGET_X)).intValue() / 10000.0;
    }

    public void setTargetX(double targetX) {
        this.f_19804_.m_135381_(TARGET_X, (Object)((int)(targetX * 10000.0)));
    }

    public double getTargetY() {
        return (double)((Integer)this.f_19804_.m_135370_(TARGET_Y)).intValue() / 10000.0;
    }

    public void setTargetY(double targetY) {
        this.f_19804_.m_135381_(TARGET_Y, (Object)((int)(targetY * 10000.0)));
    }

    public double getTargetZ() {
        return (double)((Integer)this.f_19804_.m_135370_(TARGET_Z)).intValue() / 10000.0;
    }

    public void setTargetZ(double targetZ) {
        this.f_19804_.m_135381_(TARGET_Z, (Object)((int)(targetZ * 10000.0)));
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue() / 10.0f;
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed * 10.0f));
    }

    public int getClones() {
        return (Integer)this.f_19804_.m_135370_(CLONES);
    }

    public void setClones(int clones) {
        this.f_19804_.m_135381_(CLONES, (Object)clones);
    }

    public void randomize(float scale) {
        this.setTargetX(this.getTargetX() + (double)((this.f_19796_.m_188501_() - 0.5f) * scale * 2.0f));
        this.setTargetY(this.getTargetY() + (double)((this.f_19796_.m_188501_() - 0.5f) * scale * 2.0f));
        this.setTargetZ(this.getTargetZ() + (double)((this.f_19796_.m_188501_() - 0.5f) * scale * 2.0f));
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public void setPotionEffect(MobEffectInstance effectInstance) {
        this.effectInstance = effectInstance;
    }

    public void m_8119_() {
        super.m_8119_();
        double x = this.getTargetX() - this.m_20185_();
        double y = this.getTargetY() - this.m_20186_();
        double z = this.getTargetZ() - this.m_20189_();
        double d = Math.sqrt(x * x + z * z);
        this.m_146922_(180.0f + (float)Math.toDegrees(Math.atan2(x, z)));
        if (this.m_146908_() > 360.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
        }
        this.m_146926_((float)Math.toDegrees(Math.atan2(y, d)));
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ == 2) {
                this.hitEntities(0);
            }
            if (this.f_19797_ == 3) {
                this.hitEntities(32);
            }
            if (this.f_19797_ == 4) {
                this.handleEntities();
            }
        }
        if (this.f_19797_ > 10) {
            this.m_146870_();
        }
    }

    protected void hitEntities(int offset) {
        double targetX = this.getTargetX();
        double targetY = this.getTargetY();
        double targetZ = this.getTargetZ();
        double d3 = this.m_20185_() - targetX;
        double d4 = this.m_20186_() - targetY;
        double d5 = this.m_20189_() - targetZ;
        double dist = Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5)));
        double dx = (targetX - this.m_20185_()) / dist;
        double dy = (targetY - this.m_20186_()) / dist;
        double dz = (targetZ - this.m_20189_()) / dist;
        for (int i = offset; i < offset + 200; ++i) {
            double x = this.m_20185_() + dx * (double)i * 0.5;
            double y = this.m_20186_() + dy * (double)i * 0.5;
            double z = this.m_20189_() + dz * (double)i * 0.5;
            AABB box = new AABB(x, y, z, x, y, z).m_82400_(0.3);
            this.pointedEntities.addAll(this.m_9236_().m_6249_((Entity)this.shooter, box, EntitySelector.f_20406_.and(Entity::m_6087_)));
        }
    }

    protected void handleEntities() {
        for (Entity entity : this.pointedEntities) {
            if (!entity.m_6469_(DamageSourcesHelper.source((LevelReader)this.m_9236_(), ModRegistry.MUTANT_ARROW_DAMAGE_TYPE, (Entity)this, (Entity)this.shooter), (float)this.damage)) continue;
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11840_, this.m_5720_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
            if (this.effectInstance == null || !(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).m_7292_(this.effectInstance);
        }
        this.pointedEntities.clear();
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

