/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ToolboxDisposeAllPacket
extends SimplePacketBase {
    private BlockPos toolboxPos;

    public ToolboxDisposeAllPacket(BlockPos toolboxPos) {
        this.toolboxPos = toolboxPos;
    }

    public ToolboxDisposeAllPacket(FriendlyByteBuf buffer) {
        this.toolboxPos = buffer.m_130135_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.toolboxPos);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Level world = player.m_9236_();
            BlockEntity blockEntity = world.m_7702_(this.toolboxPos);
            double maxRange = ToolboxHandler.getMaxRange((Player)player);
            if (player.m_20275_((double)this.toolboxPos.m_123341_() + 0.5, (double)this.toolboxPos.m_123342_(), (double)this.toolboxPos.m_123343_() + 0.5) > maxRange * maxRange) {
                return;
            }
            if (!(blockEntity instanceof ToolboxBlockEntity)) {
                return;
            }
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)blockEntity;
            CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
            MutableBoolean sendData = new MutableBoolean(false);
            toolbox.inventory.inLimitedMode(inventory -> {
                for (int i = 0; i < 36; ++i) {
                    ItemStack itemStack;
                    ItemStack remainder;
                    String key = String.valueOf(i);
                    if (compound.m_128441_(key) && NbtUtils.m_129239_((CompoundTag)compound.m_128469_(key).m_128469_("Pos")).equals((Object)this.toolboxPos)) {
                        ToolboxHandler.unequip((Player)player, i, true);
                        sendData.setTrue();
                    }
                    if ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)toolbox.inventory, (ItemStack)(itemStack = player.m_150109_().m_8020_(i)), (boolean)false)).m_41613_() == itemStack.m_41613_()) continue;
                    player.m_150109_().m_6836_(i, remainder);
                }
            });
            if (sendData.booleanValue()) {
                ToolboxHandler.syncData((Player)player);
            }
        });
        return true;
    }
}

