/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFTextureSizeSupplier;
import traben.entity_model_features.utils.EMFTextureUVSupplier;
import traben.entity_model_features.utils.EMFUtils;

public class EMFOptiFinePartNameMappings {
    public static final Map<String, Map<String, String>> UNKNOWN_MODEL_MAP_CACHE = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> genericMinecart = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left"));
    private static final Map<String, String> genericNonPlayerBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
    private static final Map<String, String> genericIllager = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
    private static final Map<String, String> genericHorse = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("saddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mouth", "upper_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck", "head_parts"), EMFOptiFinePartNameMappings.getOptifineMapEntry("noseband", "mouth_saddle_wrap"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headpiece", "head_saddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_rein", "right_saddle_line"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_rein", "left_saddle_line"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_bit", "right_saddle_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_bit", "left_saddle_mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_back_left_leg", "left_hind_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_back_right_leg", "right_hind_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_front_left_leg", "left_front_baby_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("child_front_right_leg", "right_front_baby_leg"));
    private static final Map<String, String> genericPlayerBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("cloak"));
    private static final Map<String, String> genericPiglinBiped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_sleeve"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_pants"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("cloak"));
    private static final Map<String, String> genericQuadraped = Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
    private static final Map<String, String> genericLlama = new HashMap<String, String>(genericQuadraped){
        {
            this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_left", "left_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_right", "right_chest")));
        }
    };

    public static Map.Entry<String, String> getOptifineMapEntry(String optifineName) {
        return new MutablePair((Object)optifineName, (Object)optifineName);
    }

    public static Map.Entry<String, String> getOptifineMapEntry(String optifineName, String vanillaName) {
        return new MutablePair((Object)optifineName, (Object)vanillaName);
    }

    public static Map<String, String> getMapOf(String mobName, @Nullable ModelPart root) {
        if (mobName.endsWith("_inner_armor") || mobName.endsWith("_outer_armor")) {
            return genericNonPlayerBiped;
        }
        Map<String, String> knownMap = EMFOptiFinePartNameMappings.getKnownMap(mobName);
        if (knownMap == null) {
            return root == null ? Map.of() : EMFOptiFinePartNameMappings.exploreProvidedEntityModelAndExportIfNeeded(root, mobName, null);
        }
        if (EMFConfig.getConfig().modelExportMode.doesAll()) {
            EMFOptiFinePartNameMappings.exploreProvidedEntityModelAndExportIfNeeded(root, mobName, knownMap);
        }
        return knownMap;
    }

    private static Map<String, String> getKnownMap(String mobName) {
        return switch (mobName) {
            case "villager", "wandering_trader" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear2", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bodywear", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "iron_golem" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "spider", "cave_spider" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck", "body0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_middle_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_middle_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg5", "right_middle_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg6", "left_middle_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg7", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg8", "left_front_leg"));
            case "sheep", "cow", "creeper", "creeper_charge", "mooshroom", "panda", "pig", "pig_saddle", "polar_bear", "sheep_wool" -> genericQuadraped;
            case "zombie", "husk", "drowned", "drowned_outer", "enderman", "giant", "skeleton", "stray", "stray_outer", "wither_skeleton", "zombie_pigman" -> genericNonPlayerBiped;
            case "piglin", "piglin_brute", "zombified_piglin" -> genericPiglinBiped;
            case "allay", "vex" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"));
            case "squid", "glow_squid" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle1", "tentacle0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle2", "tentacle1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle3", "tentacle2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle4", "tentacle3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle5", "tentacle4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle6", "tentacle5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle7", "tentacle6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle8", "tentacle7"));
            case "ghast" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle1", "tentacle0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle2", "tentacle1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle3", "tentacle2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle4", "tentacle3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle5", "tentacle4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle6", "tentacle5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle7", "tentacle6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle8", "tentacle7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tentacle9", "tentacle8"));
            case "wolf", "wolf_collar", "wolf_armor" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane", "upper_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
            case "shulker_bullet" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bullet", "main"));
            case "llama_spit" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "main"));
            case "wither_skull", "head_zombie", "head_wither_skeleton", "head_skeleton", "head_player", "head_creeper" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"));
            case "head_piglin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"));
            case "head_dragon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw"));
            case "camel" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hump"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("saddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("reins"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bridle"));
            case "sniffer" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("root"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bone"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("middle_right_leg", "right_mid_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("middle_left_leg", "left_mid_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("lower_beak"));
            case "chest", "ender_chest", "trapped_chest" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob", "lock"));
            case "chest_large" -> {
                EMFUtils.logError("CHEST_LARGE SHOULDN'T HAVE RUN");
                yield Map.of();
            }
            case "double_chest_right", "trapped_double_chest_right", "ender_double_chest_right" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid_left", "lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base_left", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob_left", "lock"));
            case "double_chest_left", "trapped_double_chest_left", "ender_double_chest_left" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid_right", "lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base_right", "bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("knob_right", "lock"));
            case "horse", "horse_armor", "skeleton_horse", "zombie_horse" -> genericHorse;
            case "donkey", "mule" -> new HashMap<String, String>(genericHorse){
                {
                    this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("right_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_chest"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body")));
                }
            };
            case "zombie_villager" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "evoker", "illusioner", "pillager", "vindicator" -> genericIllager;
            case "llama", "llama_decor", "trader_llama", "trader_llama_decor" -> genericLlama;
            case "armor_stand" -> new HashMap<String, String>(genericNonPlayerBiped){
                {
                    this.putAll(Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("right", "right_body_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left", "left_body_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("waist", "shoulder_stick"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base", "base_plate")));
                }
            };
            case "axolotl" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_gills"), EMFOptiFinePartNameMappings.getOptifineMapEntry("top_gills"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_gills"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"));
            case "bat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("outer_right_wing", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("outer_left_wing", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("feet"));
            case "bee" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "bone"), EMFOptiFinePartNameMappings.getOptifineMapEntry("torso", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("middle_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_legs"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stinger"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_antenna"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_antenna"));
            case "blaze" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick1", "part0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick2", "part1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick3", "part2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick4", "part3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick5", "part4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick6", "part5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick7", "part6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick8", "part7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick9", "part8"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick10", "part9"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick11", "part10"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick12", "part11"));
            case "cat", "cat_collar", "ocelot" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"));
            case "chicken" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bill", "beak"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chin", "red_thing"));
            case "cod" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back", "top_fin"));
            case "dolphin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_fin"));
            case "elder_guardian", "guardian" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("tail1", "tail0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2", "tail1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail3", "tail2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine1", "spike0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine2", "spike1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine3", "spike2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine4", "spike3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine5", "spike4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine6", "spike5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine7", "spike6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine8", "spike7"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine9", "spike8"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine10", "spike9"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine11", "spike10"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine12", "spike11"));
            case "endermite" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "segment0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "segment1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "segment2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body4", "segment3"));
            case "evoker_fangs" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("upper_jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("lower_jaw"));
            case "fox" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"));
            case "frog" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("croaking_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tongue"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eyes"));
            case "goat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_horn"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_horn"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "hoglin", "zoglin" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mane"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"));
            case "magma_cube" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("core", "inside_cube"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment1", "cube0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment2", "cube1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment3", "cube2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment4", "cube3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment5", "cube4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment6", "cube5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment7", "cube6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("segment8", "cube7"));
            case "phantom" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "tail_base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail2", "tail_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing", "left_wing_base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing", "right_wing_base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing_tip"));
            case "parrot" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"));
            case "puffer_fish_big" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_top", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_middle_top", "top_middle_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_top", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_right", "right_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_left", "left_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_bottom", "bottom_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_middle_bottom", "bottom_middle_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_bottom", "bottom_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_right", "right_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_left", "left_back_fin"));
            case "puffer_fish_medium" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_blue_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_top", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_top", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_right", "right_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_left", "left_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_front_bottom", "bottom_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_bottom", "bottom_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_right", "right_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spikes_back_left", "left_back_fin"));
            case "puffer_fish_small" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eye_right", "right_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("eye_left", "left_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "back_fin"));
            case "rabbit" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_foot", "left_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_foot", "right_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_thigh", "left_haunch"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_thigh", "right_haunch"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ear"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"));
            case "ravager" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw", "mouth"), EMFOptiFinePartNameMappings.getOptifineMapEntry("neck"));
            case "salmon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body_front"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body_back"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back_1", "top_front_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_back_2", "top_back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail", "back_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"));
            case "shulker" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"));
            case "shulker_box" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base"));
            case "silverfish" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "segment0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "segment1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "segment2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body4", "segment3"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body5", "segment4"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body6", "segment5"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body7", "segment6"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing1", "layer0"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing2", "layer1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("wing3", "layer2"));
            case "slime" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "cube"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_eye"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mouth"));
            case "slime_outer" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "cube"));
            case "snow_golem" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "upper_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body_bottom", "lower_body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_hand", "left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_hand", "right_arm"));
            case "strider", "strider_saddle" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_top", "right_top_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_middle", "right_middle_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_right_bottom", "right_bottom_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_top", "left_top_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_middle", "left_middle_bristle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("hair_left_bottom", "left_bottom_bristle"));
            case "tadpole" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "EMF_root"), EMFOptiFinePartNameMappings.getOptifineMapEntry("EMPTY", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"));
            case "tropical_fish_a", "tropical_fish_pattern_a" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_top", "top_fin"));
            case "tropical_fish_b", "tropical_fish_pattern_b" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_right", "right_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_left", "left_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_top", "top_fin"), EMFOptiFinePartNameMappings.getOptifineMapEntry("fin_bottom", "bottom_fin"));
            case "turtle" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "egg_belly"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "left_front_leg"));
            case "warden" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "bone"), EMFOptiFinePartNameMappings.getOptifineMapEntry("torso", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_arm"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_tendril"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_tendril"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_ribcage"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_ribcage"));
            case "witch" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear", "hat"), EMFOptiFinePartNameMappings.getOptifineMapEntry("headwear2", "hat_rim"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bodywear", "jacket"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("arms"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("nose"), EMFOptiFinePartNameMappings.getOptifineMapEntry("mole"));
            case "wither", "wither_armor" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body1", "shoulders"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body2", "ribcage"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body3", "tail"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head1", "center_head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head2", "right_head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("head3", "left_head"));
            case "dragon" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head"), EMFOptiFinePartNameMappings.getOptifineMapEntry("jaw", "jaw"), EMFOptiFinePartNameMappings.getOptifineMapEntry("spine", "neck"), EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "body"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left_wing_tip", "left_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right_wing_tip", "right_wing_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_leg", "left_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_shin", "left_front_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_left_foot", "left_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_leg", "left_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_shin", "left_hind_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_left_foot", "left_hind_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_leg", "right_front_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_shin", "right_front_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front_right_foot", "right_front_foot"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_leg", "right_hind_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_shin", "right_hind_leg_tip"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back_right_foot", "right_hind_foot"));
            case "player", "player_slim" -> genericPlayerBiped;
            case "boat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_left", "left_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_right", "right_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom_no_water", "water_patch"));
            case "banner" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("slate", "flag"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stand", "pole"), EMFOptiFinePartNameMappings.getOptifineMapEntry("top", "bar"));
            case "bed_head" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("head", "main"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg1", "left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg2", "right_leg"));
            case "bed_foot" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("foot", "main"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg3", "left_leg"), EMFOptiFinePartNameMappings.getOptifineMapEntry("leg4", "right_leg"));
            case "bell" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "bell_body"));
            case "chest_boat" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back"), EMFOptiFinePartNameMappings.getOptifineMapEntry("front"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_left", "left_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_right", "right_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom_no_water", "water_patch"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_base", "chest_bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_knob", "chest_lock"));
            case "raft" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_left", "left_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_right", "right_paddle"));
            case "chest_raft" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_left", "left_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("paddle_right", "right_paddle"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_base", "chest_bottom"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chest_knob", "chest_lock"));
            case "minecart", "chest_minecart", "command_block_minecart", "spawner_minecart", "tnt_minecart", "furnace_minecart", "hopper_minecart" -> genericMinecart;
            case "conduit_cage" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("cage", "shell"));
            case "conduit_eye" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("eye"));
            case "conduit_shell" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("base", "shell"));
            case "conduit_wind" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("wind"));
            case "decorated_pot_base" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("neck"), EMFOptiFinePartNameMappings.getOptifineMapEntry("top"), EMFOptiFinePartNameMappings.getOptifineMapEntry("bottom"));
            case "decorated_pot_sides" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("front"), EMFOptiFinePartNameMappings.getOptifineMapEntry("back"), EMFOptiFinePartNameMappings.getOptifineMapEntry("left"), EMFOptiFinePartNameMappings.getOptifineMapEntry("right"));
            case "book" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("cover_left", "right_lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("cover_right", "left_lid"), EMFOptiFinePartNameMappings.getOptifineMapEntry("pages_left", "right_pages"), EMFOptiFinePartNameMappings.getOptifineMapEntry("pages_right", "left_pages"), EMFOptiFinePartNameMappings.getOptifineMapEntry("flipping_page_right", "flip_page1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("flipping_page_left", "flip_page2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("book_spine", "seam"));
            case "end_crystal" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("cube"), EMFOptiFinePartNameMappings.getOptifineMapEntry("glass"), EMFOptiFinePartNameMappings.getOptifineMapEntry("base"));
            case "hanging_sign" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("board"), EMFOptiFinePartNameMappings.getOptifineMapEntry("plank"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chains", "normalChains"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chain_left1", "chainL1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chain_left2", "chainL2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chain_right1", "chainR1"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chain_right2", "chainR2"), EMFOptiFinePartNameMappings.getOptifineMapEntry("chains_v", "vChains"));
            case "lead_knot" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("knot"));
            case "sign" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("board", "EMF_root"), EMFOptiFinePartNameMappings.getOptifineMapEntry("stick"));
            case "trident" -> Map.ofEntries(EMFOptiFinePartNameMappings.getOptifineMapEntry("body", "EMF_root"));
            default -> null;
        };
    }

    public static Map<String, String> exploreProvidedEntityModelAndExportIfNeeded(ModelPart originalModel, String mobName, @Nullable Map<String, String> mobMap) {
        boolean known;
        if (UNKNOWN_MODEL_MAP_CACHE.containsKey(mobName)) {
            return UNKNOWN_MODEL_MAP_CACHE.get(mobName);
        }
        if (originalModel == null) {
            EMFUtils.logError("model part was null and not already mapped in exploreProvidedEntityModel() EMF");
            return Map.of();
        }
        HashMap<String, String> detailsMap = new HashMap<String, String>();
        boolean bl = known = mobMap != null;
        if (!known) {
            mobMap = new HashMap<String, String>();
            EMFOptiFinePartNameMappings.mapThisAndChildren("root", originalModel, mobMap, detailsMap);
        }
        UNKNOWN_MODEL_MAP_CACHE.put(mobName, mobMap);
        if (EMFConfig.getConfig().modelExportMode != EMFConfig.ModelPrintMode.NONE) {
            StringBuilder mapString = new StringBuilder();
            mapString.append(" |-[optifine/cem/").append(mobName).append(".jem]\n");
            mobMap.forEach((key, entry) -> {
                mapString.append(" | |-[").append("root".equals(key) ? "(optional) " : "").append("part=").append((String)key).append("]\n");
                mapString.append((String)detailsMap.get(key));
            });
            mapString.append("  \\-\\{{end of model}}");
            if (known) {
                EMFUtils.log("OptiFine specified model detected, Mapping now...\n" + mapString);
            } else {
                EMFUtils.log("Unknown possibly modded model detected, Mapping now...\n" + mapString);
            }
            if (EMFConfig.getConfig().modelExportMode.doesJems()) {
                EMFUtils.log("creating example .jem file for " + mobName);
                EMFJemData.EMFJemPrinter jemPrinter = new EMFJemData.EMFJemPrinter();
                int[] textureSize = null;
                for (Map.Entry<String, String> entry2 : mobMap.entrySet()) {
                    if ("root".equals(entry2.getKey())) continue;
                    EMFPartData.EMFPartPrinter partPrinter = new EMFPartData.EMFPartPrinter();
                    partPrinter.part = entry2.getKey();
                    partPrinter.id = entry2.getKey();
                    ModelPart vanillaModelPart = EMFOptiFinePartNameMappings.getChildByName(entry2.getValue(), originalModel);
                    if (vanillaModelPart != null) {
                        partPrinter.translate = new float[]{vanillaModelPart.f_104200_, -24.0f + vanillaModelPart.f_104201_, -vanillaModelPart.f_104202_};
                        partPrinter.scale = vanillaModelPart.f_233553_;
                        partPrinter.textureSize = ((EMFTextureSizeSupplier)vanillaModelPart).emf$getTextureSize();
                        textureSize = partPrinter.textureSize;
                        for (ModelPart.Cube cube : vanillaModelPart.f_104212_) {
                            EMFBoxData.EMFBoxPrinter boxPrinter = new EMFBoxData.EMFBoxPrinter();
                            boxPrinter.coordinates = new float[]{cube.f_104335_, cube.f_104336_, cube.f_104337_, cube.f_104338_ - cube.f_104335_, cube.f_104339_ - cube.f_104336_, cube.f_104340_ - cube.f_104337_};
                            boxPrinter.textureOffset = ((EMFTextureUVSupplier)cube).emf$getTextureUV();
                            boxPrinter.coordinates[0] = -boxPrinter.coordinates[0] - boxPrinter.coordinates[3] - partPrinter.translate[0];
                            boxPrinter.coordinates[1] = -boxPrinter.coordinates[1] - boxPrinter.coordinates[4] - partPrinter.translate[1];
                            boxPrinter.coordinates[2] = boxPrinter.coordinates[2] - partPrinter.translate[2];
                            partPrinter.boxes = Arrays.copyOf(partPrinter.boxes, partPrinter.boxes.length + 1);
                            partPrinter.boxes[partPrinter.boxes.length - 1] = boxPrinter;
                        }
                    }
                    jemPrinter.models.add(partPrinter);
                }
                if (textureSize == null) {
                    textureSize = new int[]{64, 32};
                }
                jemPrinter.textureSize = textureSize;
                String path = EMFVersionDifferenceManager.getConfigDirectory().toFile().getParent() + "/emf/export/" + mobName + ".jem";
                File outFile = new File(path);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                try {
                    FileWriter fileWriter = new FileWriter(outFile);
                    fileWriter.write(gson.toJson((Object)jemPrinter));
                    fileWriter.close();
                    EMFUtils.log(".jem file creation succeeded for [" + path + "]");
                }
                catch (IOException e) {
                    EMFUtils.log(".jem file creation failed for [" + path + "]");
                }
            }
        }
        return mobMap;
    }

    private static ModelPart getChildByName(String name, ModelPart part) {
        if (part.m_233562_(name)) {
            return part.m_171324_(name);
        }
        for (ModelPart childPart : part.f_104213_.values()) {
            ModelPart possibleReturn = EMFOptiFinePartNameMappings.getChildByName(name, childPart);
            if (possibleReturn == null) continue;
            return possibleReturn;
        }
        return null;
    }

    private static void mapThisAndChildren(String partName, ModelPart originalModel, Map<String, String> newMap, Map<String, String> detailsMap) {
        for (Map.Entry entry : originalModel.f_104213_.entrySet()) {
            EMFOptiFinePartNameMappings.mapThisAndChildren((String)entry.getKey(), (ModelPart)entry.getValue(), newMap, detailsMap);
        }
        newMap.put(partName, partName);
        if (EMFConfig.getConfig().modelExportMode != EMFConfig.ModelPrintMode.NONE) {
            detailsMap.put(partName, " | | |-pivots=" + originalModel.f_104200_ + ", " + originalModel.f_104201_ + ", " + originalModel.f_104202_ + "\n | | |-rotations=" + Math.toDegrees(originalModel.f_104203_) + ", " + Math.toDegrees(originalModel.f_104204_) + ", " + Math.toDegrees(originalModel.f_104205_) + "\n | | |-scales=" + originalModel.f_233553_ + ", " + originalModel.f_233554_ + ", " + originalModel.f_233555_ + "\n | |  \\visibles=" + originalModel.f_104207_ + ", " + originalModel.f_233556_ + "\n");
        }
    }
}

