/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mod_compat.EBEConfigModifier;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.models.EMFModelPartVanilla;
import traben.entity_model_features.models.IEMFModelNameContainer;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;

public class EMFManager {
    private static final Map<BlockEntityType<?>, String> EBETypes = Map.of(BlockEntityType.f_58940_, "bed", BlockEntityType.f_58918_, "chest", BlockEntityType.f_58919_, "chest", BlockEntityType.f_58920_, "chest", BlockEntityType.f_58939_, "shulker_box", BlockEntityType.f_58909_, "bell", BlockEntityType.f_58924_, "sign", BlockEntityType.f_271291_, "decorated_pot");
    public static EMFModelPartRoot lastCreatedRootModelPart = null;
    private static EMFManager self = null;
    public final boolean IS_PHYSICS_MOD_INSTALLED;
    public final boolean IS_EBE_INSTALLED;
    public final Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>> rootPartsPerEntityTypeForDebug = new Object2ObjectLinkedOpenHashMap<String, Set<EMFModelPartRoot>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    public final ObjectSet<OptifineMobNameForFileAndEMFMapId> modelsAnnounced = new ObjectOpenHashSet();
    private final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<ModelLayerLocation> amountOfLayerAttempts = new Object2IntOpenHashMap<ModelLayerLocation>(){
        {
            this.defaultReturnValue(0);
        }
    };
    private final Set<String> EBE_JEMS_FOUND = new HashSet<String>();
    public UUID entityForDebugPrint = null;
    public long entityRenderCount = 0L;
    public boolean isAnimationValidationPhase = false;
    public String currentSpecifiedModelLoading = "";
    public BlockEntityType<?> currentBlockEntityTypeLoading = null;
    public final Object2ObjectLinkedOpenHashMap<String, Set<Runnable>> rootPartsPerEntityTypeForVariation = new Object2ObjectLinkedOpenHashMap<String, Set<Runnable>>(){
        {
            this.defaultReturnValue(null);
        }
    };
    private boolean traderLlamaHappened = false;

    private EMFManager() {
        EMFAnimationEntityContext.reset();
        this.IS_PHYSICS_MOD_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("physicsmod");
        this.IS_EBE_INSTALLED = EMFVersionDifferenceManager.isThisModLoaded("enhancedblockentities");
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.log("[EMF (Entity Model Features)]: Clearing data for reload.", false, true);
        EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    @Nullable
    public static EMFJemData getJemData(String jemFileName, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        EMFJemData emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + jemFileName, mobModelIDInfo);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + mobModelIDInfo + "/" + jemFileName, mobModelIDInfo);
        return emfJemData;
    }

    @Nullable
    public static CemDirectoryApplier getResourceCemDirectoryApplierOrNull(String inCemPathResource, String rawMobName) {
        ResourceManager resources = Minecraft.m_91087_().m_91098_();
        if (resources.m_213713_(new ResourceLocation("emf/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF();
        }
        if (resources.m_213713_(new ResourceLocation("emf/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getEMF_Mob(rawMobName);
        }
        if (resources.m_213713_(new ResourceLocation("optifine/cem/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCEM();
        }
        if (resources.m_213713_(new ResourceLocation("optifine/cem/" + rawMobName + "/" + inCemPathResource)).isPresent()) {
            return CemDirectoryApplier.getCem_Mob(rawMobName);
        }
        return null;
    }

    @Nullable
    public static EMFJemData getJemDataWithDirectory(String pathOfJem, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        try {
            Optional res = Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(pathOfJem));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().logModelCreationData) {
                    EMFUtils.log(".jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.log(".jem read success " + pathOfJem + " exists", false);
            }
            Resource jemResource = (Resource)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.m_215507_()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.prepare(pathOfJem, mobModelIDInfo);
            if (mobModelIDInfo.areBothSame()) {
                EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            }
            return jem;
        }
        catch (FileNotFoundException | ResourceLocationException e) {
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.log(".jem failed to load " + (Exception)e, false);
            }
        }
        catch (Exception e) {
            EMFUtils.log(".jem failed to load " + e, false);
        }
        return null;
    }

    public static EMFModelPart getModelFromHierarchichalId(String hierarchId, Map<String, EMFModelPart> map) {
        if (hierarchId == null || hierarchId.isBlank()) {
            return null;
        }
        if (!hierarchId.contains(":")) {
            EMFModelPart part = map.get(hierarchId);
            if (part == null) {
                return map.get("EMF_" + hierarchId);
            }
            return part;
        }
        for (Map.Entry<String, EMFModelPart> entry : map.entrySet()) {
            if (entry.getKey().equals(hierarchId) || entry.getKey().equals("EMF_" + hierarchId) || entry.getKey().endsWith(":" + hierarchId) || entry.getKey().endsWith(":EMF_" + hierarchId)) {
                return entry.getValue();
            }
            boolean anyMissing = false;
            String last = "";
            String[] stringArray = hierarchId.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String str;
                last = str = stringArray[i];
                if (entry.getKey().contains(str) || entry.getKey().contains("EMF_" + str)) continue;
                anyMissing = true;
                break;
            }
            if (anyMissing || !entry.getKey().endsWith(last)) continue;
            return entry.getValue();
        }
        EMFUtils.logWarn("NULL animation hierachy id result of: " + hierarchId + "\n in " + map);
        return null;
    }

    public void modifyEBEIfRequired() {
        if (this.IS_EBE_INSTALLED && !this.EBE_JEMS_FOUND.isEmpty() && EMFConfig.getConfig().allowEBEModConfigModify) {
            try {
                EBEConfigModifier.modifyEBEConfig(this.EBE_JEMS_FOUND);
            }
            catch (Error | Exception e) {
                EMFUtils.logWarn("EBE config modification issue: " + e);
            }
        }
        this.EBE_JEMS_FOUND.clear();
    }

    public ModelPart injectIntoModelRootGetter(ModelLayerLocation layer, ModelPart root) {
        int creationsOfLayer = this.amountOfLayerAttempts.put((Object)layer, this.amountOfLayerAttempts.getInt((Object)layer) + 1);
        if (creationsOfLayer > 500) {
            if (creationsOfLayer == 501) {
                EMFUtils.logWarn("model attempted creation more than 500 times {" + layer.toString() + "]. EMF is now ignoring this model.");
            }
            return root;
        }
        Object originalLayerName = layer.m_171123_().m_135815_();
        OptifineMobNameForFileAndEMFMapId mobNameForFileAndMap = new OptifineMobNameForFileAndEMFMapId((String)(this.currentSpecifiedModelLoading.isBlank() ? originalLayerName : this.currentSpecifiedModelLoading));
        try {
            EMFJemData jemData;
            lastCreatedRootModelPart = null;
            boolean printing = EMFConfig.getConfig().logModelCreationData;
            if (!"main".equals(layer.m_171124_())) {
                mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName() + "_" + layer.m_171124_());
                originalLayerName = (String)originalLayerName + "_" + layer.m_171124_();
            }
            if (!"minecraft".equals(layer.m_171123_().m_135827_())) {
                mobNameForFileAndMap.setBoth(("modded/" + layer.m_171123_().m_135827_() + "/" + (String)originalLayerName).toLowerCase().replaceAll("[^a-z0-9/._-]", "_"));
            } else {
                if (mobNameForFileAndMap.getfileName().contains("pufferfish")) {
                    mobNameForFileAndMap.setBoth(mobNameForFileAndMap.getfileName().replace("pufferfish", "puffer_fish"));
                }
                block34 : switch (originalLayerName) {
                    case "tropical_fish_large": {
                        mobNameForFileAndMap.setBoth("tropical_fish_b");
                        break;
                    }
                    case "tropical_fish_small": {
                        mobNameForFileAndMap.setBoth("tropical_fish_a");
                        break;
                    }
                    case "tropical_fish_large_pattern": {
                        mobNameForFileAndMap.setBoth("tropical_fish_pattern_b");
                        break;
                    }
                    case "tropical_fish_small_pattern": {
                        mobNameForFileAndMap.setBoth("tropical_fish_pattern_a");
                        break;
                    }
                    case "leash_knot": {
                        mobNameForFileAndMap.setBoth("lead_knot");
                        break;
                    }
                    case "trader_llama": {
                        this.traderLlamaHappened = true;
                        break;
                    }
                    case "llama": {
                        this.traderLlamaHappened = false;
                        break;
                    }
                    case "llama_decor": {
                        mobNameForFileAndMap.setBoth(this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor");
                        break;
                    }
                    case "ender_dragon": {
                        mobNameForFileAndMap.setBoth("dragon");
                        break;
                    }
                    case "dragon_skull": {
                        mobNameForFileAndMap.setBoth("head_dragon");
                        break;
                    }
                    case "player_head": {
                        mobNameForFileAndMap.setBoth("head_player");
                        break;
                    }
                    case "skeleton_skull": {
                        mobNameForFileAndMap.setBoth("head_skeleton");
                        break;
                    }
                    case "wither_skeleton_skull": {
                        mobNameForFileAndMap.setBoth("head_wither_skeleton");
                        break;
                    }
                    case "zombie_head": {
                        mobNameForFileAndMap.setBoth("head_zombie");
                        break;
                    }
                    case "creeper_head": {
                        mobNameForFileAndMap.setBoth("head_creeper");
                        break;
                    }
                    case "piglin_head": {
                        mobNameForFileAndMap.setBoth("head_piglin");
                        break;
                    }
                    case "creeper_armor": {
                        mobNameForFileAndMap.setBoth("creeper_charge");
                        break;
                    }
                    case "sheep_fur": {
                        mobNameForFileAndMap.setBoth("sheep_wool");
                        break;
                    }
                    case "bed_head": {
                        mobNameForFileAndMap.setBoth("bed", "bed_head");
                        break;
                    }
                    case "bed_foot": {
                        mobNameForFileAndMap.setBoth("bed", "bed_foot");
                        break;
                    }
                    case "conduit_cage": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_cage");
                        break;
                    }
                    case "conduit_eye": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_eye");
                        break;
                    }
                    case "conduit_shell": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_shell");
                        break;
                    }
                    case "conduit_wind": {
                        mobNameForFileAndMap.setBoth("conduit", "conduit_wind");
                        break;
                    }
                    case "decorated_pot_base": {
                        mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_base");
                        break;
                    }
                    case "decorated_pot_sides": {
                        mobNameForFileAndMap.setBoth("decorated_pot", "decorated_pot_sides");
                        break;
                    }
                    case "book": {
                        if (this.currentSpecifiedModelLoading.equals("enchanting_book")) {
                            mobNameForFileAndMap.setBoth("enchanting_book", "book");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("lectern_book", "book");
                        break;
                    }
                    case "chest": {
                        mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading, "chest");
                        break;
                    }
                    case "double_chest_left": {
                        mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading + "_large", "double_chest_left");
                        break;
                    }
                    case "double_chest_right": {
                        mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading + "_large", "double_chest_right");
                        break;
                    }
                    case "shulker": {
                        if (this.currentSpecifiedModelLoading.equals("shulker_box")) {
                            mobNameForFileAndMap.setBoth("shulker_box");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("shulker");
                        break;
                    }
                    default: {
                        if (!this.currentSpecifiedModelLoading.isBlank()) {
                            switch (this.currentSpecifiedModelLoading) {
                                case "sign": 
                                case "hanging_sign": {
                                    mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading);
                                    break block34;
                                }
                            }
                            if (EMFConfig.getConfig().modelExportMode != EMFConfig.ModelPrintMode.NONE) {
                                EMFUtils.log("EMF unknown modifiable block entity model identified during loading: " + this.currentSpecifiedModelLoading + ".jem");
                            }
                            mobNameForFileAndMap.setBoth(this.currentSpecifiedModelLoading);
                            break;
                        }
                        if (!((String)originalLayerName).contains("/") || !layer.m_171124_().equals("main")) break;
                        if (((String)originalLayerName).startsWith("chest_boat/")) {
                            if (((String)originalLayerName).startsWith("chest_boat/bamboo")) {
                                mobNameForFileAndMap.setBoth("chest_raft");
                                break;
                            }
                            mobNameForFileAndMap.setBoth("chest_boat");
                            break;
                        }
                        if (!((String)originalLayerName).startsWith("boat/")) break;
                        if (((String)originalLayerName).startsWith("boat/bamboo")) {
                            mobNameForFileAndMap.setBoth("raft");
                            break;
                        }
                        mobNameForFileAndMap.setBoth("boat");
                    }
                }
            }
            if (EMFConfig.getConfig().modelExportMode != EMFConfig.ModelPrintMode.NONE && !this.currentSpecifiedModelLoading.isBlank() && this.currentSpecifiedModelLoading.startsWith("modded/")) {
                EMFUtils.log("EMF modifiable modded block entity model identified during loading: " + mobNameForFileAndMap.getfileName() + ".jem");
            }
            if (!EMFManager.isIdentifierPathValid(mobNameForFileAndMap.getfileName() + ".jem")) {
                String newValidPath = mobNameForFileAndMap.getfileName().replaceAll("[^a-z0-9/_.-]", "_");
                mobNameForFileAndMap.setBoth(newValidPath, mobNameForFileAndMap.getMapId());
            }
            if (printing) {
                EMFUtils.log(" > EMF try to find a model for: " + mobNameForFileAndMap);
            }
            Map<String, String> optifinePartNameMap = EMFOptiFinePartNameMappings.getMapOf(mobNameForFileAndMap.getMapId(), root);
            if (printing) {
                EMFUtils.log(" >> EMF trying to find: optifine/cem/" + mobNameForFileAndMap + ".jem");
            }
            String jemName = mobNameForFileAndMap + ".jem";
            CemDirectoryApplier hasVariantsAndCanApplyThisDirectory = EMFManager.getResourceCemDirectoryApplierOrNull(mobNameForFileAndMap + ".properties", mobNameForFileAndMap.getfileName());
            if (hasVariantsAndCanApplyThisDirectory == null) {
                hasVariantsAndCanApplyThisDirectory = EMFManager.getResourceCemDirectoryApplierOrNull(mobNameForFileAndMap + "2.jem", mobNameForFileAndMap.getfileName());
            }
            if ((jemData = EMFManager.getJemData(jemName, mobNameForFileAndMap)) != null || hasVariantsAndCanApplyThisDirectory != null) {
                HashSet<String> optifinePartNames = new HashSet<String>();
                optifinePartNameMap.forEach((optifine, vanilla) -> {
                    if (!optifine.equals("EMPTY")) {
                        optifinePartNames.add((String)vanilla);
                    }
                });
                EMFModelPartRoot emfRoot = new EMFModelPartRoot(mobNameForFileAndMap, hasVariantsAndCanApplyThisDirectory, root, optifinePartNames, new HashMap<String, EMFModelPartVanilla>());
                if (jemData != null) {
                    emfRoot.addVariantOfJem(jemData, 1);
                    emfRoot.setVariantStateTo(1);
                    this.setupAnimationsFromJemToModel(jemData, emfRoot, 1);
                    emfRoot.containsCustomModel = true;
                    if (hasVariantsAndCanApplyThisDirectory != null) {
                        emfRoot.discoverAndInitVariants();
                    }
                } else {
                    emfRoot.setVariant1ToVanilla0();
                    emfRoot.discoverAndInitVariants();
                }
                if (emfRoot.containsCustomModel) {
                    lastCreatedRootModelPart = emfRoot;
                    if (this.IS_EBE_INSTALLED && this.currentBlockEntityTypeLoading != null && EBETypes.containsKey(this.currentBlockEntityTypeLoading)) {
                        this.EBE_JEMS_FOUND.add(EBETypes.get(this.currentBlockEntityTypeLoading));
                    }
                    return emfRoot;
                }
            }
            if (printing) {
                EMFUtils.logWarn(" > Vanilla model used for: " + mobNameForFileAndMap);
            }
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            return root;
        }
        catch (Exception e) {
            EMFUtils.logWarn("default model returned for " + layer + " due to exception: " + e);
            ((IEMFModelNameContainer)root).emf$insertKnownMappings(mobNameForFileAndMap);
            return root;
        }
    }

    private static boolean isIdentifierPathValid(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (ResourceLocation.m_135828_((char)path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartRoot emfRootPart, int variantNum) {
        boolean printing = EMFConfig.getConfig().logModelCreationData;
        Object2ObjectOpenHashMap allPartsBySingleAndFullHeirachicalId = new Object2ObjectOpenHashMap();
        allPartsBySingleAndFullHeirachicalId.put((Object)"EMF_root", (Object)emfRootPart);
        allPartsBySingleAndFullHeirachicalId.putAll(emfRootPart.getAllChildPartsAsAnimationMap("", variantNum, EMFOptiFinePartNameMappings.getMapOf(emfRootPart.modelName.getMapId(), null)));
        Object2ObjectLinkedOpenHashMap emfAnimations = new Object2ObjectLinkedOpenHashMap();
        if (printing) {
            EMFUtils.log(" > finalAnimationsForModel =");
            jemData.getAllTopLevelAnimationsByVanillaPartName().forEach((part, anims) -> anims.forEach((key, expression) -> EMFUtils.log(" >> " + key + " = " + expression)));
        }
        jemData.getAllTopLevelAnimationsByVanillaPartName().forEach((part, anims) -> anims.forEach((animKey, animationExpression) -> {
            if (EMFConfig.getConfig().logModelCreationData) {
                EMFUtils.log("parsing animation value: [" + animKey + "]");
            }
            String modelId = animKey.split("\\.")[0];
            String modelVariable = animKey.split("\\.")[1];
            EMFModelOrRenderVariable thisVariable = EMFModelOrRenderVariable.get(modelVariable);
            if (thisVariable == null) {
                thisVariable = EMFModelOrRenderVariable.getRenderVariable(animKey);
            }
            EMFModelPart thisPart = "render".equals(modelId) ? null : EMFManager.getModelFromHierarchichalId(modelId, (Map<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
            EMFAnimation newAnimation = new EMFAnimation(thisPart, thisVariable, (String)animKey, (String)animationExpression, jemData.getFileName());
            if (emfAnimations.containsKey(animKey) && ((EMFAnimation)emfAnimations.get((Object)animKey)).isVariable) {
                emfAnimations.put((Object)(animKey + "#" + System.currentTimeMillis()), (Object)newAnimation);
                newAnimation.setTrueVariableSource((EMFAnimation)emfAnimations.get(animKey));
            } else {
                emfAnimations.put(animKey, (Object)newAnimation);
            }
        }));
        this.isAnimationValidationPhase = true;
        ObjectIterator animMapIterate = emfAnimations.values().iterator();
        while (animMapIterate.hasNext()) {
            EMFAnimation anim = (EMFAnimation)animMapIterate.next();
            if (anim != null) {
                anim.initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)emfAnimations, (Object2ObjectOpenHashMap<String, EMFModelPart>)allPartsBySingleAndFullHeirachicalId);
                if (anim.isValid()) continue;
                EMFUtils.logWarn("animation was invalid: " + anim.animKey + " = " + anim.expressionString);
                animMapIterate.remove();
                continue;
            }
            animMapIterate.remove();
        }
        this.isAnimationValidationPhase = false;
        emfRootPart.receiveAnimations(variantNum, (Collection<EMFAnimation>)emfAnimations.values());
    }

    public static interface CemDirectoryApplier {
        public static CemDirectoryApplier getEMF() {
            return fileName -> "emf/cem/" + fileName;
        }

        public static CemDirectoryApplier getEMF_Mob(String mobname) {
            return fileName -> "emf/cem/" + mobname + "/" + fileName;
        }

        public static CemDirectoryApplier getCEM() {
            return fileName -> "optifine/cem/" + fileName;
        }

        public static CemDirectoryApplier getCem_Mob(String mobName) {
            return fileName -> "optifine/cem/" + mobName + "/" + fileName;
        }

        public String getThisDirectoryOfFilename(String var1);
    }
}

