/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.variables.factories;

import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.variables.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFManager;

public class ModelPartVariableFactory
extends UniqueVariableFactory {
    @Override
    public MathValue.ResultSupplier getSupplierOrNull(String variableKey, EMFAnimation calculationInstance) {
        String[] split = variableKey.split("\\.");
        String partName = split[0];
        EMFModelOrRenderVariable partVariable = EMFModelOrRenderVariable.get(split[1]);
        EMFModelPart part = EMFManager.getModelFromHierarchichalId(partName, calculationInstance.allPartsBySingleAndFullHeirachicalId);
        if (partVariable != null && part != null) {
            return () -> partVariable.getValue(part);
        }
        if (calculationInstance.modelName.endsWith("chest_large.jem") && (partName.endsWith("_left") || partName.endsWith("_right"))) {
            return MathConstant.ZERO.getResultSupplier();
        }
        return null;
    }

    @Override
    public boolean createsThisVariable(String variableKey) {
        if (variableKey == null) {
            return false;
        }
        return variableKey.matches("[a-zA-Z0-9_]+\\.([trs][xyz]$|visible$|visible_boxes$)");
    }
}

