/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathConstant;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.models.animation.math.MathVariable;
import traben.entity_model_features.models.animation.math.variables.factories.ModelPartVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.ModelVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.RenderVariableFactory;
import traben.entity_model_features.models.animation.math.variables.factories.UniqueVariableFactory;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFUtils;

public final class VariableRegistry {
    private static final VariableRegistry INSTANCE = new VariableRegistry();
    private final Map<String, MathComponent> singletonVariables = new HashMap<String, MathComponent>();
    private final List<UniqueVariableFactory> uniqueVariableFactories = new ArrayList<UniqueVariableFactory>();

    private VariableRegistry() {
        this.singletonVariables.put("pi", new MathConstant((float)Math.PI));
        this.singletonVariables.put("-pi", new MathConstant((float)(-Math.PI)));
        this.singletonVariables.put("e", new MathConstant((float)Math.E));
        this.singletonVariables.put("-e", new MathConstant(-2.7182817f));
        this.singletonVariables.put("true", MathConstant.ONE);
        this.singletonVariables.put("!true", MathConstant.ZERO);
        this.singletonVariables.put("false", MathConstant.ZERO);
        this.singletonVariables.put("!false", MathConstant.ONE);
        this.registerSimpleFloatVariable("limb_swing", EMFAnimationEntityContext::getLimbAngle);
        this.registerSimpleFloatVariable("frame_time", EMFAnimationEntityContext::getFrameTime);
        this.registerSimpleFloatVariable("limb_speed", EMFAnimationEntityContext::getLimbDistance);
        this.registerSimpleFloatVariable("age", EMFAnimationEntityContext::getAge);
        this.registerSimpleFloatVariable("head_pitch", EMFAnimationEntityContext::getHeadPitch);
        this.registerSimpleFloatVariable("head_yaw", EMFAnimationEntityContext::getHeadYaw);
        this.registerSimpleFloatVariable("swing_progress", EMFAnimationEntityContext::getSwingProgress);
        this.registerSimpleFloatVariable("hurt_time", EMFAnimationEntityContext::getHurtTime);
        this.registerSimpleFloatVariable("dimension", EMFAnimationEntityContext::getDimension);
        this.registerSimpleFloatVariable("time", EMFAnimationEntityContext::getTime);
        this.registerSimpleFloatVariable("player_pos_x", EMFAnimationEntityContext::getPlayerX);
        this.registerSimpleFloatVariable("player_pos_y", EMFAnimationEntityContext::getPlayerY);
        this.registerSimpleFloatVariable("player_pos_z", EMFAnimationEntityContext::getPlayerZ);
        this.registerSimpleFloatVariable("pos_x", EMFAnimationEntityContext::getEntityX);
        this.registerSimpleFloatVariable("pos_y", EMFAnimationEntityContext::getEntityY);
        this.registerSimpleFloatVariable("pos_z", EMFAnimationEntityContext::getEntityZ);
        this.registerSimpleFloatVariable("player_rot_x", EMFAnimationEntityContext::getPlayerRX);
        this.registerSimpleFloatVariable("player_rot_y", EMFAnimationEntityContext::getPlayerRY);
        this.registerSimpleFloatVariable("rot_x", EMFAnimationEntityContext::getEntityRX);
        this.registerSimpleFloatVariable("rot_y", EMFAnimationEntityContext::getEntityRY);
        this.registerSimpleFloatVariable("health", EMFAnimationEntityContext::getHealth);
        this.registerSimpleFloatVariable("death_time", EMFAnimationEntityContext::getDeathTime);
        this.registerSimpleFloatVariable("anger_time", EMFAnimationEntityContext::getAngerTime);
        this.registerSimpleFloatVariable("max_health", EMFAnimationEntityContext::getMaxHealth);
        this.registerSimpleFloatVariable("id", EMFAnimationEntityContext::getId);
        this.registerSimpleFloatVariable("day_time", EMFAnimationEntityContext::getDayTime);
        this.registerSimpleFloatVariable("day_count", EMFAnimationEntityContext::getDayCount);
        this.registerSimpleFloatVariable("rule_index", EMFAnimationEntityContext::getRuleIndex);
        this.registerSimpleFloatVariable("anger_time_start", EMFAnimationEntityContext::getAngerTimeStart);
        this.registerSimpleFloatVariable("move_forward", EMFAnimationEntityContext::getMoveForward);
        this.registerSimpleFloatVariable("move_strafing", EMFAnimationEntityContext::getMoveStrafe);
        this.registerSimpleFloatVariable("nan", () -> EMFManager.getInstance().isAnimationValidationPhase ? 0.0f : Float.NaN);
        this.registerSimpleBoolVariable("is_climbing", EMFAnimationEntityContext::isClimbing);
        this.registerSimpleBoolVariable("is_child", EMFAnimationEntityContext::isChild);
        this.registerSimpleBoolVariable("is_in_water", EMFAnimationEntityContext::isInWater);
        this.registerSimpleBoolVariable("is_riding", EMFAnimationEntityContext::isRiding);
        this.registerSimpleBoolVariable("is_on_ground", EMFAnimationEntityContext::isOnGround);
        this.registerSimpleBoolVariable("is_burning", EMFAnimationEntityContext::isBurning);
        this.registerSimpleBoolVariable("is_alive", EMFAnimationEntityContext::isAlive);
        this.registerSimpleBoolVariable("is_glowing", EMFAnimationEntityContext::isGlowing);
        this.registerSimpleBoolVariable("is_aggressive", EMFAnimationEntityContext::isAggressive);
        this.registerSimpleBoolVariable("is_hurt", EMFAnimationEntityContext::isHurt);
        this.registerSimpleBoolVariable("is_in_hand", EMFAnimationEntityContext::isInHand);
        this.registerSimpleBoolVariable("is_in_item_frame", EMFAnimationEntityContext::isInItemFrame);
        this.registerSimpleBoolVariable("is_in_ground", EMFAnimationEntityContext::isInGround);
        this.registerSimpleBoolVariable("is_in_gui", EMFAnimationEntityContext::isInGui);
        this.registerSimpleBoolVariable("is_in_lava", EMFAnimationEntityContext::isInLava);
        this.registerSimpleBoolVariable("is_invisible", EMFAnimationEntityContext::isInvisible);
        this.registerSimpleBoolVariable("is_on_head", EMFAnimationEntityContext::isOnHead);
        this.registerSimpleBoolVariable("is_on_shoulder", EMFAnimationEntityContext::isOnShoulder);
        this.registerSimpleBoolVariable("is_ridden", EMFAnimationEntityContext::isRidden);
        this.registerSimpleBoolVariable("is_sitting", EMFAnimationEntityContext::isSitting);
        this.registerSimpleBoolVariable("is_sneaking", EMFAnimationEntityContext::isSneaking);
        this.registerSimpleBoolVariable("is_sprinting", EMFAnimationEntityContext::isSprinting);
        this.registerSimpleBoolVariable("is_tamed", EMFAnimationEntityContext::isTamed);
        this.registerSimpleBoolVariable("is_wet", EMFAnimationEntityContext::isWet);
        this.registerContextVariable(new ModelPartVariableFactory());
        this.registerContextVariable(new ModelVariableFactory());
        this.registerContextVariable(new RenderVariableFactory());
    }

    public static VariableRegistry getInstance() {
        return INSTANCE;
    }

    public void registerContextVariable(UniqueVariableFactory factory) {
        if (factory == null) {
            EMFUtils.logWarn("Tried to register a null context variable factory");
            return;
        }
        if (this.uniqueVariableFactories.contains(factory)) {
            EMFUtils.logWarn("Tried to register a duplicate context variable factory: " + factory.getClass().getName());
            return;
        }
        this.uniqueVariableFactories.add(factory);
    }

    public void registerSimpleFloatVariable(String variableName, MathValue.ResultSupplier supplier) {
        if (this.singletonVariables.containsKey(variableName)) {
            EMFUtils.log("Duplicate variable: " + variableName + ". ignoring duplicate");
            return;
        }
        this.singletonVariables.put(variableName, new MathVariable(variableName, false, supplier));
        this.singletonVariables.put("-" + variableName, new MathVariable("-" + variableName, true, supplier));
    }

    public void registerSimpleBoolVariable(String variableName, BooleanSupplier boolGetter) {
        if (this.singletonVariables.containsKey(variableName)) {
            EMFUtils.log("Duplicate variable: " + variableName + ". ignoring duplicate");
            return;
        }
        this.singletonVariables.put(variableName, new MathVariable(variableName, () -> boolGetter.getAsBoolean() ? 1.0f : 0.0f));
        this.singletonVariables.put("!" + variableName, new MathVariable("!" + variableName, () -> boolGetter.getAsBoolean() ? 0.0f : 1.0f));
    }

    public MathComponent getVariable(String variableName, boolean isNegative, EMFAnimation calculationInstance) {
        try {
            Object variableKey;
            Object object = variableKey = isNegative ? "-" + variableName : variableName;
            if (this.singletonVariables.containsKey(variableKey)) {
                return this.singletonVariables.get(variableKey);
            }
            boolean invertBooleans = variableName.startsWith("!");
            for (UniqueVariableFactory uniqueVariableFactory : this.uniqueVariableFactories) {
                MathValue.ResultSupplier supplier;
                if (!uniqueVariableFactory.createsThisVariable(invertBooleans ? variableName.substring(1) : variableName) || (supplier = uniqueVariableFactory.getSupplierOrNull(variableName, calculationInstance)) == null) continue;
                return new MathVariable(variableName, isNegative, invertBooleans ? () -> supplier.get() == 1.0f ? 0.0f : 1.0f : supplier);
            }
            EMFUtils.logWarn("Variable [" + variableName + "] not found in animation [" + calculationInstance.animKey + "] of model [" + calculationInstance.modelName + "]. EMF will treat the variable as zero.");
        }
        catch (Exception e) {
            EMFUtils.logWarn("Error finding variable: [" + variableName + "] in animation [" + calculationInstance.animKey + "] of model [" + calculationInstance.modelName + "]. EMF will treat the variable as zero.");
        }
        return MathConstant.ZERO;
    }
}

