/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.optifine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.Tuple;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;

public class IfMethod
extends MathMethod {
    public IfMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = IfMethod.parseAllArgs(args, calculationInstance);
        if (parsedArgs.size() == 3) {
            MathComponent bool = parsedArgs.get(0);
            MathComponent tru = parsedArgs.get(1);
            MathComponent fals = parsedArgs.get(2);
            if (bool.isConstant()) {
                this.setOptimizedAlternativeToThis(bool.getResult() == 1.0f ? tru : fals);
            }
            this.setSupplierAndOptimize(() -> {
                float condition = bool.getResult();
                if (condition == 1.0f) {
                    return tru.getResult();
                }
                return fals.getResult();
            }, parsedArgs);
        } else {
            ArrayList<Tuple> ifSets = new ArrayList<Tuple>();
            MathComponent lastElse = parsedArgs.get(parsedArgs.size() - 1);
            Iterator<MathComponent> iterator = parsedArgs.iterator();
            while (iterator.hasNext()) {
                MathComponent next = iterator.next();
                if (!iterator.hasNext()) continue;
                if (!next.isConstant()) {
                    ifSets.add(new Tuple((Object)next, (Object)iterator.next()));
                    continue;
                }
                if (next.getResult() != 1.0f) continue;
                lastElse = iterator.next();
                break;
            }
            if (ifSets.isEmpty()) {
                this.setOptimizedAlternativeToThis(lastElse);
            }
            MathComponent finalElse = lastElse;
            this.setSupplierAndOptimize(() -> {
                for (Tuple ifSet : ifSets) {
                    if (((MathComponent)ifSet.m_14418_()).getResult() != 1.0f) continue;
                    return ((MathComponent)ifSet.m_14419_()).getResult();
                }
                return finalElse.getResult();
            }, parsedArgs);
        }
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3 && argCount % 2 == 1;
    }
}

