/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;

public class KeyframeMethod
extends MathMethod {
    public KeyframeMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        List<MathComponent> parsedArgs = KeyframeMethod.parseAllArgs(args, calculationInstance);
        MathComponent delta = parsedArgs.get(0);
        ArrayList<MathComponent> frames = new ArrayList<MathComponent>(parsedArgs);
        frames.remove(0);
        int max = frames.size() - 1;
        MathValue.ResultSupplier supplier = () -> {
            float deltaVal = delta.getResult();
            int frameIndex = (int)deltaVal;
            if (frameIndex >= max) {
                return ((MathComponent)frames.get(max)).getResult();
            }
            if (frameIndex < 0) {
                return ((MathComponent)frames.get(0)).getResult();
            }
            float frameDelta = deltaVal - (float)frameIndex;
            MathComponent lastFrame = (MathComponent)frames.get(frameIndex);
            MathComponent nextFrame = (MathComponent)frames.get(frameIndex + 1);
            return Mth.m_14179_((float)frameDelta, (float)lastFrame.getResult(), (float)nextFrame.getResult());
        };
        if (delta.isConstant()) {
            float deltaVal = delta.getResult();
            int frameIndex = (int)deltaVal;
            if (frameIndex >= max) {
                this.setOptimizedAlternativeToThis(() -> ((MathComponent)frames.get(max)).getResult());
            } else if (frameIndex < 0) {
                this.setOptimizedAlternativeToThis(() -> ((MathComponent)frames.get(0)).getResult());
            }
            float frameDelta = deltaVal - (float)frameIndex;
            MathComponent lastFrame = (MathComponent)frames.get(frameIndex);
            MathComponent nextFrame = (MathComponent)frames.get(frameIndex + 1);
            this.setOptimizedAlternativeToThis(() -> Mth.m_14179_((float)frameDelta, (float)lastFrame.getResult(), (float)nextFrame.getResult()));
        }
        this.setSupplierAndOptimize(supplier, parsedArgs);
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount >= 3;
    }
}

