/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;

public abstract class MathValue
implements MathComponent {
    final EMFAnimation calculationInstance;
    boolean isNegative;

    MathValue(boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        this.isNegative = isNegative;
        this.calculationInstance = calculationInstance;
        if (calculationInstance == null) {
            throw new EMFMathException("calculationInstance cannot be null if declared");
        }
    }

    MathValue(boolean isNegative) {
        this.isNegative = isNegative;
        this.calculationInstance = null;
    }

    MathValue() {
        this.isNegative = false;
        this.calculationInstance = null;
    }

    abstract ResultSupplier getResultSupplier();

    @Override
    public float getResult() {
        return this.isNegative ? -this.getResultSupplier().get() : this.getResultSupplier().get();
    }

    public void makeNegative(boolean become) {
        if (become) {
            this.isNegative = !this.isNegative;
        }
    }

    public static interface ResultSupplier {
        public float get();
    }
}

