/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math;

import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFUtils;

public class MathConstant
extends MathValue
implements MathComponent {
    public static final MathConstant ZERO = new MathConstant(0.0f){
        private static final MathValue.ResultSupplier supplier = () -> 0.0f;

        @Override
        public void makeNegative(boolean become) {
        }

        @Override
        public MathValue.ResultSupplier getResultSupplier() {
            return supplier;
        }
    };
    public static final MathConstant ONE = new MathConstant(1.0f){
        private static final MathValue.ResultSupplier supplier = () -> 1.0f;

        @Override
        public void makeNegative(boolean become) {
        }

        @Override
        public MathValue.ResultSupplier getResultSupplier() {
            return supplier;
        }
    };
    private float hardCodedValue;

    public MathConstant(float number, boolean isNegative) {
        this.hardCodedValue = isNegative ? -number : number;
    }

    public MathConstant(float number) {
        this.hardCodedValue = number;
    }

    @Override
    public MathValue.ResultSupplier getResultSupplier() {
        EMFUtils.logError("EMF math constant: this shouldn't happen!");
        return () -> this.hardCodedValue;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public void makeNegative(boolean become) {
        if (become) {
            this.hardCodedValue = -this.hardCodedValue;
        }
    }

    public String toString() {
        return String.valueOf(this.getResult());
    }

    @Override
    public float getResult() {
        return this.hardCodedValue;
    }
}

