/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.phys.Vec3;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.EntityRenderDispatcherAccessor;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.models.EMFModelPartRoot;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_model_features.utils.EMFManager;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;
import traben.entity_texture_features.ETFApi;

public class EMFAnimationEntityContext {
    private static final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };
    public static boolean setInHand = false;
    public static boolean setInItemFrame = false;
    public static boolean setIsOnHead = false;
    private static EMFEntity emfEntity = null;
    private static float shadowSize = Float.NaN;
    private static float shadowOpacity = Float.NaN;
    private static float leashX = Float.NaN;
    private static float leashY = Float.NaN;
    private static float leashZ = Float.NaN;
    private static float shadowX = Float.NaN;
    private static float shadowZ = Float.NaN;
    private static float limbAngle = Float.NaN;
    private static float limbDistance = Float.NaN;
    private static float headYaw = Float.NaN;
    private static float headPitch = Float.NaN;
    private static float tickDelta = 0.0f;
    private static boolean onShoulder = false;
    private static Function<ResourceLocation, RenderType> layerFactory = null;
    private static int lodFactor = -1;
    private static boolean announceModels = false;
    public static double lastFOV = 70.0;

    private EMFAnimationEntityContext() {
    }

    public static void setLayerFactory(Function<ResourceLocation, RenderType> layerFactory) {
        EMFAnimationEntityContext.layerFactory = layerFactory;
    }

    private static int distanceOfEntityFrom(BlockPos pos) {
        if (emfEntity == null) {
            return 0;
        }
        BlockPos blockPos = emfEntity.etf$getBlockPos();
        float f = blockPos.m_123341_() - pos.m_123341_();
        float g = blockPos.m_123342_() - pos.m_123342_();
        float h = blockPos.m_123343_() - pos.m_123343_();
        return (int)Mth.m_14116_((float)(f * f + g * g + h * h));
    }

    public static int getLODFactorOfEntity() {
        if (lodFactor != -1) {
            return lodFactor;
        }
        if (EMFConfig.getConfig().animationLODDistance == 0) {
            return 0;
        }
        if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.m_150108_()) {
            return 0;
        }
        int distance = EMFAnimationEntityContext.distanceOfEntityFrom(Minecraft.m_91087_().f_91074_.m_20183_());
        if (distance < 1) {
            return 0;
        }
        int factor = distance / EMFConfig.getConfig().animationLODDistance;
        int factorByFOV = (int)((double)factor * lastFOV / 70.0);
        if (EMFConfig.getConfig().retainDetailOnLowFps && Minecraft.m_91087_().m_260875_() < 59) {
            float fpsPercentageOf60 = (float)Minecraft.m_91087_().m_260875_() / 60.0f;
            lodFactor = (int)((float)factorByFOV * fpsPercentageOf60);
        } else {
            lodFactor = factorByFOV;
        }
        return lodFactor;
    }

    public static void setCurrentEntityIteration(EMFEntity entityIn) {
        layerFactory = null;
        EMFAnimationEntityContext.newEntity(entityIn);
        ++EMFManager.getInstance().entityRenderCount;
        tickDelta = Minecraft.m_91087_().m_91104_() ? ((MinecraftClientAccessor)Minecraft.m_91087_()).getPausedTickDelta() : Minecraft.m_91087_().m_91296_();
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        Set roots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForVariation.get((Object)entityIn.emf$getTypeString());
        if (roots != null) {
            roots.forEach(Runnable::run);
        }
        if (EMFConfig.getConfig().debugOnRightClick && entityIn.etf$getUuid().equals(EMFManager.getInstance().entityForDebugPrint)) {
            announceModels = true;
            EMFManager.getInstance().entityForDebugPrint = null;
        }
        lodFactor = -1;
    }

    public static void anounceModels(EMFEntity assertEntity) {
        StringBuilder model;
        int count;
        String type = assertEntity.emf$getTypeString();
        Set debugRoots = (Set)EMFManager.getInstance().rootPartsPerEntityTypeForDebug.get((Object)type);
        EMFUtils.chat("\u00a7e-----------EMF Debug Printout-------------\u00a7r");
        if (debugRoots == null) {
            EMFUtils.chat("\n\u00a7c\u00a7oThe EMF debug printout did not find any custom models registered to the following entity:\n \u00a73\u00a7l\u00a7u" + type);
        } else {
            String message = "\n\u00a72\u00a7oThe EMF debug printout found the following custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(message);
            count = 1;
            for (EMFModelPartRoot debugRoot : debugRoots) {
                model = new StringBuilder();
                model.append("\u00a7eModel #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("name", debugRoot.modelName.getfileName() + ".jem"));
                if (debugRoot.variantDirectoryApplier != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("directory", debugRoot.variantDirectoryApplier.getThisDirectoryOfFilename(debugRoot.modelName.getfileName())));
                }
                if (debugRoot.textureOverride != null) {
                    model.append(EMFAnimationEntityContext.entryAndValue("texture_override", debugRoot.textureOverride.toString()));
                }
                if (debugRoot.variantTester != null) {
                    IntArraySet set = new IntArraySet(debugRoot.allKnownStateVariants.keySet());
                    set.remove(0);
                    model.append(EMFAnimationEntityContext.entryAndValue("model_variants", set.toString())).append(EMFAnimationEntityContext.entryAndValue("current_variant", String.valueOf(debugRoot.currentModelVariant)));
                }
                EMFUtils.chat(model + "\n\u00a76 - parts:\u00a7r printed in game log only.");
                EMFUtils.log("\n - parts: " + debugRoot.simplePrintChildren(0));
                ++count;
            }
        }
        EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
        if (!EMFManager.getInstance().modelsAnnounced.isEmpty()) {
            String vanillaMessage = "\n\u00a72\u00a7oThe EMF debug printout found the following non-custom models for the entity:\n \u00a73\u00a7l\u00a7u" + type + "\u00a7r\n\u00a72\u00a7oThis first model is usually the primary model for the entity.";
            EMFUtils.chat(vanillaMessage);
            count = 1;
            for (OptifineMobNameForFileAndEMFMapId data : EMFManager.getInstance().modelsAnnounced) {
                model = new StringBuilder();
                model.append("\n\u00a7Non-Custom Model #").append(count).append("\u00a7r").append(EMFAnimationEntityContext.entryAndValue("possible .jem name", data.getfileName() + ".jem"));
                Map<String, String> map = EMFOptiFinePartNameMappings.getMapOf(data.getMapId(), null);
                if (!map.isEmpty()) {
                    EMFUtils.chat(model + "\n\u00a76 - part names:\u00a7r printed in game log only.");
                    StringBuilder parts = new StringBuilder();
                    parts.append("\n - part names: ");
                    map.forEach((k, v) -> parts.append("\n   | - [").append((String)k).append(']'));
                    EMFUtils.log(parts.toString());
                    continue;
                }
                EMFUtils.chat(model.toString());
                EMFUtils.log(" - part names: could not be found. use the 'printout unknown models' setting instead.");
            }
            EMFUtils.chat("\n\u00a7e----------------------------------------\u00a7r");
            EMFManager.getInstance().modelsAnnounced.clear();
        }
        announceModels = false;
    }

    public static boolean doAnnounceModels() {
        return announceModels;
    }

    private static String entryAndValue(String entry, String value) {
        return "\n\u00a76 - " + entry + ":\u00a7r " + value;
    }

    public static void setCurrentEntityNoIteration(EMFEntity entityIn) {
        EMFAnimationEntityContext.newEntity(entityIn);
    }

    private static void newEntity(EMFEntity entityIn) {
        emfEntity = entityIn;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
    }

    public static void reset() {
        layerFactory = null;
        emfEntity = null;
        limbAngle = Float.NaN;
        limbDistance = Float.NaN;
        headYaw = Float.NaN;
        headPitch = Float.NaN;
        onShoulder = false;
        tickDelta = 0.0f;
        shadowSize = Float.NaN;
        shadowOpacity = Float.NaN;
        leashX = 0.0f;
        leashY = 0.0f;
        leashZ = 0.0f;
        shadowX = 0.0f;
        shadowZ = 0.0f;
        lodFactor = -1;
    }

    public static RenderType getLayerFromRecentFactoryOrTranslucent(ResourceLocation identifier) {
        if (layerFactory == null) {
            return RenderType.m_110473_((ResourceLocation)identifier);
        }
        return layerFactory.apply(identifier);
    }

    public static float getRuleIndex() {
        int index;
        if (emfEntity == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof Entity) {
            Entity entity = (Entity)eMFEntity;
            index = ETFApi.getLastMatchingRuleOfEntity((Entity)entity);
        } else {
            index = ETFApi.getLastMatchingRuleOfBlockEntity((BlockEntity)((BlockEntity)emfEntity));
        }
        return index == -1 ? 0.0f : (float)index;
    }

    public static EMFEntity getEMFEntity() {
        return emfEntity;
    }

    public static float getDimension() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f;
        }
        ResourceLocation id = emfEntity.etf$getWorld().m_220362_().m_135782_();
        if (id.equals((Object)BuiltinDimensionTypes.f_223543_)) {
            return -1.0f;
        }
        if (id.equals((Object)BuiltinDimensionTypes.f_223544_)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static float getPlayerX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19854_, (double)Minecraft.m_91087_().f_91074_.m_20185_());
    }

    public static float getPlayerY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19855_, (double)Minecraft.m_91087_().f_91074_.m_20186_());
    }

    public static float getPlayerZ() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Mth.m_14139_((double)tickDelta, (double)Minecraft.m_91087_().f_91074_.f_19856_, (double)Minecraft.m_91087_().f_91074_.m_20189_());
    }

    public static float getPlayerRX() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19860_, (float)Minecraft.m_91087_().f_91074_.m_146909_()));
    }

    public static float getPlayerRY() {
        return Minecraft.m_91087_().f_91074_ == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)Minecraft.m_91087_().f_91074_.f_19859_, (float)Minecraft.m_91087_().f_91074_.m_146908_()));
    }

    public static float getEntityX() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevX(), (double)emfEntity.emf$getX());
    }

    public static float getEntityY() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevY(), (double)emfEntity.emf$getY());
    }

    public static float getEntityZ() {
        return emfEntity == null ? 0.0f : (float)Mth.m_14139_((double)EMFAnimationEntityContext.getTickDelta(), (double)emfEntity.emf$prevZ(), (double)emfEntity.emf$getZ());
    }

    public static float getEntityRX() {
        return emfEntity == null ? 0.0f : (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)emfEntity.emf$prevPitch(), (float)emfEntity.emf$getPitch()));
    }

    public static float getEntityRY() {
        float f;
        if (emfEntity == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)alive.f_20884_, (float)alive.m_213816_()));
        } else {
            eMFEntity = emfEntity;
            if (eMFEntity instanceof Entity) {
                Entity entity = (Entity)eMFEntity;
                f = (float)Math.toRadians(Mth.m_14189_((float)tickDelta, (float)entity.f_19859_, (float)entity.m_146908_()));
            } else {
                f = 0.0f;
            }
        }
        return f;
    }

    public static float getTime() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        long upTimeInTicks = emfEntity.etf$getWorld().m_46467_();
        return EMFAnimationEntityContext.constrainedFloat(upTimeInTicks, 720720) + tickDelta;
    }

    public static float getDayTime() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationEntityContext.constrainedFloat(emfEntity.etf$getWorld().m_46468_(), 24000) + tickDelta;
    }

    public static float getDayCount() {
        if (emfEntity == null || emfEntity.etf$getWorld() == null) {
            return 0.0f + tickDelta;
        }
        return (float)(emfEntity.etf$getWorld().m_46468_() / 24000L) + tickDelta;
    }

    public static float getHealth() {
        float f;
        if (emfEntity == null) {
            return 0.0f;
        }
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.m_21223_();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getDeathTime() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.f_20919_;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAngerTime() {
        if (!(emfEntity instanceof NeutralMob)) {
            return 0.0f;
        }
        float currentKnownHighest = knownHighestAngerTimeByUUID.getInt((Object)emfEntity.etf$getUuid());
        int angerTime = ((NeutralMob)emfEntity).m_6784_();
        if (angerTime <= 0) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.etf$getUuid(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            knownHighestAngerTimeByUUID.put((Object)emfEntity.etf$getUuid(), angerTime);
        }
        return (float)angerTime - tickDelta;
    }

    public static float getAngerTimeStart() {
        return emfEntity instanceof NeutralMob ? (float)knownHighestAngerTimeByUUID.getInt((Object)emfEntity.etf$getUuid()) : 0.0f;
    }

    public static float getMaxHealth() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.m_21233_();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public static float getId() {
        return emfEntity == null ? 0.0f : (float)emfEntity.etf$getUuid().hashCode();
    }

    public static float getHurtTime() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.f_20916_ > 0 ? (float)alive.f_20916_ - tickDelta : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static boolean isInWater() {
        return emfEntity != null && emfEntity.emf$isTouchingWater();
    }

    public static boolean isBurning() {
        return emfEntity != null && emfEntity.emf$isOnFire();
    }

    public static boolean isRiding() {
        return emfEntity != null && emfEntity.emf$hasVehicle();
    }

    public static boolean isChild() {
        LivingEntity alive;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof LivingEntity && (alive = (LivingEntity)eMFEntity).m_6162_();
    }

    public static boolean isOnGround() {
        return emfEntity != null && emfEntity.emf$isOnGround();
    }

    public static boolean isClimbing() {
        LivingEntity alive;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof LivingEntity && (alive = (LivingEntity)eMFEntity).m_6147_();
    }

    public static boolean isAlive() {
        if (emfEntity == null) {
            return false;
        }
        return emfEntity.emf$isAlive();
    }

    public static boolean isAggressive() {
        Mob mob;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof Mob && (mob = (Mob)eMFEntity).m_5912_();
    }

    public static boolean isGlowing() {
        return emfEntity != null && emfEntity.emf$isGlowing();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isHurt() {
        EMFEntity eMFEntity = emfEntity;
        if (!(eMFEntity instanceof LivingEntity)) return false;
        LivingEntity alive = (LivingEntity)eMFEntity;
        if (alive.f_20916_ <= 0) return false;
        return true;
    }

    public static boolean isInHand() {
        return setInHand;
    }

    public static boolean isInItemFrame() {
        return setInItemFrame;
    }

    public static boolean isInGround() {
        Projectile proj;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof Projectile && (proj = (Projectile)eMFEntity).m_5830_();
    }

    public static boolean isInGui() {
        return Minecraft.m_91087_().f_91080_ != null && !((EntityRenderDispatcherAccessor)Minecraft.m_91087_().m_91290_()).isRenderShadows();
    }

    public static boolean isInLava() {
        return emfEntity != null && emfEntity.emf$isInLava();
    }

    public static boolean isInvisible() {
        return emfEntity != null && emfEntity.emf$isInvisible();
    }

    public static boolean isOnHead() {
        return setIsOnHead;
    }

    public static boolean isOnShoulder() {
        return onShoulder;
    }

    public static void setCurrentEntityOnShoulder() {
        onShoulder = true;
    }

    public static boolean isRidden() {
        return emfEntity != null && emfEntity.emf$hasPassengers();
    }

    public static boolean isSitting() {
        Wolf wolf;
        Cat cat;
        Parrot parrot;
        Fox fox;
        TamableAnimal tame;
        if (emfEntity == null) {
            return false;
        }
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof TamableAnimal && (tame = (TamableAnimal)eMFEntity).m_21825_() || (eMFEntity = emfEntity) instanceof Fox && (fox = (Fox)eMFEntity).m_28555_() || (eMFEntity = emfEntity) instanceof Parrot && (parrot = (Parrot)eMFEntity).m_21825_() || (eMFEntity = emfEntity) instanceof Cat && (cat = (Cat)eMFEntity).m_21825_() || (eMFEntity = emfEntity) instanceof Wolf && (wolf = (Wolf)eMFEntity).m_21825_();
    }

    public static boolean isSneaking() {
        return emfEntity != null && emfEntity.emf$isSneaking();
    }

    public static boolean isSprinting() {
        return emfEntity != null && emfEntity.emf$isSprinting();
    }

    public static boolean isTamed() {
        TamableAnimal tame;
        EMFEntity eMFEntity = emfEntity;
        return eMFEntity instanceof TamableAnimal && (tame = (TamableAnimal)eMFEntity).m_21824_();
    }

    public static boolean isWet() {
        return emfEntity != null && emfEntity.emf$isWet();
    }

    public static float getSwingProgress() {
        float f;
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            f = alive.m_21324_(tickDelta);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static float getAge() {
        if (emfEntity == null) {
            return 0.0f + tickDelta;
        }
        return EMFAnimationEntityContext.constrainedFloat(emfEntity.emf$age(), 24000) + tickDelta;
    }

    private static float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private static float constrainedFloat(float value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private static float constrainedFloat(long value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    private static float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private static float constrainedFloat(int value) {
        return EMFAnimationEntityContext.constrainedFloat(value, 24000);
    }

    public static float getFrameTime() {
        return Minecraft.m_91087_().m_91297_() / 20.0f;
    }

    public static float getLimbAngle() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbAngle)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbAngle;
    }

    public static void setLimbAngle(float limbAngle) {
        EMFAnimationEntityContext.limbAngle = limbAngle;
    }

    public static float getLimbDistance() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(limbDistance)) {
            EMFAnimationEntityContext.doLimbValues();
        }
        return limbDistance == Float.MIN_VALUE ? 0.0f : limbDistance;
    }

    public static void setLimbDistance(float limbDistance) {
        EMFAnimationEntityContext.limbDistance = limbDistance;
    }

    private static void doLimbValues() {
        EMFEntity eMFEntity;
        float o = 0.0f;
        float n = 0.0f;
        if (!emfEntity.emf$hasVehicle() && (eMFEntity = emfEntity) instanceof LivingEntity) {
            LivingEntity alive = (LivingEntity)eMFEntity;
            o = alive.f_267362_.m_267590_(tickDelta);
            n = alive.f_267362_.m_267711_(tickDelta);
            if (alive.m_6162_()) {
                o *= 3.0f;
            }
            if (n > 1.0f) {
                n = 1.0f;
            }
        } else if (emfEntity instanceof Minecart) {
            n = 1.0f;
            o = -(EMFAnimationEntityContext.getEntityX() + EMFAnimationEntityContext.getEntityZ());
        } else {
            eMFEntity = emfEntity;
            if (eMFEntity instanceof Boat) {
                Boat boat = (Boat)eMFEntity;
                n = 1.0f;
                o = Math.max(boat.m_38315_(1, tickDelta), boat.m_38315_(0, tickDelta));
            }
        }
        limbDistance = n;
        limbAngle = o;
    }

    public static float getHeadYaw() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headYaw)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headYaw;
    }

    public static void setHeadYaw(float headYaw) {
        EMFAnimationEntityContext.headYaw = headYaw;
    }

    public static float getHeadPitch() {
        if (emfEntity == null) {
            return 0.0f;
        }
        if (Float.isNaN(headPitch)) {
            EMFAnimationEntityContext.doHeadValues();
        }
        return headPitch;
    }

    public static void setHeadPitch(float headPitch) {
        EMFAnimationEntityContext.headPitch = headPitch;
    }

    private static void doHeadValues() {
        EMFEntity eMFEntity = emfEntity;
        if (eMFEntity instanceof LivingEntity) {
            Entity entity;
            LivingEntity livingEntity = (LivingEntity)eMFEntity;
            float h = Mth.m_14189_((float)tickDelta, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
            float j = Mth.m_14189_((float)tickDelta, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
            float k = j - h;
            if (livingEntity.m_20159_() && (entity = livingEntity.m_20202_()) instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                h = Mth.m_14189_((float)tickDelta, (float)livingEntity2.f_20884_, (float)livingEntity2.f_20883_);
                k = j - h;
                float l = Mth.m_14177_((float)k);
                if (l < -85.0f) {
                    l = -85.0f;
                }
                if (l >= 85.0f) {
                    l = 85.0f;
                }
                h = j - l;
                if (l * l > 2500.0f) {
                    h += l * 0.2f;
                }
                k = j - h;
            }
            float m = Mth.m_14179_((float)tickDelta, (float)livingEntity.f_19860_, (float)livingEntity.m_146909_());
            if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
                m *= -1.0f;
                k *= -1.0f;
            }
            headPitch = m;
            headYaw = k >= 180.0f || k < -180.0f ? Mth.m_14177_((float)k) : k;
        } else {
            headPitch = 0.0f;
            headYaw = 0.0f;
        }
    }

    public static float getTickDelta() {
        return tickDelta;
    }

    public static float getMoveForward() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.emf$getYaw());
        Vec3 velocity = emfEntity.emf$getVelocity();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return EMFAnimationEntityContext.processMove(newX, x, y);
    }

    public static float getMoveStrafe() {
        if (emfEntity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - emfEntity.emf$getYaw());
        Vec3 velocity = emfEntity.emf$getVelocity();
        double x = velocity.f_82479_;
        double y = velocity.f_82481_;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return EMFAnimationEntityContext.processMove(newY, x, y);
    }

    private static float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }

    public static float getShadowSize() {
        return shadowSize;
    }

    public static void setShadowSize(float shadowSize) {
        EMFAnimationEntityContext.shadowSize = shadowSize;
    }

    public static float getShadowOpacity() {
        return shadowOpacity;
    }

    public static void setShadowOpacity(float shadowOpacity) {
        EMFAnimationEntityContext.shadowOpacity = shadowOpacity;
    }

    public static float getLeashX() {
        return leashX;
    }

    public static void setLeashX(float leashX) {
        EMFAnimationEntityContext.leashX = leashX;
    }

    public static float getLeashY() {
        return leashY;
    }

    public static void setLeashY(float leashY) {
        EMFAnimationEntityContext.leashY = leashY;
    }

    public static float getLeashZ() {
        return leashZ;
    }

    public static void setLeashZ(float leashZ) {
        EMFAnimationEntityContext.leashZ = leashZ;
    }

    public static float getShadowX() {
        return shadowX;
    }

    public static void setShadowX(float shadowX) {
        EMFAnimationEntityContext.shadowX = shadowX;
    }

    public static float getShadowZ() {
        return shadowZ;
    }

    public static void setShadowZ(float shadowZ) {
        EMFAnimationEntityContext.shadowZ = shadowZ;
    }
}

