/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class EnumSliderWidget<T extends Enum<?>>
extends AbstractSliderButton {
    private final Consumer<T> valueReceiver;
    private final T[] enumValues;
    private final String title;

    public EnumSliderWidget(int x, int y, int width, int height, Component text, T defaultValue, Consumer<T> valueReceiver) {
        super(x, y, width, height, text, (double)((Enum)defaultValue).ordinal() / (double)(((Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants()).length - 1));
        this.valueReceiver = Objects.requireNonNull(valueReceiver);
        this.enumValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
        this.title = text.getString() + ": ";
        this.m_5695_();
    }

    public EnumSliderWidget(int x, int y, int width, int height, Component text, T defaultValue, Consumer<T> valueReceiver, Component tooltip) {
        this(x, y, width, height, text, defaultValue, valueReceiver);
        this.m_257544_(Tooltip.m_257550_((Component)tooltip));
    }

    protected void m_5695_() {
        this.m_93666_(Component.m_130674_((String)(this.title + ((Enum)this.enumValues[this.getIndex()]).toString())));
    }

    private int getIndex() {
        return (int)Math.round(this.f_93577_ * (double)(this.enumValues.length - 1));
    }

    protected void m_5697_() {
        int index = this.getIndex();
        this.f_93577_ = (double)index / (double)(this.enumValues.length - 1);
        this.valueReceiver.accept(this.enumValues[index]);
    }
}

