/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.config.ETFConfig;

public class EMFConfig {
    private static EMFConfig INSTANCE;
    public boolean logModelCreationData = false;
    public boolean debugOnRightClick = false;
    public RenderModeChoice renderModeChoice = RenderModeChoice.NORMAL;
    public VanillaModelRenderMode vanillaModelHologramRenderMode_2 = VanillaModelRenderMode.OFF;
    public boolean attemptRevertingEntityModelsAlteredByAnotherMod = true;
    public ModelPrintMode modelExportMode = ModelPrintMode.NONE;
    public PhysicsModCompatChoice attemptPhysicsModPatch_2 = PhysicsModCompatChoice.CUSTOM;
    public ETFConfig.UpdateFrequency modelUpdateFrequency = ETFConfig.UpdateFrequency.Average;
    public boolean allowEBEModConfigModify = true;
    public int animationLODDistance = 20;
    public boolean retainDetailOnLowFps = true;

    public static EMFConfig getConfig() {
        if (INSTANCE == null) {
            EMFConfig.loadConfig();
        }
        return INSTANCE;
    }

    public static void setConfig(EMFConfig newConfig) {
        if (newConfig != null) {
            INSTANCE = newConfig;
        }
    }

    public static void EMF_saveConfig() {
        File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)INSTANCE));
            fileWriter.close();
        }
        catch (IOException e) {
            EMFUtils.log("Config could not be saved", false);
        }
    }

    public static void loadConfig() {
        try {
            File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    INSTANCE = (EMFConfig)gson.fromJson((Reader)fileReader, EMFConfig.class);
                    fileReader.close();
                    EMFConfig.EMF_saveConfig();
                }
                catch (IOException e) {
                    EMFUtils.log("Config could not be loaded, using defaults", false);
                }
            } else {
                INSTANCE = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
            if (INSTANCE == null) {
                INSTANCE = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
        }
        catch (Exception e) {
            INSTANCE = new EMFConfig();
        }
    }

    public static EMFConfig copyFrom(EMFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (EMFConfig)gson.fromJson(gson.toJson((Object)source), EMFConfig.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EMFConfig emfConfig = (EMFConfig)o;
        return this.allowEBEModConfigModify == emfConfig.allowEBEModConfigModify && this.debugOnRightClick == emfConfig.debugOnRightClick && this.modelUpdateFrequency == emfConfig.modelUpdateFrequency && this.logModelCreationData == emfConfig.logModelCreationData && this.attemptRevertingEntityModelsAlteredByAnotherMod == emfConfig.attemptRevertingEntityModelsAlteredByAnotherMod && this.renderModeChoice == emfConfig.renderModeChoice && this.vanillaModelHologramRenderMode_2 == emfConfig.vanillaModelHologramRenderMode_2 && this.modelExportMode == emfConfig.modelExportMode && this.attemptPhysicsModPatch_2 == emfConfig.attemptPhysicsModPatch_2 && this.animationLODDistance == emfConfig.animationLODDistance && this.retainDetailOnLowFps == emfConfig.retainDetailOnLowFps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.retainDetailOnLowFps, this.animationLODDistance, this.allowEBEModConfigModify, this.debugOnRightClick, this.modelUpdateFrequency, this.logModelCreationData, this.renderModeChoice, this.vanillaModelHologramRenderMode_2, this.attemptRevertingEntityModelsAlteredByAnotherMod, this.modelExportMode, this.attemptPhysicsModPatch_2});
    }

    public static enum RenderModeChoice {
        NORMAL((Component)Component.m_237115_((String)"entity_model_features.config.render.normal")),
        GREEN((Component)Component.m_237115_((String)"entity_model_features.config.render.green")),
        LINES_AND_TEXTURE((Component)Component.m_237115_((String)"entity_model_features.config.render.lines_texture")),
        LINES_AND_TEXTURE_FLASH((Component)Component.m_237115_((String)"entity_model_features.config.render.lines_texture_flash")),
        LINES((Component)Component.m_237115_((String)"entity_model_features.config.render.lines")),
        NONE((Component)Component.m_237115_((String)"entity_model_features.config.render.none"));

        private final String text;

        private RenderModeChoice(Component text) {
            this.text = text.getString();
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum VanillaModelRenderMode {
        OFF(CommonComponents.f_130654_),
        NORMAL((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.normal")),
        OFFSET((Component)Component.m_237115_((String)"entity_model_features.config.vanilla_render.offset"));

        private final Component text;

        private VanillaModelRenderMode(Component text) {
            this.text = text;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum ModelPrintMode {
        NONE(CommonComponents.f_130654_),
        LOG_ONLY((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.log")),
        LOG_AND_JEM((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.log_jem")),
        ALL_LOG_ONLY((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.all_log")),
        ALL_LOG_AND_JEM((Component)Component.m_237115_((String)"entity_model_features.config.print_mode.all_log_jem"));

        private final Component text;

        private ModelPrintMode(Component text) {
            this.text = text;
        }

        public boolean doesJems() {
            return this == LOG_AND_JEM || this == ALL_LOG_AND_JEM;
        }

        public boolean doesAll() {
            return this == ALL_LOG_ONLY || this == ALL_LOG_AND_JEM;
        }

        public boolean doesLog() {
            return this != NONE;
        }

        public String toString() {
            return this.text.getString();
        }
    }

    public static enum PhysicsModCompatChoice {
        OFF(CommonComponents.f_130654_),
        VANILLA((Component)Component.m_237115_((String)"entity_model_features.config.physics.1")),
        CUSTOM((Component)Component.m_237115_((String)"entity_model_features.config.physics.2"));

        private final Component text;

        private PhysicsModCompatChoice(Component text) {
            this.text = text;
        }

        public Component asText() {
            return this.text;
        }

        public PhysicsModCompatChoice next() {
            return switch (this) {
                case OFF -> CUSTOM;
                case CUSTOM -> VANILLA;
                default -> OFF;
            };
        }
    }
}

