/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.config.ETFConfig;

public class ETFLruCache<X, Y>
extends Object2ObjectLinkedOpenHashMap<X, Y> {
    final int capacity;

    public ETFLruCache() {
        this.defRetValue = null;
        this.capacity = 2048;
    }

    @Nullable
    public Y get(Object key) {
        return (Y)this.getAndMoveToFirst(key);
    }

    public Y put(X key, Y value) {
        Object lastKey;
        double d = this.size();
        double d2 = this.capacity;
        double d3 = ETFConfig.getInstance().advanced_IncreaseCacheSizeModifier > 1.0 ? ETFConfig.getInstance().advanced_IncreaseCacheSizeModifier : 1.0;
        if (d >= d2 * d3 && !(lastKey = this.lastKey()).equals(key)) {
            this.remove(lastKey);
        }
        return (Y)this.putAndMoveToFirst(key, value);
    }

    public void removeEntryOnly(X key) {
        this.remove(key);
    }
}

