/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

public class ETFSprite {
    public final boolean isETFAltered;
    private final TextureAtlasSprite sprite;
    private final TextureAtlasSprite emissiveSprite;

    public ETFSprite(@NotNull TextureAtlasSprite originalSprite, @NotNull ETFTexture etfTexture) {
        Optional resource;
        ResourceLocation emissiveId;
        SpriteContents contents;
        if (etfTexture.getVariantNumber() != 0) {
            ResourceLocation variantId = etfTexture.getTextureIdentifier(null);
            Optional resource2 = Minecraft.m_91087_().m_91098_().m_213713_(variantId);
            if (resource2.isPresent()) {
                TextureAtlasSprite possibleVariant = null;
                contents = SpriteLoader.m_245083_((ResourceLocation)new ResourceLocation(variantId + "-etf_sprite"), (Resource)((Resource)resource2.get()));
                try {
                    if (contents != null) {
                        possibleVariant = new TextureAtlasSprite(variantId, contents, contents.m_246492_(), contents.m_245330_(), 0, 0);
                    }
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
                this.sprite = Objects.requireNonNullElse(possibleVariant, originalSprite);
            } else {
                this.sprite = originalSprite;
            }
        } else {
            this.sprite = originalSprite;
        }
        this.isETFAltered = !this.sprite.equals(originalSprite);
        TextureAtlasSprite possibleEmissive = null;
        if (etfTexture.eSuffix != null && (emissiveId = etfTexture.getEmissiveIdentifierOfCurrentState()) != null && (resource = Minecraft.m_91087_().m_91098_().m_213713_(emissiveId)).isPresent()) {
            contents = SpriteLoader.m_245083_((ResourceLocation)new ResourceLocation(emissiveId + "-etf_sprite"), (Resource)((Resource)resource.get()));
            try {
                if (contents != null) {
                    possibleEmissive = new TextureAtlasSprite(emissiveId, contents, contents.m_246492_(), contents.m_245330_(), 0, 0);
                }
            }
            finally {
                if (contents != null) {
                    contents.close();
                }
            }
        }
        this.emissiveSprite = possibleEmissive;
    }

    @NotNull
    public TextureAtlasSprite getEmissive() {
        return this.emissiveSprite;
    }

    public boolean isEmissive() {
        return this.emissiveSprite != null;
    }

    @NotNull
    public TextureAtlasSprite getSpriteVariant() {
        return this.sprite;
    }
}

