/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.Optional;
import java.util.Properties;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class ColorProperty
extends StringArrayOrRegexProperty {
    protected ColorProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(RandomProperty.readPropertiesOrThrow(properties, propertyNum, "colors", "collarColors"));
    }

    public static ColorProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new ColorProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    @Nullable
    protected String getValueFromEntity(ETFEntity entity) {
        if (entity != null) {
            if (entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                return wolf.m_30428_().m_41065_();
            }
            if (entity instanceof Sheep) {
                Sheep sheep = (Sheep)entity;
                return sheep.m_29874_().m_41065_();
            }
            if (entity instanceof Llama) {
                Llama llama = (Llama)entity;
                DyeColor str = llama.m_30826_();
                if (str != null) {
                    return str.m_41065_();
                }
            } else {
                if (entity instanceof Cat) {
                    Cat cat = (Cat)entity;
                    return cat.m_28166_().m_41065_();
                }
                if (entity instanceof Shulker) {
                    Shulker shulker = (Shulker)entity;
                    DyeColor str = shulker.m_33467_();
                    if (str != null) {
                        return str.m_41065_();
                    }
                } else if (entity instanceof TropicalFish) {
                    TropicalFish fishy = (TropicalFish)entity;
                    DyeColor str = TropicalFish.m_30050_((int)fishy.m_28554_().m_262435_());
                    if (str != null) {
                        return str.m_41065_();
                    }
                } else if (entity instanceof VariantHolder) {
                    VariantHolder variantHolder = (VariantHolder)entity;
                    try {
                        Optional optional;
                        Object object = variantHolder.m_28554_();
                        if (object instanceof DyeColor) {
                            DyeColor dye = (DyeColor)object;
                            return dye.m_41065_();
                        }
                        object = variantHolder.m_28554_();
                        if (object instanceof Optional && (optional = (Optional)object).isPresent() && (object = optional.get()) instanceof DyeColor) {
                            DyeColor dye = (DyeColor)object;
                            return dye.m_41065_();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return true;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"colors", "collarColors"};
    }
}

