/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class BlocksProperty
extends StringArrayOrRegexProperty {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            String var10000 = property.m_61708_();
            return var10000 + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(Property<T> property, Comparable<?> value) {
            return property.m_6940_(value);
        }
    };

    protected BlocksProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(BlocksProperty.readPropertiesOrThrow(properties, propertyNum, "blocks", "block").replaceAll("(?<=(^| ))minecraft:", ""));
    }

    public static BlocksProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new BlocksProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    private static String getBlockFormattedFromState(BlockState state) {
        Object block = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString();
        if (!state.m_61148_().isEmpty()) {
            block = (String)block + ":" + state.m_61148_().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(":"));
        }
        if (((String)block).startsWith("minecraft:")) {
            return ((String)block).replaceFirst("minecraft:", "");
        }
        return block;
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    public boolean testEntityInternal(ETFEntity entity) {
        String[] entityBlocks;
        if (entity.etf$getUuid().getLeastSignificantBits() == 0x303900003039L) {
            entityBlocks = new String[]{BlocksProperty.getBlockFormattedFromState(Blocks.f_50085_.m_49966_())};
        } else if (entity instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)entity;
            entityBlocks = blockEntity.m_58904_() == null ? new String[]{BlocksProperty.getBlockFormattedFromState(blockEntity.m_58900_())} : new String[]{BlocksProperty.getBlockFormattedFromState(blockEntity.m_58900_()), BlocksProperty.getBlockFormattedFromState(blockEntity.m_58904_().m_8055_(blockEntity.m_58899_().m_7495_()))};
        } else {
            if (entity.etf$getWorld() == null || entity.etf$getBlockPos() == null) {
                return false;
            }
            Level world = entity.etf$getWorld();
            BlockPos pos = entity.etf$getBlockPos();
            entityBlocks = new String[]{BlocksProperty.getBlockFormattedFromState(world.m_8055_(pos)), BlocksProperty.getBlockFormattedFromState(world.m_8055_(pos.m_7495_()))};
        }
        boolean foundAMatch = false;
        for (String block : entityBlocks) {
            if (block == null) continue;
            foundAMatch = this.MATCHER.testString(block.toLowerCase());
            if (!foundAMatch) {
                boolean foundEach = true;
                block1: for (String definition : this.ARRAY) {
                    for (String partsToFind : definition.split(":")) {
                        if (block.contains(partsToFind)) continue;
                        foundEach = false;
                        continue block1;
                    }
                }
                foundAMatch = foundEach;
            }
            if (foundAMatch) break;
        }
        return foundAMatch;
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        return null;
    }

    @Override
    public boolean isPropertyUpdatable() {
        return !ETFConfig.getInstance().restrictBlock;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"blocks", "block"};
    }
}

