/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.DeactivateCamerasInHandC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CameraInHand {
    public static final CameraInHand EMPTY = new CameraInHand(null, null);
    @Nullable
    private ItemAndStack<CameraItem> camera;
    @Nullable
    private InteractionHand hand;

    public CameraInHand(@Nullable ItemAndStack<CameraItem> camera, @Nullable InteractionHand hand) {
        this.camera = camera;
        this.hand = hand;
    }

    public CameraInHand(@NotNull Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = player.m_21120_(hand);
            if (!(itemInHand.m_41720_() instanceof CameraItem)) continue;
            this.camera = new ItemAndStack(itemInHand);
            this.hand = hand;
            return;
        }
    }

    public static void deactivate(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemInHand = player.m_21120_(hand);
            Item item = itemInHand.m_41720_();
            if (!(item instanceof CameraItem)) continue;
            CameraItem cameraItem = (CameraItem)item;
            cameraItem.deactivate(player, itemInHand);
        }
        if (player.m_9236_().f_46443_) {
            Packets.sendToServer(new DeactivateCamerasInHandC2SP());
        }
    }

    @Nullable
    public static InteractionHand getActiveHand(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player should not be null.");
        for (InteractionHand hand : InteractionHand.values()) {
            CameraItem cameraItem;
            ItemStack itemInHand = player.m_21120_(hand);
            Item item = itemInHand.m_41720_();
            if (!(item instanceof CameraItem) || !(cameraItem = (CameraItem)item).isActive(itemInHand)) continue;
            return hand;
        }
        return null;
    }

    public static boolean isActive(Player player) {
        return CameraInHand.getActiveHand(player) != null;
    }

    public static CameraInHand getActive(Player player) {
        @Nullable InteractionHand activeHand = CameraInHand.getActiveHand(player);
        if (activeHand == null) {
            return EMPTY;
        }
        return new CameraInHand(new ItemAndStack<CameraItem>(player.m_21120_(activeHand)), activeHand);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY) || this.camera == null || this.hand == null;
    }

    public ItemAndStack<CameraItem> getCamera() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getCamera should not be called before checking isEmpty first.");
        return this.camera;
    }

    public CameraItem getItem() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getItem should not be called before checking isEmpty first.");
        Preconditions.checkState((this.camera != null ? 1 : 0) != 0, (Object)"getItem should not be called before checking isEmpty first.");
        return this.camera.getItem();
    }

    public ItemStack getStack() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getStack should not be called before checking isEmpty first.");
        Preconditions.checkState((this.camera != null ? 1 : 0) != 0, (Object)"getStack should not be called before checking isEmpty first.");
        return this.camera.getStack();
    }

    public InteractionHand getHand() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"getHand should not be called before checking isEmpty first.");
        return this.hand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CameraInHand that = (CameraInHand)o;
        return Objects.equals(this.camera, that.camera) && this.hand == that.hand;
    }

    public int hashCode() {
        return Objects.hash(this.camera, this.hand);
    }

    public String toString() {
        return "CameraInHand{camera=" + (this.camera != null ? this.camera.getStack() : "null") + ", hand=" + this.hand + "}";
    }
}

