/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class PhotographRenderer {
    public static void render(ItemStack stack, boolean renderPaper, boolean renderBackside, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        Item item = stack.m_41720_();
        if (item instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)item;
            PhotographRenderer.renderPhotograph(photographItem, stack, renderPaper, renderBackside, poseStack, bufferSource, packedLight, r, g, b, a);
        } else {
            item = stack.m_41720_();
            if (item instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)item;
                PhotographRenderer.renderStackedPhotographs(stackedPhotographsItem, stack, poseStack, bufferSource, packedLight, r, g, b, a);
            }
        }
    }

    public static void renderPhotograph(PhotographItem photographItem, ItemStack stack, boolean renderPaper, boolean renderBackside, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        Either<String, ResourceLocation> idOrTexture;
        PhotographRenderProperties properties = PhotographRenderProperties.get(stack);
        int size = ExposureClient.getExposureRenderer().getSize();
        if (renderPaper) {
            PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, 0.0f, 0.0f, size, size, packedLight, r, g, b, a);
            if (renderBackside) {
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_85837_((double)(-size), 0.0, -0.5);
                PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, packedLight, (int)((float)r * 0.85f), (int)((float)g * 0.85f), (int)((float)b * 0.85f), a);
                poseStack.m_85849_();
            }
        }
        if ((idOrTexture = photographItem.getIdOrTexture(stack)) != null) {
            if (renderPaper) {
                poseStack.m_85836_();
                float offset = (float)size * 0.0625f;
                poseStack.m_252880_(offset, offset, 1.0f);
                poseStack.m_85841_(0.875f, 0.875f, 0.875f);
                ExposureClient.getExposureRenderer().render(idOrTexture, properties.getModifier(), poseStack, bufferSource, packedLight, r, g, b, a);
                poseStack.m_85849_();
            } else {
                ExposureClient.getExposureRenderer().render(idOrTexture, properties.getModifier(), poseStack, bufferSource, packedLight, r, g, b, a);
            }
            if (renderPaper && properties.hasPaperOverlayTexture()) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 2.0f);
                PhotographRenderer.renderTexture(properties.getPaperOverlayTexture(), poseStack, bufferSource, packedLight, r, g, b, a);
                poseStack.m_85849_();
            }
        }
    }

    public static void renderStackedPhotographs(StackedPhotographsItem stackedPhotographsItem, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        List<ItemAndStack<PhotographItem>> photographs = stackedPhotographsItem.getPhotographs(stack, 3);
        PhotographRenderer.renderStackedPhotographs(photographs, poseStack, bufferSource, packedLight, r, g, b, a);
    }

    public static void renderStackedPhotographs(List<ItemAndStack<PhotographItem>> photographs, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        if (photographs.isEmpty()) {
            return;
        }
        for (int i = 2; i >= 0; --i) {
            if (photographs.size() - 1 < i) continue;
            ItemAndStack<PhotographItem> photograph = photographs.get(i);
            PhotographRenderProperties properties = PhotographRenderProperties.get(photograph.getStack());
            if (i == 0) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 2.0f);
                PhotographRenderer.renderPhotograph(photograph.getItem(), photograph.getStack(), true, false, poseStack, bufferSource, packedLight, r, g, b, a);
                poseStack.m_85849_();
                break;
            }
            float posOffset = PhotographRenderer.getStackedPhotographOffset() * (float)i;
            float rotateOffset = (float)ExposureClient.getExposureRenderer().getSize() / 2.0f;
            poseStack.m_85836_();
            poseStack.m_252880_(posOffset, posOffset, (float)(2 - i));
            poseStack.m_252880_(rotateOffset, rotateOffset, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(i * 90 + 90)));
            poseStack.m_252880_(-rotateOffset, -rotateOffset, 0.0f);
            float brightnessMul = 1.0f - PhotographRenderer.getStackedBrightnessStep() * (float)i;
            PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, packedLight, (int)((float)r * brightnessMul), (int)((float)g * brightnessMul), (int)((float)b * brightnessMul), a);
            poseStack.m_85849_();
        }
    }

    public static float getStackedBrightnessStep() {
        return 0.15f;
    }

    public static float getStackedPhotographOffset() {
        return (float)ExposureClient.getExposureRenderer().getSize() * 0.03125f;
    }

    private static void renderTexture(ResourceLocation resource, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int r, int g, int b, int a) {
        PhotographRenderer.renderTexture(resource, poseStack, bufferSource, 0.0f, 0.0f, ExposureClient.getExposureRenderer().getSize(), ExposureClient.getExposureRenderer().getSize(), packedLight, r, g, b, a);
    }

    private static void renderTexture(ResourceLocation resource, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float width, float height, int packedLight, int r, int g, int b, int a) {
        PhotographRenderer.renderTexture(resource, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
    }

    private static void renderTexture(ResourceLocation resource, PoseStack poseStack, MultiBufferSource bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderSystem.setShader(GameRenderer::m_172835_);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer bufferBuilder = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)resource));
        bufferBuilder.m_252986_(matrix, minX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, maxY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, maxX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_85969_(packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix, minX, minY, 0.0f).m_6122_(r, g, b, a).m_7421_(minU, minV).m_85969_(packedLight).m_5752_();
    }
}

