/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNbtTransferringRecipe
extends CustomRecipe {
    private final ItemStack result;
    private final Ingredient transferIngredient;
    private final NonNullList<Ingredient> ingredients;

    public AbstractNbtTransferringRecipe(ResourceLocation id, Ingredient transferIngredient, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, CraftingBookCategory.MISC);
        this.transferIngredient = transferIngredient;
        this.ingredients = ingredients;
        this.result = result;
    }

    @NotNull
    public Ingredient getTransferIngredient() {
        return this.transferIngredient;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getResult();
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (this.getTransferIngredient().m_43947_() || this.ingredients.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> unmatchedIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.ingredients);
        unmatchedIngredients.add(0, this.getTransferIngredient());
        int itemsInCraftingGrid = 0;
        block0: for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_41619_()) {
                ++itemsInCraftingGrid;
            }
            if (itemsInCraftingGrid > this.ingredients.size() + 1) {
                return false;
            }
            if (unmatchedIngredients.isEmpty()) continue;
            for (int j = 0; j < unmatchedIngredients.size(); ++j) {
                if (!((Ingredient)unmatchedIngredients.get(j)).test(stack)) continue;
                unmatchedIngredients.remove(j);
                continue block0;
            }
        }
        return unmatchedIngredients.isEmpty() && itemsInCraftingGrid == this.ingredients.size() + 1;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, @NotNull RegistryAccess registryAccess) {
        for (int index = 0; index < container.m_6643_(); ++index) {
            ItemStack itemStack = container.m_8020_(index);
            if (!this.getTransferIngredient().test(itemStack)) continue;
            return this.transferNbt(itemStack, this.m_8043_(registryAccess).m_41777_());
        }
        return this.m_8043_(registryAccess);
    }

    @NotNull
    public ItemStack transferNbt(ItemStack transferIngredientStack, ItemStack recipeResultStack) {
        @Nullable CompoundTag transferTag = transferIngredientStack.m_41783_();
        if (transferTag != null) {
            if (recipeResultStack.m_41783_() != null) {
                recipeResultStack.m_41783_().m_128391_(transferTag);
            } else {
                recipeResultStack.m_41751_(transferTag.m_6426_());
            }
        }
        return recipeResultStack;
    }

    public boolean m_8004_(int width, int height) {
        return this.ingredients.size() <= width * height;
    }
}

