/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.entity;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.PhotographItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographEntity
extends HangingEntity {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.m_135353_(PhotographEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> DATA_GLOWING = SynchedEntityData.m_135353_(PhotographEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.m_135353_(PhotographEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private Either<String, ResourceLocation> idOrTexture;

    public PhotographEntity(EntityType<? extends PhotographEntity> entityType, Level level) {
        super(entityType, level);
    }

    public PhotographEntity(Level level, BlockPos pos, Direction facingDirection, ItemStack photographStack) {
        super(Exposure.EntityTypes.PHOTOGRAPH.get(), level, pos);
        this.m_6022_(facingDirection);
        this.setItem(photographStack);
    }

    public boolean m_6783_(double distance) {
        double d = 16.0;
        return distance < (d *= 64.0 * PhotographEntity.m_20150_()) * d;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_GLOWING, (Object)false);
        this.m_20088_().m_135372_(DATA_ROTATION, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.getItem().m_41619_()) {
            tag.m_128365_("Item", (Tag)this.getItem().m_41739_(new CompoundTag()));
            tag.m_128379_("Glowing", this.isGlowing());
            tag.m_128344_("ItemRotation", (byte)this.getRotation());
        }
        tag.m_128344_("Facing", (byte)this.f_31699_.m_122411_());
        tag.m_128379_("Invisible", this.m_20145_());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag compoundtag = tag.m_128469_("Item");
        if (!compoundtag.m_128456_()) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (itemstack.m_41619_()) {
                LogUtils.getLogger().warn("Unable to load item from: {}", (Object)compoundtag);
            }
            this.setItem(itemstack);
            this.setGlowing(tag.m_128471_("Glowing"));
            this.setRotation(tag.m_128445_("ItemRotation"));
        }
        this.m_6022_(Direction.m_122376_((int)tag.m_128445_("Facing")));
        this.m_6842_(tag.m_128471_("Invisible"));
    }

    @Nullable
    public Either<String, ResourceLocation> getIdOrTexture() {
        return this.idOrTexture;
    }

    protected float m_6380_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 0.0f;
    }

    public int m_7076_() {
        return 16;
    }

    public int m_7068_() {
        return 16;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getItem().m_41777_();
    }

    public boolean m_7088_() {
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(this.f_31698_.m_121945_(this.f_31699_.m_122424_()));
        return (blockstate.m_280296_() || this.f_31699_.m_122434_().m_122479_() && DiodeBlock.m_52586_((BlockState)blockstate)) && this.m_9236_().m_6249_((Entity)this, this.m_20191_(), f_31697_).isEmpty();
    }

    protected void m_7087_() {
        if (this.f_31699_ == null) {
            return;
        }
        double value = 0.46875;
        double d1 = (double)this.f_31698_.m_123341_() + 0.5 - (double)this.f_31699_.m_122429_() * value;
        double d2 = (double)this.f_31698_.m_123342_() + 0.5 - (double)this.f_31699_.m_122430_() * value;
        double d3 = (double)this.f_31698_.m_123343_() + 0.5 - (double)this.f_31699_.m_122431_() * value;
        this.m_20343_(d1, d2, d3);
        double d4 = this.m_7076_();
        double d5 = this.m_7068_();
        double d6 = this.m_7076_();
        Direction.Axis directionAxis = this.f_31699_.m_122434_();
        switch (directionAxis) {
            case X: {
                d4 = 1.0;
                break;
            }
            case Y: {
                d5 = 1.0;
                break;
            }
            case Z: {
                d6 = 1.0;
            }
        }
        this.m_20011_(new AABB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6));
    }

    protected void m_6022_(@NotNull Direction facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.f_31699_ = facingDirection;
        if (facingDirection.m_122434_().m_122479_()) {
            this.m_146926_(0.0f);
            this.m_146922_(this.f_31699_.m_122416_() * 90);
        } else {
            this.m_146926_(-90 * facingDirection.m_122421_().m_122540_());
            this.m_146922_(0.0f);
        }
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_7087_();
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM);
    }

    public void setItem(ItemStack photographStack) {
        Preconditions.checkState((boolean)(photographStack.m_41720_() instanceof PhotographItem), (Object)(photographStack + " is not a PhotographItem"));
        this.m_20088_().m_135381_(DATA_ITEM, (Object)photographStack);
    }

    protected void onItemChanged(ItemStack itemStack) {
        if (!itemStack.m_41619_()) {
            itemStack.m_41636_((Entity)this);
            Item item = itemStack.m_41720_();
            if (item instanceof PhotographItem) {
                PhotographItem photographItem = (PhotographItem)item;
                this.idOrTexture = photographItem.getIdOrTexture(itemStack);
            }
        }
        this.m_7087_();
    }

    public boolean isGlowing() {
        return (Boolean)this.m_20088_().m_135370_(DATA_GLOWING);
    }

    public void setGlowing(boolean glowing) {
        this.m_20088_().m_135381_(DATA_GLOWING, (Object)glowing);
    }

    public int getRotation() {
        return (Integer)this.m_20088_().m_135370_(DATA_ROTATION);
    }

    public void setRotation(int rotation) {
        this.m_20088_().m_135381_(DATA_ROTATION, (Object)(rotation % 4));
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (!this.m_20145_() && this.canShear(itemInHand)) {
            if (!this.m_9236_().f_46443_) {
                this.m_6842_(true);
                itemInHand.m_41622_(1, (LivingEntity)player, pl -> pl.m_21190_(hand));
                this.m_5496_(SoundEvents.f_12344_, 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.2f + 0.9f);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemInHand.m_150930_(Items.f_151056_)) {
            this.setGlowing(true);
            itemInHand.m_41774_(1);
            if (!this.m_9236_().f_46443_) {
                this.m_216990_(SoundEvents.f_144153_);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_5496_(this.getRotateSound(), 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.2f + 0.9f);
            this.setRotation(this.getRotation() + 1);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canShear(ItemStack stack) {
        return PlatformHelper.canShear(stack);
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            if (!this.getItem().m_41619_() && !damageSource.m_276093_(DamageTypes.f_268565_)) {
                this.m_5553_(damageSource.m_7639_());
            }
            this.m_6074_();
            this.m_5834_();
        }
        return true;
    }

    public void m_5553_(@Nullable Entity breaker) {
        Player player;
        this.m_5496_(this.getBreakSound(), 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.3f + 0.6f);
        if (breaker instanceof Player && (player = (Player)breaker).m_7500_()) {
            return;
        }
        ItemStack itemStack = this.getItem();
        this.m_19983_(itemStack);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.isGlowing() && this.m_9236_().m_213780_().m_188501_() < 0.01f) {
            AABB bb = this.m_20191_();
            Vec3i normal = this.m_6350_().m_122436_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20182_().f_82479_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82362_() * 0.75) - bb.m_82362_() * 0.75 / 2.0), this.m_20182_().f_82480_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82376_() * 0.75) - bb.m_82376_() * 0.75 / 2.0), this.m_20182_().f_82481_ + ((double)this.m_9236_().m_213780_().m_188501_() * (bb.m_82385_() * 0.75) - bb.m_82385_() * 0.75 / 2.0), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123341_()), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123342_()), (double)(this.m_9236_().m_213780_().m_188501_() * 0.02f * (float)normal.m_123343_()));
        }
    }

    public void m_7084_() {
        this.m_5496_(this.getPlaceSound(), 1.0f, this.m_9236_().m_213780_().m_188501_() * 0.3f + 0.9f);
    }

    public SoundEvent getPlaceSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_PLACE.get();
    }

    public SoundEvent getBreakSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_BREAK.get();
    }

    public SoundEvent getRotateSound() {
        return Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get();
    }
}

