/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FocalRange(int min, int max) implements StringRepresentable
{
    public static final int ALLOWED_MIN = 10;
    public static final int ALLOWED_MAX = 300;

    public FocalRange(int min, int max) {
        Preconditions.checkArgument((10 <= min && min <= 300 ? 1 : 0) != 0, (Object)(min + " is not in allowed range for 'min'."));
        Preconditions.checkArgument((10 <= max && max <= 300 ? 1 : 0) != 0, (Object)(max + " is not in allowed range for 'max'."));
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)("'min' should not be larger than 'max'." + this));
        this.min = min;
        this.max = max;
    }

    public boolean isPrime() {
        return this.min == this.max;
    }

    public static FocalRange fromStack(ItemStack stack) {
        if (!stack.m_204117_(Exposure.Tags.Items.LENSES)) {
            LogUtils.getLogger().error(stack + " is not a valid lens. Should have 'exposure:lenses' tag.");
            return FocalRange.getDefault();
        }
        @Nullable FocalRange focalRange = Config.Common.CAMERA_LENSES.get(stack.m_41720_());
        if (focalRange == null) {
            LogUtils.getLogger().error(stack + " does not have known FocalRange value in config.");
            return FocalRange.getDefault();
        }
        return focalRange;
    }

    @NotNull
    public static FocalRange getDefault() {
        return FocalRange.parse((String)Config.Common.CAMERA_DEFAULT_FOCAL_RANGE.get());
    }

    @NotNull
    public String m_7912_() {
        return this.isPrime() ? Integer.toString(this.min) : this.min + "-" + this.max;
    }

    public static FocalRange parse(String value) {
        int dashIndex = value.indexOf("-");
        if (dashIndex == -1) {
            int prime = Integer.parseInt(value);
            return new FocalRange(prime, prime);
        }
        int min = Integer.parseInt(value.substring(0, dashIndex));
        int max = Integer.parseInt(value.substring(dashIndex + 1));
        return new FocalRange(min, max);
    }
}

