/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class EntityInFramePredicate {
    public static final EntityInFramePredicate ANY = new EntityInFramePredicate(null, LocationPredicate.f_52592_, MinMaxBounds.Doubles.f_154779_);
    @Nullable
    private final String id;
    private final LocationPredicate location;
    private final MinMaxBounds.Doubles distance;

    public EntityInFramePredicate(@Nullable ResourceLocation id, LocationPredicate location, MinMaxBounds.Doubles distance) {
        this.id = id != null ? id.toString() : null;
        this.location = location;
        this.distance = distance;
    }

    public boolean matches(ServerPlayer player, CompoundTag entityInfoTag) {
        if (this.equals(ANY)) {
            return true;
        }
        if (this.id != null && !this.id.equals(entityInfoTag.m_128461_("Id"))) {
            return false;
        }
        if (!this.locationMatches(player, entityInfoTag)) {
            return false;
        }
        return this.distance.m_154810_((double)entityInfoTag.m_128457_("Distance"));
    }

    private boolean locationMatches(ServerPlayer player, CompoundTag entityInfoTag) {
        ListTag posList = entityInfoTag.m_128437_("Pos", 3);
        if (posList.size() < 3) {
            return false;
        }
        int x = posList.m_128763_(0);
        int y = posList.m_128763_(1);
        int z = posList.m_128763_(2);
        return this.location.m_52617_(player.m_284548_(), (double)x, (double)y, (double)z);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        if (this.id != null) {
            json.addProperty("id", this.id);
        }
        if (!this.location.equals(LocationPredicate.f_52592_)) {
            json.add("location", this.location.m_52616_());
        }
        if (!this.distance.m_55327_()) {
            json.add("distance", this.distance.m_55328_());
        }
        return json;
    }

    public static EntityInFramePredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"entity");
        String id = null;
        if (jsonobject.has("id")) {
            id = jsonobject.get("id").getAsString();
        }
        LocationPredicate location = LocationPredicate.m_52629_((JsonElement)jsonobject.getAsJsonObject("location"));
        MinMaxBounds.Doubles distance = MinMaxBounds.Doubles.m_154791_((JsonElement)jsonobject.getAsJsonObject("distance"));
        return new EntityInFramePredicate(id != null ? new ResourceLocation(id) : null, location, distance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityInFramePredicate that = (EntityInFramePredicate)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.location, that.location) && Objects.equals(this.distance, that.distance);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.location, this.distance);
    }
}

