/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldsave.mixin;

import com.fastasyncworldsave.FastAsyncWorldSave;
import com.fastasyncworldsave.ISaveData;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.saveddata.SavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SavedData.class})
public class SavedDataMixin
implements ISaveData {
    @Unique
    private CompoundTag toSave = null;

    @Override
    public void setToSave(CompoundTag tag) {
        this.toSave = tag;
    }

    @Redirect(method={"save(Ljava/io/File;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/saveddata/SavedData;save(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"))
    private CompoundTag skipSer(SavedData instance, CompoundTag compoundTag) {
        if (this.toSave != null) {
            return compoundTag;
        }
        return instance.m_7176_(compoundTag);
    }

    @Redirect(method={"save(Ljava/io/File;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtIo;writeCompressed(Lnet/minecraft/nbt/CompoundTag;Ljava/io/File;)V"))
    private void doSave(CompoundTag compoundTag, File file) {
        if (this.toSave != null) {
            try {
                NbtIo.m_128944_((CompoundTag)this.toSave, (File)file);
            }
            catch (IOException var4) {
                FastAsyncWorldSave.LOGGER.error("Could not save data {}", (Object)this, (Object)var4);
            }
            this.toSave = null;
        } else {
            try {
                NbtIo.m_128944_((CompoundTag)compoundTag, (File)file);
            }
            catch (IOException var4) {
                FastAsyncWorldSave.LOGGER.error("Could not save data {}", (Object)this, (Object)var4);
            }
        }
    }
}

