/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.mixin.copyEntity.shadows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.coderbot.iris.compat.sodium.impl.vertex_format.entity_xhfp.EntityVertex;
import net.coderbot.iris.vertices.ImmediateState;
import net.coderbot.iris.vertices.NormI8;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityRenderDispatcher.class})
public class EntityRenderDispatcherMixin {
    @Unique
    private static final int SHADOW_COLOR = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f);

    @Overwrite
    private static void m_277056_(PoseStack.Pose entry, VertexConsumer vertices, ChunkAccess chunk, LevelReader world, BlockPos pos, double x, double y, double z, float radius, float opacity) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60838_((BlockGetter)world, blockPos)) {
            return;
        }
        int light = world.m_46803_(pos);
        if (light <= 3) {
            return;
        }
        VoxelShape voxelShape = blockState.m_60808_((BlockGetter)world, blockPos);
        if (voxelShape.m_83281_()) {
            return;
        }
        float brightness = LightTexture.m_234316_((DimensionType)world.m_6042_(), (int)light);
        float alpha = (float)(((double)opacity - (y - (double)pos.m_123342_()) / 2.0) * 0.5 * (double)brightness);
        if (alpha >= 0.0f) {
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            AABB box = voxelShape.m_83215_();
            float minX = (float)((double)pos.m_123341_() + box.f_82288_ - x);
            float maxX = (float)((double)pos.m_123341_() + box.f_82291_ - x);
            float minY = (float)((double)pos.m_123342_() + box.f_82289_ - y);
            float minZ = (float)((double)pos.m_123343_() + box.f_82290_ - z);
            float maxZ = (float)((double)pos.m_123343_() + box.f_82293_ - z);
            EntityRenderDispatcherMixin.renderShadowPart(entry, vertices, radius, alpha, minX, maxX, minY, minZ, maxZ);
        }
    }

    @Unique
    private static void renderShadowPart(PoseStack.Pose matrices, VertexConsumer vertices, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        Matrix3f matNormal = matrices.m_252943_();
        Matrix4f matPosition = matrices.m_252922_();
        int color = ColorABGR.withAlpha((int)SHADOW_COLOR, (float)alpha);
        int normal = MatrixHelper.transformNormal((Matrix3f)matNormal, (float)0.0f, (float)1.0f, (float)0.0f);
        boolean extended = EntityRenderDispatcherMixin.shouldBeExtended();
        int tangent = 0;
        if (extended) {
            tangent = EntityRenderDispatcherMixin.getTangent(normal, minX, minY, minZ, u1, v1, minX, minY, maxZ, u1, v2, maxX, minY, maxZ, u2, v2);
        }
        float midU = (u1 + u2) / 2.0f;
        float midV = (v1 + v2) / 2.0f;
        int stride = extended ? EntityVertex.STRIDE : 36;
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(4 * stride);
            if (extended) {
                EntityRenderDispatcherMixin.writeShadowVertexIris(ptr, matPosition, minX, minY, minZ, u1, v1, color, midU, midV, normal, tangent);
                EntityRenderDispatcherMixin.writeShadowVertexIris(ptr += (long)stride, matPosition, minX, minY, maxZ, u1, v2, color, midU, midV, normal, tangent);
                EntityRenderDispatcherMixin.writeShadowVertexIris(ptr += (long)stride, matPosition, maxX, minY, maxZ, u2, v2, color, midU, midV, normal, tangent);
                EntityRenderDispatcherMixin.writeShadowVertexIris(ptr += (long)stride, matPosition, maxX, minY, minZ, u2, v1, color, midU, midV, normal, tangent);
                ptr += (long)stride;
            } else {
                EntityRenderDispatcherMixin.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
                EntityRenderDispatcherMixin.writeShadowVertex(ptr += (long)stride, matPosition, minX, minY, maxZ, u1, v2, color, normal);
                EntityRenderDispatcherMixin.writeShadowVertex(ptr += (long)stride, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
                EntityRenderDispatcherMixin.writeShadowVertex(ptr += (long)stride, matPosition, maxX, minY, minZ, u2, v1, color, normal);
                ptr += (long)stride;
            }
            VertexBufferWriter.of((VertexConsumer)vertices).push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    @Unique
    private static void writeShadowVertex(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        ModelVertex.write((long)ptr, (float)xt, (float)yt, (float)zt, (int)color, (float)u, (float)v, (int)0xF000F0, (int)OverlayTexture.f_118083_, (int)normal);
    }

    @Unique
    private static void writeShadowVertexIris(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, float midU, float midV, int normal, int tangent) {
        float xt = MatrixHelper.transformPositionX((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        float yt = MatrixHelper.transformPositionY((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        float zt = MatrixHelper.transformPositionZ((Matrix4f)matPosition, (float)x, (float)y, (float)z);
        EntityVertex.write(ptr, xt, yt, zt, color, u, v, midU, midV, OverlayTexture.f_118083_, 0xF000F0, normal, tangent);
    }

    private static boolean shouldBeExtended() {
        return IrisApi.getInstance().isShaderPackInUse() && ImmediateState.renderWithExtendedVertexFormat;
    }

    private static int getTangent(int normal, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2) {
        float normalX = NormI8.unpackX(normal);
        float normalY = NormI8.unpackY(normal);
        float normalZ = NormI8.unpackZ(normal);
        float edge1x = x1 - x0;
        float edge1y = y1 - y0;
        float edge1z = z1 - z0;
        float edge2x = x2 - x0;
        float edge2y = y2 - y0;
        float edge2z = z2 - z0;
        float deltaU1 = u1 - u0;
        float deltaV2 = v2 - v0;
        float deltaU2 = u2 - u0;
        float deltaV1 = v1 - v0;
        float fdenom = deltaU1 * deltaV2 - deltaU2 * deltaV1;
        float f = (double)fdenom == 0.0 ? 1.0f : 1.0f / fdenom;
        float tangentx = f * (deltaV2 * edge1x - deltaV1 * edge2x);
        float tangenty = f * (deltaV2 * edge1y - deltaV1 * edge2y);
        float tangentz = f * (deltaV2 * edge1z - deltaV1 * edge2z);
        float tcoeff = EntityRenderDispatcherMixin.rsqrt(tangentx * tangentx + tangenty * tangenty + tangentz * tangentz);
        tangentx *= tcoeff;
        tangenty *= tcoeff;
        float bitangentx = f * (-deltaU2 * edge1x + deltaU1 * edge2x);
        float bitangenty = f * (-deltaU2 * edge1y + deltaU1 * edge2y);
        float bitangentz = f * (-deltaU2 * edge1z + deltaU1 * edge2z);
        float bitcoeff = EntityRenderDispatcherMixin.rsqrt(bitangentx * bitangentx + bitangenty * bitangenty + bitangentz * bitangentz);
        float pbitangentx = tangenty * normalZ - (tangentz *= tcoeff) * normalY;
        float pbitangenty = tangentz * normalX - tangentx * normalZ;
        float pbitangentz = tangentx * normalY - tangenty * normalX;
        float dot = (bitangentx *= bitcoeff) * pbitangentx + (bitangenty *= bitcoeff) * pbitangenty + (bitangentz *= bitcoeff) * pbitangentz;
        float tangentW = dot < 0.0f ? -1.0f : 1.0f;
        return NormI8.pack(tangentx, tangenty, tangentz, tangentW);
    }

    private static float rsqrt(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(value));
    }
}

