/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.forge;

import net.mehvahdjukaar.goated.Goated;
import net.mehvahdjukaar.goated.GoatedClient;
import net.mehvahdjukaar.goated.forge.RamBreakingCap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod(value="goated")
public class GoatedForge {
    public static final Capability<RamBreakingCap> RAM_BREAK_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<RamBreakingCap>(){});

    public GoatedForge() {
        Goated.commonInit();
        if (PlatHelper.getPhysicalSide().isClient()) {
            GoatedClient.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(GoatedForge::setup);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(Goated::commonSetup);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(RamBreakingCap.class);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Level> event) {
        Object object = event.getObject();
        if (object instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            RamBreakingCap capability = new RamBreakingCap(serverLevel);
            event.addCapability(Goated.res("ram_break_progress"), (ICapabilityProvider)capability);
            event.addListener(capability::invalidate);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tickEvent(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.getCapability(RAM_BREAK_CAP).ifPresent(RamBreakingCap::validateAll);
        }
    }

    @SubscribeEvent
    public void onRemapBlocks(MissingMappingsEvent event) {
        String name;
        for (MissingMappingsEvent.Mapping v : event.getMappings(ForgeRegistries.BLOCKS.getRegistryKey(), "ohmygoat")) {
            name = v.getKey().m_135815_();
            if (!name.equals("ram_block")) continue;
            v.remap((Object)Goated.RAM_BLOCK.get());
        }
        for (MissingMappingsEvent.Mapping v : event.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), "ohmygoat")) {
            switch (name = v.getKey().m_135815_()) {
                case "ram_block": {
                    v.remap((Object)Goated.RAM_BLOCK.get().m_5456_());
                    break;
                }
                case "chevon": {
                    v.remap((Object)Goated.RAW_CHEVON.get().m_5456_());
                    break;
                }
                case "cooked_chevon": {
                    v.remap((Object)Goated.COOKED_CHEVON.get().m_5456_());
                    break;
                }
                case "barbaric_helmet": {
                    v.remap((Object)Goated.BARBARIC_HELMET.get().m_5456_());
                    break;
                }
                case "geep_spawn_egg": {
                    v.remap((Object)Goated.GEEP_SPAWN_EGG.get().m_5456_());
                }
            }
        }
        for (MissingMappingsEvent.Mapping v : event.getMappings(ForgeRegistries.ENTITY_TYPES.getRegistryKey(), "ohmygoat")) {
            name = v.getKey().m_135815_();
            if (!name.equals("geep")) continue;
            v.remap(Goated.GEEP.get());
        }
    }
}

