/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.api.CDTags;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import io.github.fabricators_of_create.porting_lib.models.generators.item.ItemModelBuilder;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class Windows {
    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.m_60922_(Windows::never).m_60924_(Windows::never).m_60960_(Windows::never).m_60971_(Windows::never);
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static Boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static BlockEntry<WindowBlock> metalWindowBlock(String metal) {
        return Windows.metalWindowBlock(metal, () -> RenderType::m_110457_, false);
    }

    public static BlockEntry<WindowBlock> metalWindowBlock(String metal, Supplier<Supplier<RenderType>> renderType, boolean translucent) {
        String name = metal + "_window";
        NonNullFunction end_texture = $ -> CreateDecoMod.id(Windows.palettesDir() + $);
        NonNullFunction side_texture = n -> CreateDecoMod.id(Windows.palettesDir() + n);
        return Windows.windowBlock(name, () -> SpriteShifts.METAL_WINDOWS.get(metal), renderType, translucent, (NonNullFunction<String, ResourceLocation>)end_texture, (NonNullFunction<String, ResourceLocation>)side_texture, () -> ((Block)Blocks.f_50058_).m_284356_());
    }

    public static BlockEntry<WindowBlock> windowBlock(String name, Supplier<CTSpriteShiftEntry> ct, Supplier<Supplier<RenderType>> renderType, boolean translucent, NonNullFunction<String, ResourceLocation> endTexture, NonNullFunction<String, ResourceLocation> sideTexture, Supplier<MapColor> color) {
        return ((BlockBuilder)CreateDecoMod.REGISTRATE.block(name.toLowerCase(Locale.ROOT).replace(" ", "_"), p -> new WindowBlock(p, translucent)).onRegister(CreateRegistrate.connectedTextures(() -> new HorizontalCTBehaviour(SpriteShifts.METAL_WINDOWS.get(name.replace("_window", "")))))).addLayer(renderType).recipe((c, p) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).m_126130_(" # ").m_126130_("#X#").m_126124_(Character.valueOf('#'), Ingredient.m_204132_(CDTags.of((String)name.replace((CharSequence)"_window", (CharSequence)""), (String)"ingots").tag)).m_126124_(Character.valueOf('X'), (Ingredient)DataIngredient.tag(CDTags.GLASS_ITEM.tag)).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(CDTags.of((String)name.replace((CharSequence)"_window", (CharSequence)""), (String)"ingots").tag).m_45077_()})).m_176498_(arg_0 -> ((RegistrateRecipeProvider)p).accept(arg_0))).initialProperties(() -> Blocks.f_50058_).properties(Windows::glassProperties).properties(p -> p.m_284180_((MapColor)color.get())).loot((t, g) -> t.m_245644_((Block)g)).blockstate((ctx, prov) -> BlockStateGenerator.window(ctx, prov, sideTexture, endTexture)).tag(new TagKey[]{BlockTags.f_13049_}).simpleItem().register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> metalWindowPane(String metal, Supplier<? extends Block> parent) {
        return Windows.metalWindowPane(metal, parent, () -> RenderType::m_110457_);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> metalWindowPane(String metal, Supplier<? extends Block> parent, Supplier<Supplier<RenderType>> renderType) {
        String name = metal.toLowerCase().replace(" ", "_") + "_window";
        ResourceLocation topTexture = CreateDecoMod.id(Windows.palettesDir() + name + "_end");
        ResourceLocation sideTexture = CreateDecoMod.id(Windows.palettesDir() + name);
        return Windows.connectedGlassPane(name, parent, () -> SpriteShifts.METAL_WINDOWS.get(metal), sideTexture, sideTexture, topTexture, renderType);
    }

    private static BlockEntry<ConnectedGlassPaneBlock> connectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, ResourceLocation sideTexture, ResourceLocation itemSideTexture, ResourceLocation topTexture, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        String CGPparents = "block/connected_glass_pane/";
        String prefix = name + "_pane_";
        return Windows.glassPane(name, parent, itemSideTexture, topTexture, ConnectedGlassPaneBlock::new, renderType, connectedTextures, BlockStateGenerator.windowPane(CGPparents, prefix, sideTexture, topTexture));
    }

    private static <G extends GlassPaneBlock> BlockEntry<G> glassPane(String name, Supplier<? extends Block> parent, ResourceLocation sideTexture, ResourceLocation topTexture, NonNullFunction<BlockBehaviour.Properties, G> factory, Supplier<Supplier<RenderType>> renderType, NonNullConsumer<? super G> connectedTextures, NonNullBiConsumer<DataGenContext<Block, G>, RegistrateBlockstateProvider> stateProvider) {
        name = (String)name + "_pane";
        return ((BlockBuilder)((BlockBuilder)CreateDecoMod.REGISTRATE.block((String)name, factory).onRegister(connectedTextures)).addLayer(renderType).initialProperties(() -> Blocks.f_50185_).properties(p -> p.m_284180_(((Block)parent.get()).m_284356_())).blockstate(stateProvider).recipe((c, p) -> ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)16).m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), (ItemLike)parent.get()).m_126132_("has_ingredient", (CriterionTriggerInstance)RegistrateRecipeProvider.has((ItemLike)((ItemLike)parent.get()))).m_176498_(arg_0 -> ((RegistrateRecipeProvider)p).accept(arg_0))).loot((t, g) -> t.m_245644_((Block)g)).item().model((c, p) -> ((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), CreateDecoMod.id("item/pane"))).texture("pane", sideTexture)).texture("edge", topTexture)).build()).register();
    }

    private static String palettesDir() {
        return "block/palettes/windows/";
    }
}

