/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.level.block.entity;

import com.mrcrayfish.goldenhopper.items.wrapper.GoldenHopperItemHandler;
import com.mrcrayfish.goldenhopper.util.ItemHandlerHelper;
import com.mrcrayfish.goldenhopper.world.level.block.entity.AbstractHopperBlockEntity;
import com.mrcrayfish.goldenhopper.world.level.block.entity.GoldenHopperBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeGoldenHopperBlockEntity
extends GoldenHopperBlockEntity {
    public ForgeGoldenHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    protected IItemHandler createUnSidedHandler() {
        return new GoldenHopperItemHandler(this);
    }

    @Override
    protected boolean pushItems(Level level, BlockPos pos, BlockState state) {
        return this.pushItemsToHandler(level, state) || super.pushItems(level, pos, state);
    }

    private boolean pushItemsToHandler(Level level, BlockState state) {
        return this.getFacingItemHandler(level, state).map(pair -> {
            IItemHandler handler = (IItemHandler)pair.getKey();
            if (ItemHandlerHelper.isFull(handler)) {
                return false;
            }
            Object value = pair.getValue();
            for (int index : this.getTransferableSlots()) {
                ItemStack stack = this.m_8020_(index);
                if (stack.m_41619_()) continue;
                ItemStack copyStack = stack.m_41777_();
                ItemStack insertStack = this.m_7407_(index, 1);
                ItemStack resultStack = this.attemptMoveStackToHandler(this, value, handler, insertStack);
                if (resultStack.m_41619_()) {
                    return true;
                }
                this.m_6836_(index, copyStack);
            }
            return false;
        }).orElse(false);
    }

    private ItemStack attemptMoveStackToHandler(AbstractHopperBlockEntity sourceHopper, Object target, IItemHandler handler, ItemStack stack) {
        for (int slotIndex = 0; slotIndex < handler.getSlots() && !stack.m_41619_(); ++slotIndex) {
            stack = this.insertStackToHandler(sourceHopper, target, handler, stack, slotIndex);
        }
        return stack;
    }

    private ItemStack insertStackToHandler(AbstractHopperBlockEntity sourceHopper, Object target, IItemHandler handler, ItemStack stack, int slotIndex) {
        if (handler.insertItem(slotIndex, stack, true).m_41619_()) {
            boolean movedItem = false;
            boolean targetWasEmpty = ItemHandlerHelper.isEmpty(handler);
            ItemStack targetStack = handler.getStackInSlot(slotIndex);
            if (targetStack.m_41619_()) {
                handler.insertItem(slotIndex, stack, false);
                stack = ItemStack.f_41583_;
                movedItem = true;
            } else if (net.minecraftforge.items.ItemHandlerHelper.canItemStacksStack((ItemStack)targetStack, (ItemStack)stack)) {
                int originalSize = stack.m_41613_();
                boolean bl = movedItem = originalSize < (stack = handler.insertItem(slotIndex, stack, false)).m_41613_();
            }
            if (movedItem && targetWasEmpty) {
                AbstractHopperBlockEntity targetHopper;
                HopperBlockEntity targetHopper2;
                if (target instanceof HopperBlockEntity && !(targetHopper2 = (HopperBlockEntity)target).m_59409_()) {
                    int cooldown = targetHopper2.getLastUpdateTime() >= sourceHopper.getLastUpdateTime() ? 1 : 0;
                    targetHopper2.m_59395_(8 - cooldown);
                } else if (target instanceof AbstractHopperBlockEntity && !(targetHopper = (AbstractHopperBlockEntity)((Object)target)).isCustomCooldown()) {
                    int cooldown = targetHopper.getLastUpdateTime() >= sourceHopper.getLastUpdateTime() ? 1 : 0;
                    targetHopper.setTransferCooldown(targetHopper.transferSpeed - cooldown);
                }
            }
        }
        return stack;
    }

    private Optional<Pair<IItemHandler, Object>> getFacingItemHandler(Level level, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61373_);
        double x = this.m_6343_() + (double)direction.m_122429_();
        double y = this.m_6358_() + (double)direction.m_122430_();
        double z = this.m_6446_() + (double)direction.m_122431_();
        return VanillaInventoryCodeHooks.getItemHandler((Level)level, (double)x, (double)y, (double)z, (Direction)direction.m_122424_());
    }
}

