/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.world.level.block;

import com.mrcrayfish.goldenhopper.platform.Services;
import com.mrcrayfish.goldenhopper.world.level.block.entity.AbstractHopperBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractHopperBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HopperBlock.f_54021_;
    public static final BooleanProperty ENABLED = HopperBlock.f_54022_;

    public AbstractHopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)ENABLED, (Comparable)Boolean.TRUE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return ((HopperBlock)Blocks.f_50332_).m_5940_(state, getter, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter getter, BlockPos pos) {
        return ((HopperBlock)Blocks.f_50332_).m_6079_(state, getter, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(direction.m_122434_() == Direction.Axis.Y ? Direction.DOWN : direction))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity blockEntity2 = (AbstractHopperBlockEntity)blockEntity;
            blockEntity2.m_58638_(stack.m_41786_());
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_()) {
            this.updateState(level, pos, state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity blockEntity2 = (AbstractHopperBlockEntity)blockEntity;
            Services.PLATFORM.openScreen((ServerPlayer)player, (MenuProvider)blockEntity2);
            player.m_36220_(Stats.f_12957_);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(level, pos, state);
    }

    private void updateState(Level level, BlockPos pos, BlockState state) {
        boolean noSignal;
        boolean bl = noSignal = !level.m_276867_(pos);
        if (noSignal != (Boolean)state.m_61143_((Property)ENABLED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(noSignal)), 4);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractHopperBlockEntity) {
                AbstractHopperBlockEntity blockEntity2 = (AbstractHopperBlockEntity)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)blockEntity2);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED});
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity hopper = (AbstractHopperBlockEntity)blockEntity;
            hopper.onEntityCollide(level, pos, state, entity);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    protected abstract BlockEntityType<? extends AbstractHopperBlockEntity> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractHopperBlock.createAbstractHopperTicker(level, type, this.getBlockEntityType());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createAbstractHopperTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends AbstractHopperBlockEntity> blockEntityType) {
        return level.f_46443_ ? null : AbstractHopperBlock.m_152132_(type, blockEntityType, AbstractHopperBlockEntity::serverTick);
    }
}

