/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.util;

import com.mrcrayfish.goldenhopper.platform.Services;
import com.mrcrayfish.goldenhopper.world.level.block.entity.AbstractHopperBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.HopperBlockEntity;

public class HopperHelper {
    public static int getTransferCooldown(Container container) {
        if (container instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity hopper = (AbstractHopperBlockEntity)container;
            return hopper.getTransferSpeed();
        }
        return 8;
    }

    public static void setCooldown(Container container, int time) {
        if (container instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)container;
            Services.PLATFORM.setHopperCooldown(hopper, time);
        } else if (container instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity hopper = (AbstractHopperBlockEntity)container;
            hopper.setTransferCooldown(time);
        }
    }

    public static long getLastUpdate(Container container) {
        if (container instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)container;
            return Services.PLATFORM.getHopperLastGameTime(hopper);
        }
        if (container instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity hopper = (AbstractHopperBlockEntity)container;
            return hopper.getLastUpdateTime();
        }
        return -1L;
    }

    public static boolean isOnCustomCooldown(Container container) {
        if (container instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)container;
            return Services.PLATFORM.isHopperOnCustomCooldown(hopper);
        }
        if (container instanceof AbstractHopperBlockEntity) {
            AbstractHopperBlockEntity hopper = (AbstractHopperBlockEntity)container;
            return hopper.isCustomCooldown();
        }
        return true;
    }
}

