/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.orcinus.galosphere.init.GBlocks;

public class LichenMushroomFeature
extends Feature<NoneFeatureConfiguration> {
    public LichenMushroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        int radius = Mth.m_216271_((RandomSource)random, (int)2, (int)4);
        int height = radius * 2;
        int tries = 0;
        HashSet set = Sets.newHashSet();
        return !this.generateLichenMushroom(world, blockPos, random, radius, height, set, tries);
    }

    private boolean generateLichenMushroom(WorldGenLevel world, BlockPos blockPos, RandomSource random, int radius, int stemHeight, HashSet<BlockPos> set, int tries) {
        for (int checkx = -radius; checkx <= radius; ++checkx) {
            for (int checkz = -radius; checkz <= radius; ++checkz) {
                boolean flag = checkx == -radius || checkx == radius;
                boolean flag1 = checkz == -radius || checkz == radius;
                boolean flag2 = flag && flag1;
                BlockPos checkpos = new BlockPos(blockPos.m_123341_() + checkx, blockPos.m_123342_() - 1, blockPos.m_123343_() + checkz);
                if (!world.m_46859_(checkpos) && world.m_6425_(checkpos).m_76178_() || flag2) continue;
                if (++tries < 5) {
                    return this.generateLichenMushroom(world, blockPos.m_7495_(), random, radius, stemHeight, set, tries);
                }
                return false;
            }
        }
        LichenMushroomFeature.generateHugeLichenMushroom(world, blockPos, random, radius, stemHeight, set);
        return false;
    }

    public static boolean generateHugeLichenMushroom(WorldGenLevel world, BlockPos blockPos, RandomSource random, int radius, int stemHeight, HashSet<BlockPos> set) {
        if (!LichenMushroomFeature.checkAirExposure((LevelAccessor)world, blockPos, stemHeight)) {
            return false;
        }
        if (radius == 1) {
            LichenMushroomFeature.generateUnqiueLichenMushroom(world, blockPos, set);
        } else {
            LichenMushroomFeature.generateDefaultLichenMushroom(world, blockPos, radius, stemHeight, set);
        }
        set.forEach(mossPos -> {
            Direction randomDir;
            Direction direction;
            if (random.m_188503_(3) == 0 && world.m_7433_(mossPos.m_7494_(), DripstoneUtils::m_159664_)) {
                Block block = random.m_188499_() ? (Block)GBlocks.BOWL_LICHEN.get() : (Block)GBlocks.LICHEN_ROOTS.get();
                world.m_7731_(mossPos.m_7494_(), (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_8055_(mossPos.m_7494_()).m_60713_(Blocks.f_49990_))), 2);
            }
            if (world.m_7433_(mossPos.m_121945_(direction = Direction.Plane.HORIZONTAL.m_235690_(random)), LichenMushroomFeature::canGenerate) && random.m_188503_(3) == 0) {
                world.m_7731_(mossPos.m_121945_(direction), (BlockState)((BlockState)((Block)GBlocks.LICHEN_SHELF.get()).m_49966_().m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction)).m_61124_((Property)BaseCoralWallFanBlock.f_49158_, (Comparable)Boolean.valueOf(world.m_6425_(mossPos.m_121945_(direction)).m_205070_(FluidTags.f_13131_))), 2);
            }
            if (world.m_7433_(mossPos.m_121945_(randomDir = Direction.m_235672_((RandomSource)random)), LichenMushroomFeature::canGenerate) && random.m_188503_(3) == 0) {
                world.m_7731_(mossPos.m_121945_(randomDir), (BlockState)((BlockState)Blocks.f_152475_.m_49966_().m_61124_((Property)GlowLichenBlock.m_153933_((Direction)randomDir.m_122424_()), (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(mossPos.m_121945_(randomDir)).m_205070_(FluidTags.f_13131_))), 2);
            }
        });
        return true;
    }

    private static void generateUnqiueLichenMushroom(WorldGenLevel world, BlockPos blockPos, HashSet<BlockPos> set) {
        int z;
        int x;
        int stemRadius = 1;
        int capRadius = 2;
        int radiusOneHeight = 3;
        for (x = -stemRadius; x <= stemRadius; ++x) {
            for (z = -stemRadius; z <= stemRadius; ++z) {
                BlockPos generatePos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_(), blockPos.m_123343_() + z);
                for (int y = 0; y < radiusOneHeight; ++y) {
                    boolean flag1;
                    BlockPos pos = generatePos.m_6630_(y);
                    boolean flag = x == stemRadius || x == -stemRadius;
                    boolean bl = flag1 = z == stemRadius || z == -stemRadius;
                    if (y != 1 ? y == 2 && (flag || flag1) : flag && flag1) continue;
                    if (!world.m_7433_(pos, LichenMushroomFeature::canGenerate)) continue;
                    world.m_7731_(pos, Blocks.f_50182_.m_49966_(), 2);
                }
                BlockPos capPos = generatePos.m_6630_(radiusOneHeight);
                if (!world.m_7433_(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.m_7731_(capPos, ((Block)GBlocks.LICHEN_MOSS.get()).m_49966_(), 2);
                set.add(capPos);
            }
        }
        for (x = -capRadius; x <= capRadius; ++x) {
            for (z = -capRadius; z <= capRadius; ++z) {
                boolean flag;
                BlockPos capPos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + radiusOneHeight + 1, blockPos.m_123343_() + z);
                boolean bl = flag = !(x != capRadius && x != -capRadius || z != capRadius && z != -capRadius);
                if (flag || x * x + z * z <= 1 || !world.m_7433_(capPos, LichenMushroomFeature::canGenerate)) continue;
                world.m_7731_(capPos, ((Block)GBlocks.LICHEN_MOSS.get()).m_49966_(), 2);
                set.add(capPos);
            }
        }
    }

    private static boolean canGenerate(BlockState state) {
        return state.m_247087_() || state.m_60795_() || state.m_60713_(Blocks.f_49990_) || state.m_60713_((Block)GBlocks.BOWL_LICHEN.get());
    }

    private static void generateDefaultLichenMushroom(WorldGenLevel world, BlockPos blockPos, int radius, int stemHeight, HashSet<BlockPos> set) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < stemHeight; ++y) {
                    boolean flag2;
                    BlockPos pos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    int f4 = 4 * radius;
                    boolean flag = x == -radius || x == radius;
                    boolean flag1 = z == -radius || z == radius;
                    boolean bl = flag2 = y == 0 && flag && flag1;
                    if (!((double)(x * x) + 2.0 * (Math.log(y * y) * (double)f4) / (double)f4 + (double)(z * z) <= (double)(radius * radius)) || flag2) continue;
                    if (world.m_7433_(pos, LichenMushroomFeature::canGenerate)) {
                        world.m_7731_(pos, Blocks.f_50182_.m_49966_(), 2);
                    }
                    for (int xMossRadius = -radius * 2; xMossRadius <= radius * 2; ++xMossRadius) {
                        for (int zMossRadius = -radius * 2; zMossRadius <= radius * 2; ++zMossRadius) {
                            BlockPos mossPos = new BlockPos(blockPos.m_123341_() + xMossRadius, blockPos.m_123342_() + stemHeight - 1, blockPos.m_123343_() + zMossRadius);
                            int distance = xMossRadius * xMossRadius + zMossRadius * zMossRadius;
                            if (distance < radius * 4) {
                                if (!world.m_7433_(mossPos, LichenMushroomFeature::canGenerate)) continue;
                                world.m_7731_(mossPos, ((Block)GBlocks.LICHEN_MOSS.get()).m_49966_(), 2);
                                set.add(mossPos);
                                continue;
                            }
                            if (distance > radius * 8 || distance < radius * 4 || !world.m_7433_(mossPos.m_7494_(), LichenMushroomFeature::canGenerate)) continue;
                            world.m_7731_(mossPos.m_7494_(), ((Block)GBlocks.LICHEN_MOSS.get()).m_49966_(), 2);
                            set.add(mossPos.m_7494_());
                        }
                    }
                }
            }
        }
    }

    public static boolean checkAirExposure(LevelAccessor world, BlockPos blockPos, int height) {
        for (int y = 0; y < height; ++y) {
            if (!world.m_7433_(blockPos.m_6630_(y), LichenMushroomFeature::canGenerate)) continue;
            return true;
        }
        return false;
    }
}

