/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.blocks.MonstrometerBlock;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ImpactParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public ImpactParticle(ClientLevel clientLevel, double d, double e, double f, SpriteSet sprites) {
        super(clientLevel, d, e, f);
        this.f_107230_ = 0.8f;
        this.f_107663_ = 1.3f;
        this.f_107225_ = 48;
        this.sprites = sprites;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.m_108339_(sprites);
    }

    public void m_5989_() {
        this.f_107663_ = Mth.m_14179_((float)0.25f, (float)this.f_107663_, (float)6.0f);
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107230_ = Mth.m_14179_((float)0.08f, (float)this.f_107230_, (float)0.0f);
        }
        if (this.f_107230_ <= 0.01f) {
            this.m_107274_();
        }
        this.m_108339_(this.sprites);
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float delta) {
        this.renderParticle(consumer, camera, delta, Axis.f_252529_.m_252961_(1.5707964f));
        this.renderParticle(consumer, camera, delta, Axis.f_252495_.m_252961_(1.5707964f));
    }

    private void renderParticle(VertexConsumer consumer, Camera camera, float delta, Quaternionf quaternion) {
        Vec3 vec3 = camera.m_90583_();
        Vec3 vec32 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (vec3.m_82554_(vec32) >= (double)MonstrometerBlock.getParticleViewRange()) {
            return;
        }
        Vector3f[] veca = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vec = veca[i];
            quaternion.transform(vec);
            vec.mul(this.m_5902_(delta));
            float f = (float)(Mth.m_14139_((double)delta, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
            float f1 = (float)(Mth.m_14139_((double)delta, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
            float f2 = (float)(Mth.m_14139_((double)delta, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
            vec.add(f, f1, f2);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int j = this.m_6355_(delta);
        consumer.m_5483_((double)veca[0].x(), (double)veca[0].y(), (double)veca[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[1].x(), (double)veca[1].y(), (double)veca[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[2].x(), (double)veca[2].y(), (double)veca[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        consumer.m_5483_((double)veca[3].x(), (double)veca[3].y(), (double)veca[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float tint) {
        return Math.max(50, super.m_6355_(tint));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            return new ImpactParticle(clientLevel, d, e, f, this.sprites);
        }
    }
}

