/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import com.github.alexmodguy.alexscaves.server.misc.ACSimplexNoise;
import com.github.alexthe666.citadel.animation.Animation;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ACMath {
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final Direction[] NOT_UP_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    public static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    public static final float QUARTER_PI = 0.7853982f;

    public static float smin(float a, float b, float k) {
        float h = Math.max(k - Math.abs(a - b), 0.0f) / k;
        return Math.min(a, b) - h * h * k * 0.25f;
    }

    public static float cullAnimationTick(int tick, float amplitude, Animation animation, float partialTick, int startOffset) {
        return ACMath.cullAnimationTick(tick, amplitude, animation, partialTick, startOffset, animation.getDuration() - startOffset);
    }

    public static float cullAnimationTick(int tick, float amplitude, Animation animation, float partialTick, int startOffset, int endAt) {
        float i = Mth.m_14036_((float)((float)tick + partialTick - (float)startOffset), (float)0.0f, (float)endAt);
        float f = (float)Math.sin((double)(i / (float)endAt) * Math.PI) * amplitude;
        return ACMath.smin(f, 1.0f, 0.1f);
    }

    public static float sampleNoise2D(int x, int z, float simplexSampleRate) {
        return (float)ACSimplexNoise.noise(((float)x + simplexSampleRate) / simplexSampleRate, ((float)z + simplexSampleRate) / simplexSampleRate);
    }

    public static float sampleNoise3D(int x, int y, int z, float simplexSampleRate) {
        return (float)ACSimplexNoise.noise(((float)x + simplexSampleRate) / simplexSampleRate, ((float)y + simplexSampleRate) / simplexSampleRate, ((float)z + simplexSampleRate) / simplexSampleRate);
    }

    public static float sampleNoise3D(float x, float y, float z, float simplexSampleRate) {
        return (float)ACSimplexNoise.noise((x + simplexSampleRate) / simplexSampleRate, (y + simplexSampleRate) / simplexSampleRate, (z + simplexSampleRate) / simplexSampleRate);
    }

    public static VoxelShape buildShape(VoxelShape ... from) {
        return Stream.of(from).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    public static float walkValue(float limbSwing, float limbSwingAmount, float speed, float offset, float degree, boolean inverse) {
        return (float)(Math.cos(limbSwing * speed + offset) * (double)degree * (double)limbSwingAmount * (double)(inverse ? -1 : 1));
    }

    public static float approachRotation(float current, float target, float max) {
        float f = Mth.m_14177_((float)(target - current));
        if (f > max) {
            f = max;
        }
        if (f < -max) {
            f = -max;
        }
        return Mth.m_14177_((float)(current + f));
    }

    public static Vec3 getGroundBelowPosition(BlockGetter level, Vec3 in) {
        Vec3 modIn;
        Optional closest;
        BlockPos pos = BlockPos.m_274446_((Position)in);
        while (pos.m_123342_() > level.m_141937_() && level.m_8055_(pos).m_60812_(level, pos).m_83281_()) {
            pos = pos.m_7495_();
        }
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60812_(level, pos);
        float top = shape.m_83281_() ? 0.0f : ((closest = shape.m_166067_(modIn = new Vec3(in.f_82479_ % 1.0, 1.0, in.f_82481_ % 1.0))).isPresent() ? (float)((Vec3)closest.get()).f_82480_ : 0.0f);
        return Vec3.m_82514_((Vec3i)pos, (double)top);
    }

    public static Vec3 readVec3(FriendlyByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static FriendlyByteBuf writeVec3(FriendlyByteBuf buf, Vec3 vec3) {
        buf.writeDouble(vec3.m_7096_());
        buf.writeDouble(vec3.m_7098_());
        buf.writeDouble(vec3.m_7094_());
        return buf;
    }

    public static float approachDegreesNoWrap(float from, float to, float by) {
        float f = (to - from) % 360.0f;
        return Mth.m_14121_((float)from, (float)(from + f), (float)by);
    }

    public static Set<Holder<Biome>> getBiomesWithinAtY(BiomeSource biomeSource, int x, int y, int z, int xzDist, Climate.Sampler sampler) {
        int i = QuartPos.m_175400_((int)(x - xzDist));
        int j = QuartPos.m_175400_((int)y);
        int k = QuartPos.m_175400_((int)(z - xzDist));
        int l = QuartPos.m_175400_((int)(x + xzDist));
        int j1 = QuartPos.m_175400_((int)(z + xzDist));
        int k1 = l - i + 1;
        int i2 = j1 - k + 1;
        HashSet set = Sets.newHashSet();
        for (int j2 = 0; j2 < i2; ++j2) {
            for (int k2 = 0; k2 < k1; ++k2) {
                int i3 = i + k2;
                int k3 = k + j2;
                set.add(biomeSource.m_203407_(i3, j, k3, sampler));
            }
        }
        return set;
    }
}

